/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.List;
import java.util.Map;
import org.alfresco.heartbeat.ModelUsageDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.dictionary.CustomModelsInfo;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.transaction.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ModelUsageDataCollectorTest {
    private ModelUsageDataCollector usageModelCollector;
    private HBDataCollectorService mockCollectorService;
    private DescriptorDAO mockDescriptorDAO;
    private List<HBData> collectedData;
    private HeartBeatJobScheduler mockScheduler;

    @Before
    public void setUp() {
        this.mockDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        Descriptor mockDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)mockDescriptor.getId()).thenReturn((Object)"mock_id");
        Mockito.when((Object)this.mockDescriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        CustomModelsInfo mockCustomModelsInfo = (CustomModelsInfo)Mockito.mock(CustomModelsInfo.class);
        CustomModelService customModelService = (CustomModelService)Mockito.mock(CustomModelService.class);
        Mockito.when((Object)customModelService.getCustomModelsInfo()).thenReturn((Object)mockCustomModelsInfo);
        TransactionService mockTransactionService = (TransactionService)Mockito.mock(TransactionService.class);
        RetryingTransactionHelper mockRetryingTransactionHelper = (RetryingTransactionHelper)Mockito.mock(RetryingTransactionHelper.class);
        Mockito.when((Object)mockRetryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)mockCustomModelsInfo);
        Mockito.when((Object)mockTransactionService.getRetryingTransactionHelper()).thenReturn((Object)mockRetryingTransactionHelper);
        this.usageModelCollector = new ModelUsageDataCollector("acs.repository.usage.model", "1.0", "0 0 0 ? * *", this.mockScheduler);
        this.usageModelCollector.setHbDataCollectorService(this.mockCollectorService);
        this.usageModelCollector.setCurrentRepoDescriptorDAO(this.mockDescriptorDAO);
        this.usageModelCollector.setCustomModelService(customModelService);
        this.usageModelCollector.setTransactionService(mockTransactionService);
        this.collectedData = this.usageModelCollector.collectData();
    }

    @Test
    public void testHBDataFields() {
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
        }
    }

    @Test
    public void testModelUsageDataIsCollected() {
        HBData modelUsage = this.grabDataByCollectorId(this.usageModelCollector.getCollectorId());
        Assert.assertNotNull((String)"Model usage data missing.", (Object)modelUsage);
        Map data = modelUsage.getData();
        Assert.assertTrue((boolean)data.containsKey("numOfActiveModels"));
        Assert.assertTrue((boolean)data.containsKey("numOfActiveTypes"));
        Assert.assertTrue((boolean)data.containsKey("numOfActiveAspects"));
    }

    private HBData grabDataByCollectorId(String collectorId) {
        for (HBData d : this.collectedData) {
            if (d.getCollectorId() == null || !d.getCollectorId().equals(collectorId)) continue;
            return d;
        }
        return null;
    }
}

