/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.InputStream;
import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.util.FileCopyUtils;

@Category(value={OwnJVMTestsCategory.class})
public class SpoofedTextContentReaderTest
extends TestCase {
    @Before
    public void before() {
    }

    public void testStaticUrlHandlingErr() {
        try {
            SpoofedTextContentReader.createContentUrl(null, (long)12345L, (long)1024L, (String[])new String[0]);
            SpoofedTextContentReaderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)-1L, (String[])new String[0]);
            SpoofedTextContentReaderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)1024L, (String[])new String[]{null});
            SpoofedTextContentReaderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            SpoofedTextContentReader.createContentUrl((Locale)Locale.FRENCH, (long)12345L, (long)1024L, (String[])new String[0]);
            SpoofedTextContentReaderTest.fail();
        }
        catch (RuntimeException runtimeException) {}
        try {
            SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)1024L, (String[])new String[]{"1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ", "1234567890ABCDEFGHIJ"});
            SpoofedTextContentReaderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testStaticUrlForm_01() {
        String url = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)1024L, (String[])new String[]{"harry"});
        SpoofedTextContentReaderTest.assertTrue((boolean)url.startsWith("spoof://{"));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"locale\":\"en\""));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"seed\":\"12345\""));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"size\":\"1024\""));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"words\":[\"harry\"]"));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.endsWith("}"));
        SpoofedTextContentReader reader = new SpoofedTextContentReader(url);
        SpoofedTextContentReaderTest.assertNotNull((Object)reader.getTextGenerator());
        SpoofedTextContentReaderTest.assertEquals((Object)Locale.ENGLISH, (Object)reader.getLocale());
        SpoofedTextContentReaderTest.assertEquals((String)"text/plain", (String)reader.getMimetype());
        SpoofedTextContentReaderTest.assertEquals((String)"UTF-8", (String)reader.getEncoding());
        SpoofedTextContentReaderTest.assertEquals((long)12345L, (long)reader.getSeed());
        SpoofedTextContentReaderTest.assertEquals((long)1024L, (long)reader.getSize());
        SpoofedTextContentReaderTest.assertNotNull((Object)reader.getWords());
        SpoofedTextContentReaderTest.assertEquals((int)1, (int)reader.getWords().length);
        SpoofedTextContentReaderTest.assertEquals((String)"harry", (String)reader.getWords()[0]);
    }

    public void testStaticUrlForm_02() {
        String url = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)1024L, (String[])new String[0]);
        SpoofedTextContentReaderTest.assertTrue((boolean)url.startsWith("spoof://{"));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"locale\":\"en\""));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"seed\":\"12345\""));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"size\":\"1024\""));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.contains("\"words\":[]"));
        SpoofedTextContentReaderTest.assertTrue((boolean)url.endsWith("}"));
        SpoofedTextContentReader reader = new SpoofedTextContentReader(url);
        SpoofedTextContentReaderTest.assertNotNull((Object)reader.getTextGenerator());
        SpoofedTextContentReaderTest.assertEquals((Object)Locale.ENGLISH, (Object)reader.getLocale());
        SpoofedTextContentReaderTest.assertEquals((String)"text/plain", (String)reader.getMimetype());
        SpoofedTextContentReaderTest.assertEquals((String)"UTF-8", (String)reader.getEncoding());
        SpoofedTextContentReaderTest.assertEquals((long)12345L, (long)reader.getSeed());
        SpoofedTextContentReaderTest.assertEquals((long)1024L, (long)reader.getSize());
        SpoofedTextContentReaderTest.assertNotNull((Object)reader.getWords());
        SpoofedTextContentReaderTest.assertEquals((int)0, (int)reader.getWords().length);
    }

    public void testGetContentString_01() {
        String url = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)56L, (String[])new String[]{"harry"});
        SpoofedTextContentReader reader = new SpoofedTextContentReader(url);
        String readerText = reader.getContentString();
        SpoofedTextContentReaderTest.assertEquals((String)"harry have voice the from countered growth invited      ", (String)readerText);
        try {
            reader.getContentString();
            SpoofedTextContentReaderTest.fail((String)"Should not be able to reread content.");
        }
        catch (ContentIOException contentIOException) {}
        reader = reader.getReader();
        SpoofedTextContentReaderTest.assertEquals((String)readerText, (String)reader.getContentString());
    }

    public void testGetContentBinary_01() throws Exception {
        String url = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)12345L, (long)56L, (String[])new String[]{"harry"});
        SpoofedTextContentReader reader = new SpoofedTextContentReader(url);
        try (InputStream is = reader.getContentInputStream();){
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)is);
            SpoofedTextContentReaderTest.assertEquals((long)56L, (long)bytes.length);
        }
        ContentReader copyOne = reader.getReader();
        ContentReader copyTwo = reader.getReader();
        SpoofedTextContentReaderTest.assertTrue((boolean)AbstractContentReader.compareContentReaders((ContentReader)copyOne, (ContentReader)copyTwo));
    }
}

