/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.identityservice.authentication.AdditionalHeadersHttpServletRequestWrapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AdditionalHeadersHttpServletRequestWrapperUnitTest {
    private static final String DEFAULT_HEADER = "default_header";
    private static final String DEFAULT_HEADER_VALUE = "default_value";
    private static final String ADDITIONAL_HEADER = "additional_header";
    private static final String ADDITIONAL_HEADER_VALUE = "additional_value";
    private static final Map<String, String> DEFAULT_HEADERS = Map.of("default_header", "default_value");
    private static final Map<String, String> ADDITIONAL_HEADERS = Map.of("additional_header", "additional_value");
    @Mock
    private HttpServletRequest request;
    private AdditionalHeadersHttpServletRequestWrapper requestWrapper;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.requestWrapper = new AdditionalHeadersHttpServletRequestWrapper(ADDITIONAL_HEADERS, this.request);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void wrapperShouldNotBeInstancedWithoutAdditionalHeaders() {
        new AdditionalHeadersHttpServletRequestWrapper(null, this.request);
    }

    @Test(expected=IllegalArgumentException.class)
    public void wrapperShouldNotBeInstancedWithoutRequestsToWrap() {
        new AdditionalHeadersHttpServletRequestWrapper(new HashMap(), null);
    }

    @Test
    public void wrapperShouldReturnAdditionalHeaderNamesOnTopOfDefaultOnes() {
        Mockito.when((Object)this.request.getHeaderNames()).thenReturn(Collections.enumeration(DEFAULT_HEADERS.keySet()));
        Enumeration headerNames = this.requestWrapper.getHeaderNames();
        Assert.assertNotNull((String)"headerNames should not be null", (Object)headerNames);
        Assert.assertTrue((String)"headerNames should not be empty", (boolean)headerNames.hasMoreElements());
        ArrayList headers = Collections.list(headerNames);
        Assert.assertEquals((String)"There should be 2 headers", (long)2L, (long)headers.size());
        Assert.assertTrue((String)"The default header should be included", (boolean)headers.contains(DEFAULT_HEADER));
        Assert.assertTrue((String)"The additional header should be included", (boolean)headers.contains(ADDITIONAL_HEADER));
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeaderNames();
    }

    @Test
    public void wrapperShouldReturnDefaultHeaderNamesIfNoAdditionalHeaders() {
        Mockito.when((Object)this.request.getHeaderNames()).thenReturn(Collections.enumeration(DEFAULT_HEADERS.keySet()));
        this.requestWrapper = new AdditionalHeadersHttpServletRequestWrapper(new HashMap(), this.request);
        Enumeration headerNames = this.requestWrapper.getHeaderNames();
        Assert.assertNotNull((String)"headerNames should not be null", (Object)headerNames);
        Assert.assertTrue((String)"headerNames should not be empty", (boolean)headerNames.hasMoreElements());
        Assert.assertEquals((String)"The returned header should be the default header", (Object)DEFAULT_HEADER, headerNames.nextElement());
        Assert.assertFalse((String)"There should be no additional headers", (boolean)headerNames.hasMoreElements());
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeaderNames();
    }

    @Test
    public void wrapperShouldReturnAdditionalHeaderNamesIfNoDefaultHeaders() {
        Mockito.when((Object)this.request.getHeaderNames()).thenReturn(null);
        Enumeration headerNames = this.requestWrapper.getHeaderNames();
        Assert.assertNotNull((String)"headerNames should not be null", (Object)headerNames);
        Assert.assertTrue((String)"headerNames should not be empty", (boolean)headerNames.hasMoreElements());
        Assert.assertEquals((String)"The returned header should be the additional header", (Object)ADDITIONAL_HEADER, headerNames.nextElement());
        Assert.assertFalse((String)"There should be no more headers", (boolean)headerNames.hasMoreElements());
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeaderNames();
    }

    @Test
    public void wrapperShouldReturnDefaultHeaderValues() {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)DEFAULT_HEADER_VALUE);
        String header = this.requestWrapper.getHeader(DEFAULT_HEADER);
        Assert.assertEquals((String)"The header should be the default one", (Object)DEFAULT_HEADER_VALUE, (Object)header);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeader(DEFAULT_HEADER);
    }

    @Test
    public void wrapperShouldReturnAdditionalHeaderValues() {
        String header = this.requestWrapper.getHeader(ADDITIONAL_HEADER);
        Assert.assertEquals((String)"The header should be the additional one", (Object)ADDITIONAL_HEADER_VALUE, (Object)header);
    }

    @Test
    public void wrapperShouldPreferAdditionalHeaderValuesToDefaultOnes() {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)DEFAULT_HEADER_VALUE);
        String overrideHeaderValue = "override";
        HashMap<String, String> overrideHeaders = new HashMap<String, String>();
        overrideHeaders.put(DEFAULT_HEADER, overrideHeaderValue);
        this.requestWrapper = new AdditionalHeadersHttpServletRequestWrapper(overrideHeaders, this.request);
        String header = this.requestWrapper.getHeader(DEFAULT_HEADER);
        Assert.assertEquals((String)"The header should have the overridden value", (Object)overrideHeaderValue, (Object)header);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeader(DEFAULT_HEADER);
    }

    @Test
    public void wrapperShouldReturnDefaultHeaderEnumeration() {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)DEFAULT_HEADER_VALUE);
        Enumeration headers = this.requestWrapper.getHeaders(DEFAULT_HEADER);
        Assert.assertNotNull((String)"The headers enumeration should not be null", (Object)headers);
        Assert.assertTrue((String)"The headers enumeration should not be empty", (boolean)headers.hasMoreElements());
        Assert.assertEquals((String)"The header should be the default one", (Object)DEFAULT_HEADER_VALUE, headers.nextElement());
        Assert.assertFalse((String)"There should be no more headers", (boolean)headers.hasMoreElements());
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeader(DEFAULT_HEADER);
    }

    @Test
    public void wrapperShouldReturnAdditionalHeaderEnumeration() {
        Enumeration headers = this.requestWrapper.getHeaders(ADDITIONAL_HEADER);
        Assert.assertNotNull((String)"The headers enumeration should not be null", (Object)headers);
        Assert.assertTrue((String)"The headers enumeration should not be empty", (boolean)headers.hasMoreElements());
        Assert.assertEquals((String)"The header should be the additional one", (Object)ADDITIONAL_HEADER_VALUE, headers.nextElement());
        Assert.assertFalse((String)"There should be no more headers", (boolean)headers.hasMoreElements());
    }

    @Test
    public void wrapperShouldPreferAdditionalHeaderEnumerationValuesToDefaultOnes() {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)DEFAULT_HEADER_VALUE);
        String overrideHeaderValue = "override";
        HashMap<String, String> overrideHeaders = new HashMap<String, String>();
        overrideHeaders.put(DEFAULT_HEADER, overrideHeaderValue);
        this.requestWrapper = new AdditionalHeadersHttpServletRequestWrapper(overrideHeaders, this.request);
        Enumeration headers = this.requestWrapper.getHeaders(DEFAULT_HEADER);
        Assert.assertNotNull((String)"The headers enumeration should not be null", (Object)headers);
        Assert.assertTrue((String)"The headers enumeration should not be empty", (boolean)headers.hasMoreElements());
        Assert.assertEquals((String)"The header should be the overridden one", (Object)overrideHeaderValue, headers.nextElement());
        Assert.assertFalse((String)"There should be no more headers", (boolean)headers.hasMoreElements());
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getHeader(DEFAULT_HEADER);
    }
}

