/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.MimetypeServiceAware;

public class BackingStoreAwareCacheWriter
implements ContentWriter,
MimetypeServiceAware {
    private ContentWriter cacheWriter;
    private ContentWriter bsWriter;

    public BackingStoreAwareCacheWriter(ContentWriter cacheWriter, ContentWriter bsWriter) {
        this.cacheWriter = cacheWriter;
        this.bsWriter = bsWriter;
    }

    public boolean isChannelOpen() {
        return this.cacheWriter.isChannelOpen();
    }

    public void addListener(ContentStreamListener listener) {
        this.cacheWriter.addListener(listener);
    }

    public long getSize() {
        if (!this.cacheWriter.getReader().exists()) {
            return this.bsWriter.getSize();
        }
        return this.cacheWriter.getSize();
    }

    public ContentData getContentData() {
        if (!this.cacheWriter.getReader().exists()) {
            return this.bsWriter.getContentData();
        }
        return this.cacheWriter.getContentData();
    }

    public String getContentUrl() {
        return this.cacheWriter.getContentUrl();
    }

    public String getMimetype() {
        return this.cacheWriter.getMimetype();
    }

    public void setMimetype(String mimetype) {
        this.cacheWriter.setMimetype(mimetype);
    }

    public String getEncoding() {
        return this.cacheWriter.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.cacheWriter.setEncoding(encoding);
    }

    public Locale getLocale() {
        return this.cacheWriter.getLocale();
    }

    public void setLocale(Locale locale) {
        this.cacheWriter.setLocale(locale);
    }

    public ContentReader getReader() throws ContentIOException {
        return this.cacheWriter.getReader();
    }

    public boolean isClosed() {
        return this.cacheWriter.isClosed();
    }

    public WritableByteChannel getWritableChannel() throws ContentIOException {
        return this.cacheWriter.getWritableChannel();
    }

    public FileChannel getFileChannel(boolean truncate) throws ContentIOException {
        return this.cacheWriter.getFileChannel(truncate);
    }

    public OutputStream getContentOutputStream() throws ContentIOException {
        return this.cacheWriter.getContentOutputStream();
    }

    public void putContent(ContentReader reader) throws ContentIOException {
        this.cacheWriter.putContent(reader);
    }

    public void putContent(InputStream is) throws ContentIOException {
        this.cacheWriter.putContent(is);
    }

    public void putContent(File file) throws ContentIOException {
        this.cacheWriter.putContent(file);
    }

    public void putContent(String content) throws ContentIOException {
        this.cacheWriter.putContent(content);
    }

    public void guessMimetype(String filename) {
        this.cacheWriter.guessMimetype(filename);
    }

    public void guessEncoding() {
        this.cacheWriter.guessEncoding();
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        ((MimetypeServiceAware)this.cacheWriter).setMimetypeService(mimetypeService);
    }
}

