/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2Impl;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.TransformationOptionsConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

public abstract class AbstractRenditionIntegrationTest
extends BaseSpringTest {
    @Autowired
    protected RenditionService2Impl renditionService2;
    @Autowired
    protected RenditionDefinitionRegistry2Impl renditionDefinitionRegistry2;
    @Autowired
    protected RenditionService renditionService;
    @Autowired
    protected ThumbnailRegistry thumbnailRegistry;
    @Autowired
    protected MimetypeMap mimetypeMap;
    @Autowired
    protected MimetypeService mimetypeService;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ContentService contentService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected MutableAuthenticationService authenticationService;
    @Autowired
    protected PersonService personService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected TransformServiceRegistry transformServiceRegistry;
    @Autowired
    protected LocalTransformServiceRegistry localTransformServiceRegistry;
    @Autowired
    protected TransformationOptionsConverter converter;
    @Autowired
    protected AsynchronousExtractor asynchronousExtractor;
    static String PASSWORD = "password";
    protected static final String ADMIN = "admin";
    protected static final String DOC_LIB = "doclib";
    private CronExpression origLocalTransCron;
    private CronExpression origRenditionCron;

    @BeforeClass
    public static void before() {
        System.setProperty("localTransform.core-aio.url", "http://localhost:8090/");
    }

    protected static void none() {
        System.setProperty("transform.service.enabled", "false");
        System.setProperty("local.transform.service.enabled", "false");
    }

    protected static void local() {
        System.setProperty("transform.service.enabled", "false");
        System.setProperty("local.transform.service.enabled", "true");
        System.setProperty("transformer.strict.mimetype.check", "true");
        System.setProperty("content.transformer.retryOn.different.mimetype", "true");
    }

    protected static void service() {
        System.setProperty("transform.service.enabled", "true");
        System.setProperty("local.transform.service.enabled", "false");
    }

    protected static void localService() {
        System.setProperty("transform.service.enabled", "true");
        System.setProperty("local.transform.service.enabled", "true");
    }

    @Before
    public void setUp() throws Exception {
        AbstractRenditionIntegrationTest.assertTrue((String)"The RenditionService2 needs to be enabled", (boolean)this.renditionService2.isEnabled());
        this.origLocalTransCron = this.localTransformServiceRegistry.getCronExpression();
        this.localTransformServiceRegistry.setCronExpression(null);
        boolean localTransformServiceEnabled = Boolean.parseBoolean(System.getProperty("local.transform.service.enabled"));
        this.localTransformServiceRegistry.setEnabled(localTransformServiceEnabled);
        this.localTransformServiceRegistry.afterPropertiesSet();
        if (this.transformServiceRegistry instanceof LocalTransformServiceRegistry) {
            ((LocalTransformServiceRegistry)this.transformServiceRegistry).setEnabled(localTransformServiceEnabled);
        }
        this.thumbnailRegistry.setTransformServiceRegistry(this.transformServiceRegistry);
        this.thumbnailRegistry.setLocalTransformServiceRegistry((TransformServiceRegistry)this.localTransformServiceRegistry);
        this.thumbnailRegistry.setConverter(this.converter);
        this.origRenditionCron = this.renditionDefinitionRegistry2.getCronExpression();
        this.renditionDefinitionRegistry2.setCronExpression(null);
        this.renditionDefinitionRegistry2.setTransformServiceRegistry(this.transformServiceRegistry);
        this.renditionDefinitionRegistry2.setTransformServiceRegistry((TransformServiceRegistry)this.localTransformServiceRegistry);
        this.renditionDefinitionRegistry2.afterPropertiesSet();
    }

    @After
    public void cleanUp() {
        this.localTransformServiceRegistry.setCronExpression(this.origLocalTransCron);
        this.renditionDefinitionRegistry2.setCronExpression(this.origRenditionCron);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @AfterClass
    public static void after() {
        System.clearProperty("localTransform.core-aio.url");
        System.clearProperty("transform.service.enabled");
        System.clearProperty("local.transform.service.enabled");
    }

    protected void checkRendition(String testFileName, String renditionName, boolean expectedToPass) {
        block3: {
            try {
                NodeRef sourceNodeRef = this.createSource(ADMIN, testFileName);
                this.render(ADMIN, sourceNodeRef, renditionName);
                this.waitForRendition(ADMIN, sourceNodeRef, renditionName, true);
                if (!expectedToPass) {
                    AbstractRenditionIntegrationTest.fail((String)("The " + renditionName + " rendition should NOT be supported for " + testFileName));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!expectedToPass) break block3;
                AbstractRenditionIntegrationTest.fail((String)("The " + renditionName + " rendition SHOULD be supported for " + testFileName));
            }
        }
    }

    protected void checkExtract(String testFileName, boolean expectedToPass) {
        block3: {
            try {
                NodeRef sourceNodeRef = this.createSource(ADMIN, testFileName);
                this.extract(ADMIN, sourceNodeRef);
                this.waitForExtract(ADMIN, sourceNodeRef, true);
                if (!expectedToPass) {
                    AbstractRenditionIntegrationTest.fail((String)("The extract of metadata should NOT be supported for " + testFileName));
                }
            }
            catch (AssertionFailedError assertionFailedError) {
                if (!expectedToPass) break block3;
                AbstractRenditionIntegrationTest.fail((String)("The extract of metadata SHOULD be supported for " + testFileName));
            }
        }
    }

    protected NodeRef createSource(String user, String testFileName) {
        return (NodeRef)AuthenticationUtil.runAs(() -> (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.createSource(testFileName)), (String)user);
    }

    private NodeRef createSource(String testFileName) throws FileNotFoundException {
        return this.createContentNodeFromQuickFile(testFileName);
    }

    protected void updateContent(String user, NodeRef sourceNodeRef, String testFileName) {
        AuthenticationUtil.runAs(() -> (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.updateContent(sourceNodeRef, testFileName);
            return null;
        }), (String)user);
    }

    private NodeRef updateContent(NodeRef sourceNodeRef, String testFileName) throws FileNotFoundException {
        File file = ResourceUtils.getFile((String)("classpath:quick/" + testFileName));
        this.nodeService.setProperty(sourceNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testFileName));
        ContentWriter contentWriter = this.contentService.getWriter(sourceNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype(this.mimetypeService.guessMimetype(testFileName));
        contentWriter.putContent(file);
        return sourceNodeRef;
    }

    protected void clearContent(String user, NodeRef sourceNodeRef) {
        AuthenticationUtil.runAs(() -> (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.clearContent(sourceNodeRef);
            return null;
        }), (String)user);
    }

    private void clearContent(NodeRef sourceNodeRef) {
        this.nodeService.removeProperty(sourceNodeRef, ContentModel.PROP_CONTENT);
    }

    protected void render(String user, NodeRef sourceNode, String renditionName) {
        AuthenticationUtil.runAs(() -> (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.render(sourceNode, renditionName);
            return null;
        }), (String)user);
    }

    protected void extract(String user, NodeRef sourceNode) {
        AuthenticationUtil.runAs(() -> (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.extract(sourceNode);
            return null;
        }), (String)user);
    }

    private void render(NodeRef sourceNodeRef, String renditionName) {
        this.renditionService2.render(sourceNodeRef, renditionName);
    }

    private void extract(NodeRef sourceNodeRef) {
        ContentReader reader = this.contentService.getReader(sourceNodeRef, ContentModel.PROP_CONTENT);
        this.asynchronousExtractor.extract(sourceNodeRef, reader, MetadataExtracter.OverwritePolicy.PRAGMATIC, Collections.emptyMap(), Collections.emptyMap());
    }

    protected NodeRef waitForRendition(String user, NodeRef sourceNodeRef, String renditionName, boolean shouldExist) throws AssertionFailedError {
        try {
            return (NodeRef)AuthenticationUtil.runAs(() -> this.waitForRendition(sourceNodeRef, renditionName, shouldExist), (String)user);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AssertionFailedError) {
                throw (AssertionFailedError)cause;
            }
            throw e;
        }
    }

    protected void waitForExtract(String user, NodeRef sourceNodeRef, boolean nodePropsShouldChange) throws AssertionFailedError {
        try {
            AuthenticationUtil.runAs(() -> this.waitForExtract(sourceNodeRef, nodePropsShouldChange), (String)user);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AssertionFailedError) {
                throw (AssertionFailedError)cause;
            }
            throw e;
        }
    }

    private NodeRef waitForRendition(NodeRef sourceNodeRef, String renditionName, boolean shouldExist) throws InterruptedException {
        long maxMillis = 10000L;
        ChildAssociationRef assoc = null;
        int i = (int)(maxMillis / 1000L);
        while (i >= 0) {
            assoc = (ChildAssociationRef)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.renditionService2.getRenditionByName(sourceNodeRef, renditionName), true, true);
            if (assoc != null) break;
            this.logger.debug((Object)("RenditionService2.getRenditionByName(...) sleep " + i));
            Thread.sleep(1000L);
            --i;
        }
        if (shouldExist) {
            AbstractRenditionIntegrationTest.assertNotNull((String)("Rendition " + renditionName + " failed"), assoc);
            return assoc.getChildRef();
        }
        AbstractRenditionIntegrationTest.assertNull((String)("Rendition " + renditionName + " did not fail"), assoc);
        return null;
    }

    private Object waitForExtract(NodeRef sourceNodeRef, boolean nodePropsShouldChange) throws InterruptedException {
        long maxMillis = 5000L;
        boolean nodeModified = true;
        int i = (int)(maxMillis / 1000L);
        while (i >= 0) {
            nodeModified = (Boolean)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                Serializable modified;
                Serializable created = this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_CREATED);
                return !created.equals(modified = this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_MODIFIED));
            }, true, true);
            if (nodeModified) break;
            this.logger.debug((Object)("waitForExtract sleep " + i));
            Thread.sleep(1000L);
            --i;
        }
        if (nodePropsShouldChange) {
            AbstractRenditionIntegrationTest.assertTrue((String)"Extract failed", (boolean)nodeModified);
        } else {
            AbstractRenditionIntegrationTest.assertFalse((String)"Extract did not fail", (boolean)nodeModified);
        }
        return null;
    }

    protected String getTestFileName(String sourceMimetype) throws FileNotFoundException {
        String testFileName;
        String extension = this.mimetypeMap.getExtension(sourceMimetype);
        String string = testFileName = extension.equals("bin") ? null : "quick." + extension;
        if (testFileName != null) {
            try {
                ResourceUtils.getFile((String)("classpath:quick/" + testFileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                testFileName = null;
            }
        }
        return testFileName;
    }

    NodeRef createContentNodeFromQuickFile(String fileName) throws FileNotFoundException {
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef folderNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)(this.getName() + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        File file = ResourceUtils.getFile((String)("classpath:quick/" + fileName));
        NodeRef contentRef = this.nodeService.createNode(folderNodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, fileName)).getChildRef();
        ContentWriter contentWriter = this.contentService.getWriter(contentRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype(this.mimetypeService.guessMimetype(fileName));
        contentWriter.putContent(file);
        return contentRef;
    }

    static String generateNewUsernameString() {
        return "user-" + GUID.generate();
    }

    String createRandomUser() {
        return (String)AuthenticationUtil.runAs(() -> {
            String username = AbstractRenditionIntegrationTest.generateNewUsernameString();
            this.createUser(username);
            return username;
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    void createUser(String username) {
        this.createUser(username, "firstName", "lastName", "jobTitle", 0L);
    }

    void createUser(String username, String firstName, String lastName, String jobTitle, long quota) {
        RetryingTransactionHelper.RetryingTransactionCallback createUserCallback = () -> {
            this.authenticationService.createAuthentication(username, PASSWORD.toCharArray());
            PropertyMap personProperties = new PropertyMap();
            personProperties.put((Object)ContentModel.PROP_USERNAME, (Object)username);
            personProperties.put((Object)ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Object)("title" + username));
            personProperties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)firstName);
            personProperties.put((Object)ContentModel.PROP_LASTNAME, (Object)lastName);
            personProperties.put((Object)ContentModel.PROP_EMAIL, (Object)(username + "@example.com"));
            personProperties.put((Object)ContentModel.PROP_JOBTITLE, (Object)jobTitle);
            if (quota > 0L) {
                personProperties.put((Object)ContentModel.PROP_SIZE_QUOTA, (Object)quota);
            }
            this.personService.createPerson((Map)personProperties);
            return null;
        };
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.doInTransaction(createUserCallback);
    }

    protected boolean isValidRenditionContentHashCode(int contentHashCode) {
        return contentHashCode != -2 && contentHashCode != -1;
    }

    protected int getRenditionContentHashCode(NodeRef renditionNodeRef) {
        int renditionContentHashCode = -2;
        if (renditionNodeRef != null) {
            Serializable hashCode = this.nodeService.getProperty(renditionNodeRef, RenditionModel.PROP_RENDITION_CONTENT_HASH_CODE);
            renditionContentHashCode = hashCode == null ? -1 : (Integer)hashCode;
        }
        return renditionContentHashCode;
    }
}

