/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.admin;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.State;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.external.AdminConsoleAuthenticator;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceMetadataKey;
import org.alfresco.repo.security.authentication.identityservice.admin.AdminConsoleAuthenticationCookiesService;
import org.alfresco.repo.security.authentication.identityservice.admin.AdminConsoleHttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.util.UriComponentsBuilder;

public class IdentityServiceAdminConsoleAuthenticator
implements AdminConsoleAuthenticator,
ActivateableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityServiceAdminConsoleAuthenticator.class);
    private static final String ALFRESCO_ACCESS_TOKEN = "ALFRESCO_ACCESS_TOKEN";
    private static final String ALFRESCO_REFRESH_TOKEN = "ALFRESCO_REFRESH_TOKEN";
    private static final String ALFRESCO_TOKEN_EXPIRATION = "ALFRESCO_TOKEN_EXPIRATION";
    private IdentityServiceConfig identityServiceConfig;
    private IdentityServiceFacade identityServiceFacade;
    private AdminConsoleAuthenticationCookiesService cookiesService;
    private RemoteUserMapper remoteUserMapper;
    private boolean isEnabled;

    @Override
    public String getAdminConsoleUser(HttpServletRequest request, HttpServletResponse response) {
        String username = this.remoteUserMapper.getRemoteUser(request);
        if (username != null) {
            return username;
        }
        String bearerToken = this.cookiesService.getCookie(ALFRESCO_ACCESS_TOKEN, request);
        if (bearerToken != null) {
            bearerToken = this.refreshTokenIfNeeded(request, response, bearerToken);
        } else {
            String code = request.getParameter("code");
            if (code != null) {
                bearerToken = this.retrieveTokenUsingAuthCode(request, response, code);
            }
        }
        if (bearerToken == null) {
            return null;
        }
        return this.remoteUserMapper.getRemoteUser(this.decorateBearerHeader(bearerToken, request));
    }

    @Override
    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) {
        this.respondWithAuthChallenge(request, response);
    }

    private void respondWithAuthChallenge(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Responding with the authentication challenge");
            }
            response.sendRedirect(this.getAuthenticationRequest(request));
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to respond with the authentication challenge: {}", (Object)e.getMessage(), (Object)e);
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private String retrieveTokenUsingAuthCode(HttpServletRequest request, HttpServletResponse response, String code) {
        String bearerToken;
        block3: {
            bearerToken = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieving a response using the Authorization Code at the Token Endpoint");
            }
            try {
                IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.authorizationCode(code, request.getRequestURL().toString()));
                this.addCookies(response, accessTokenAuthorization);
                bearerToken = accessTokenAuthorization.getAccessToken().getTokenValue();
            }
            catch (IdentityServiceFacade.AuthorizationException exception) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn("Error while trying to retrieve a response using the Authorization Code at the Token Endpoint: {}", (Object)exception.getMessage());
            }
        }
        return bearerToken;
    }

    private String refreshTokenIfNeeded(HttpServletRequest request, HttpServletResponse response, String bearerToken) {
        String refreshToken = this.cookiesService.getCookie(ALFRESCO_REFRESH_TOKEN, request);
        String authTokenExpiration = this.cookiesService.getCookie(ALFRESCO_TOKEN_EXPIRATION, request);
        try {
            if (IdentityServiceAdminConsoleAuthenticator.isAuthTokenExpired(authTokenExpiration)) {
                bearerToken = this.refreshAuthToken(refreshToken, response);
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error while trying to refresh Auth Token: {}", (Object)e.getMessage());
            }
            bearerToken = null;
            this.resetCookies(response);
        }
        return bearerToken;
    }

    private void addCookies(HttpServletResponse response, IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization) {
        this.cookiesService.addCookie(ALFRESCO_ACCESS_TOKEN, accessTokenAuthorization.getAccessToken().getTokenValue(), response);
        this.cookiesService.addCookie(ALFRESCO_TOKEN_EXPIRATION, String.valueOf(accessTokenAuthorization.getAccessToken().getExpiresAt().toEpochMilli()), response);
        this.cookiesService.addCookie(ALFRESCO_REFRESH_TOKEN, accessTokenAuthorization.getRefreshTokenValue(), response);
    }

    private String getAuthenticationRequest(HttpServletRequest request) {
        ClientRegistration clientRegistration = this.identityServiceFacade.getClientRegistration();
        State state = new State();
        UriComponentsBuilder authRequestBuilder = UriComponentsBuilder.fromUriString((String)clientRegistration.getProviderDetails().getAuthorizationUri()).queryParam("client_id", new Object[]{clientRegistration.getClientId()}).queryParam("redirect_uri", new Object[]{this.getRedirectUri(request.getRequestURL().toString())}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{String.join((CharSequence)"+", this.getScopes(clientRegistration))}).queryParam("state", new Object[]{state.toString()});
        if (StringUtils.isNotBlank((String)this.identityServiceConfig.getAudience())) {
            authRequestBuilder.queryParam("audience", new Object[]{this.identityServiceConfig.getAudience()});
        }
        return authRequestBuilder.build().toUriString();
    }

    private Set<String> getScopes(ClientRegistration clientRegistration) {
        return Optional.ofNullable(clientRegistration.getProviderDetails()).map(ClientRegistration.ProviderDetails::getConfigurationMetadata).map(metadata -> metadata.get(IdentityServiceMetadataKey.SCOPES_SUPPORTED.getValue())).filter(Scope.class::isInstance).map(Scope.class::cast).map(this::getSupportedScopes).orElse(clientRegistration.getScopes());
    }

    private Set<String> getSupportedScopes(Scope scopes) {
        return scopes.stream().filter(this::hasAdminConsoleScope).map(Identifier::getValue).collect(Collectors.toSet());
    }

    private boolean hasAdminConsoleScope(Scope.Value scope) {
        return this.identityServiceConfig.getAdminConsoleScopes().contains(scope.getValue());
    }

    private String getRedirectUri(String requestURL) {
        try {
            URI originalUri = new URI(requestURL);
            URI redirectUri = new URI(originalUri.getScheme(), originalUri.getAuthority(), this.identityServiceConfig.getAdminConsoleRedirectPath(), originalUri.getQuery(), originalUri.getFragment());
            return redirectUri.toASCIIString();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error while trying to get the redirect URI and respond with the authentication challenge: {}", (Object)e.getMessage(), (Object)e);
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private void resetCookies(HttpServletResponse response) {
        this.cookiesService.resetCookie(ALFRESCO_TOKEN_EXPIRATION, response);
        this.cookiesService.resetCookie(ALFRESCO_ACCESS_TOKEN, response);
        this.cookiesService.resetCookie(ALFRESCO_REFRESH_TOKEN, response);
    }

    private String refreshAuthToken(String refreshToken, HttpServletResponse response) {
        IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.doRefreshAuthToken(refreshToken);
        this.addCookies(response, accessTokenAuthorization);
        return accessTokenAuthorization.getAccessToken().getTokenValue();
    }

    private IdentityServiceFacade.AccessTokenAuthorization doRefreshAuthToken(String refreshToken) {
        IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.refreshToken(refreshToken));
        if (accessTokenAuthorization == null || accessTokenAuthorization.getAccessToken() == null) {
            throw new AuthenticationException("AccessTokenResponse is null or empty");
        }
        return accessTokenAuthorization;
    }

    private static boolean isAuthTokenExpired(String authTokenExpiration) {
        return Instant.now().compareTo(Instant.ofEpochMilli(Long.parseLong(authTokenExpiration))) >= 0;
    }

    private HttpServletRequest decorateBearerHeader(String authToken, HttpServletRequest servletRequest) {
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("Authorization", "Bearer " + authToken);
        return new AdminConsoleHttpServletRequestWrapper(additionalHeaders, servletRequest);
    }

    public void setIdentityServiceFacade(IdentityServiceFacade identityServiceFacade) {
        this.identityServiceFacade = identityServiceFacade;
    }

    public void setRemoteUserMapper(RemoteUserMapper remoteUserMapper) {
        this.remoteUserMapper = remoteUserMapper;
    }

    public void setCookiesService(AdminConsoleAuthenticationCookiesService cookiesService) {
        this.cookiesService = cookiesService;
    }

    public void setIdentityServiceConfig(IdentityServiceConfig identityServiceConfig) {
        this.identityServiceConfig = identityServiceConfig;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled;
    }

    public void setActive(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

