/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.permissions.FixedAclUpdater;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityServiceImpl;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServicePolicies;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure1;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure11;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure13;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure15;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure17;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure19;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure21;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure23;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure25;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure27;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure29;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure3;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure31;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure33;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure35;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure37;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure39;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure41;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure43;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure45;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure47;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure49;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure5;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure51;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure53;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure55;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure57;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure59;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure61;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure63;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure65;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure67;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure69;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure7;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure71;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure73;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure75;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure77;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure79;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl$AjcClosure9;
import org.alfresco.repo.security.permissions.impl.PermissionsDaoComponent;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.traitextender.PermissionServiceExtension;
import org.alfresco.repo.security.permissions.impl.traitextender.PermissionServiceTrait;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionContext;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.PolicyIgnoreUtil;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class PermissionServiceImpl
extends AbstractLifecycleBean
implements PermissionServiceSPI,
Extensible {
    static SimplePermissionReference OLD_ALL_PERMISSIONS_REFERENCE;
    private static Log log;
    protected SimpleCache<Serializable, AccessStatus> accessCache;
    protected SimpleCache<Serializable, Set<String>> readersCache;
    protected SimpleCache<Serializable, Set<String>> readersDeniedCache;
    protected ModelDAO modelDAO;
    protected PermissionsDaoComponent permissionsDaoComponent;
    protected NodeService nodeService;
    protected TenantService tenantService;
    protected DictionaryService dictionaryService;
    protected OwnableService ownableService;
    protected AuthorityService authorityService;
    protected List<DynamicAuthority> dynamicAuthorities;
    protected PolicyComponent policyComponent;
    protected AclDAO aclDaoComponent;
    protected PermissionReference allPermissionReference;
    protected FixedAclUpdater fixedAclUpdater;
    protected boolean anyDenyDenies = false;
    private final ExtendedTrait<PermissionServiceTrait> permissionServiceTrait = new ExtendedTrait<PermissionServiceTrait>(AJProxyTrait.create(this, PermissionServiceTrait.class));
    private ClassPolicyDelegate<PermissionServicePolicies.OnGrantLocalPermission> onGrantLocalPermissionDelegate;
    private ClassPolicyDelegate<PermissionServicePolicies.OnRevokeLocalPermission> onRevokeLocalPermissionDelegate;
    private ClassPolicyDelegate<PermissionServicePolicies.OnInheritPermissionsEnabled> onInheritPermissionsEnabledDelegate;
    private ClassPolicyDelegate<PermissionServicePolicies.OnInheritPermissionsDisabled> onInheritPermissionsDisabledDelegate;
    private PolicyIgnoreUtil policyIgnoreUtil;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ Annotation ajc$anno$20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ Annotation ajc$anno$21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ Annotation ajc$anno$22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ Annotation ajc$anno$23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ Annotation ajc$anno$24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ Annotation ajc$anno$25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ Annotation ajc$anno$26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ Annotation ajc$anno$27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ Annotation ajc$anno$28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ Annotation ajc$anno$29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ Annotation ajc$anno$30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ Annotation ajc$anno$31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ Annotation ajc$anno$32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ Annotation ajc$anno$33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ Annotation ajc$anno$34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ Annotation ajc$anno$35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ Annotation ajc$anno$36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ Annotation ajc$anno$37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ Annotation ajc$anno$38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ Annotation ajc$anno$39;

    static {
        PermissionServiceImpl.ajc$preClinit();
        OLD_ALL_PERMISSIONS_REFERENCE = new SimplePermissionReference(QName.createQName((String)"", (String)"All"), "All");
        log = LogFactory.getLog(PermissionServiceImpl.class);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAnyDenyDenies(boolean anyDenyDenies) {
        this.anyDenyDenies = anyDenyDenies;
        this.accessCache.clear();
        this.readersCache.clear();
        this.readersDeniedCache.clear();
    }

    public boolean getAnyDenyDenies() {
        return this.anyDenyDenies;
    }

    public void setModelDAO(ModelDAO modelDAO) {
        this.modelDAO = modelDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPermissionsDaoComponent(PermissionsDaoComponent permissionsDaoComponent) {
        this.permissionsDaoComponent = permissionsDaoComponent;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDynamicAuthorities(List<DynamicAuthority> dynamicAuthorities) {
        this.dynamicAuthorities = dynamicAuthorities;
    }

    public void setAclDAO(AclDAO aclDaoComponent) {
        this.aclDaoComponent = aclDaoComponent;
    }

    public void setFixedAclUpdater(FixedAclUpdater fixedAclUpdater) {
        this.fixedAclUpdater = fixedAclUpdater;
    }

    public void setAccessCache(SimpleCache<Serializable, AccessStatus> accessCache) {
        this.accessCache = accessCache;
    }

    public void setReadersCache(SimpleCache<Serializable, Set<String>> readersCache) {
        this.readersCache = readersCache;
    }

    public void setReadersDeniedCache(SimpleCache<Serializable, Set<String>> readersDeniedCache) {
        this.readersDeniedCache = readersDeniedCache;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setPolicyIgnoreUtil(PolicyIgnoreUtil policyIgnoreUtil) {
        this.policyIgnoreUtil = policyIgnoreUtil;
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.accessCache.clear();
    }

    public void onCreateChildAssociation(ChildAssociationRef childAssocRef) {
        this.accessCache.clear();
    }

    public void beforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        this.accessCache.clear();
    }

    protected void onBootstrap(ApplicationEvent event) {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"modelDAO", (Object)this.modelDAO);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"ownableService", (Object)this.ownableService);
        PropertyCheck.mandatory((Object)this, (String)"permissionsDaoComponent", (Object)this.permissionsDaoComponent);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"accessCache", this.accessCache);
        PropertyCheck.mandatory((Object)this, (String)"readersCache", this.readersCache);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"aclDaoComponent", (Object)this.aclDaoComponent);
        this.allPermissionReference = this.getPermissionReference("All");
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateChildAssociation"), ContentModel.TYPE_AUTHORITY_CONTAINER, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteChildAssociation"), ContentModel.TYPE_AUTHORITY_CONTAINER, (Behaviour)new JavaBehaviour(this, "beforeDeleteChildAssociation"));
        this.onGrantLocalPermissionDelegate = this.policyComponent.registerClassPolicy(PermissionServicePolicies.OnGrantLocalPermission.class);
        this.onRevokeLocalPermissionDelegate = this.policyComponent.registerClassPolicy(PermissionServicePolicies.OnRevokeLocalPermission.class);
        this.onInheritPermissionsEnabledDelegate = this.policyComponent.registerClassPolicy(PermissionServicePolicies.OnInheritPermissionsEnabled.class);
        this.onInheritPermissionsDisabledDelegate = this.policyComponent.registerClassPolicy(PermissionServicePolicies.OnInheritPermissionsDisabled.class);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public String getOwnerAuthority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        PermissionServiceImpl$AjcClosure1 permissionServiceImpl$AjcClosure1 = new PermissionServiceImpl$AjcClosure1(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = PermissionServiceImpl.class.getDeclaredMethod("getOwnerAuthority", new Class[0]).getAnnotation(Extend.class);
        }
        return (String)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public String getAllAuthorities() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        PermissionServiceImpl$AjcClosure3 permissionServiceImpl$AjcClosure3 = new PermissionServiceImpl$AjcClosure3(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = PermissionServiceImpl.class.getDeclaredMethod("getAllAuthorities", new Class[0]).getAnnotation(Extend.class);
        }
        return (String)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public String getAllPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        PermissionServiceImpl$AjcClosure5 permissionServiceImpl$AjcClosure5 = new PermissionServiceImpl$AjcClosure5(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = PermissionServiceImpl.class.getDeclaredMethod("getAllPermission", new Class[0]).getAnnotation(Extend.class);
        }
        return (String)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<AccessPermission> getPermissions(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure7 permissionServiceImpl$AjcClosure7 = new PermissionServiceImpl$AjcClosure7(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = PermissionServiceImpl.class.getDeclaredMethod("getPermissions", NodeRef.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<AccessPermission> getAllSetPermissions(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure9 permissionServiceImpl$AjcClosure9 = new PermissionServiceImpl$AjcClosure9(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = PermissionServiceImpl.class.getDeclaredMethod("getAllSetPermissions", NodeRef.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<AccessPermission> getAllSetPermissions(StoreRef storeRef) {
        StoreRef storeRef2 = storeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)storeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, storeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure11 permissionServiceImpl$AjcClosure11 = new PermissionServiceImpl$AjcClosure11(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = PermissionServiceImpl.class.getDeclaredMethod("getAllSetPermissions", StoreRef.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected Set<AccessPermission> getAllPermissionsImpl(NodeRef nodeRef, boolean includeTrue, boolean includeFalse) {
        String userName = AuthenticationUtil.getRunAsUser();
        HashSet<AccessPermission> accessPermissions = new HashSet<AccessPermission>();
        for (PermissionReference pr : this.getSettablePermissionReferences(nodeRef)) {
            if (this.hasPermission(nodeRef, pr) == AccessStatus.ALLOWED) {
                accessPermissions.add(new AccessPermissionImpl(this.getPermission(pr), AccessStatus.ALLOWED, userName, -1));
                continue;
            }
            if (!includeFalse) continue;
            accessPermissions.add(new AccessPermissionImpl(this.getPermission(pr), AccessStatus.DENIED, userName, -1));
        }
        return accessPermissions;
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<String> getSettablePermissions(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure13 permissionServiceImpl$AjcClosure13 = new PermissionServiceImpl$AjcClosure13(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure13.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = PermissionServiceImpl.class.getDeclaredMethod("getSettablePermissions", NodeRef.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<String> getSettablePermissions(QName type) {
        QName qName = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)qName);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, qName, joinPoint};
        PermissionServiceImpl$AjcClosure15 permissionServiceImpl$AjcClosure15 = new PermissionServiceImpl$AjcClosure15(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure15.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = PermissionServiceImpl.class.getDeclaredMethod("getSettablePermissions", QName.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public NodePermissionEntry getSetPermissions(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure17 permissionServiceImpl$AjcClosure17 = new PermissionServiceImpl$AjcClosure17(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure17.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = PermissionServiceImpl.class.getDeclaredMethod("getSetPermissions", NodeRef.class).getAnnotation(Extend.class);
        }
        return (NodePermissionEntry)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public NodePermissionEntry getSetPermissions(StoreRef storeRef) {
        StoreRef storeRef2 = storeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)storeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, storeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure19 permissionServiceImpl$AjcClosure19 = new PermissionServiceImpl$AjcClosure19(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure19.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = PermissionServiceImpl.class.getDeclaredMethod("getSetPermissions", StoreRef.class).getAnnotation(Extend.class);
        }
        return (NodePermissionEntry)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public AccessStatus hasPermission(NodeRef passedNodeRef, PermissionReference permIn) {
        NodeRef nodeRef = passedNodeRef;
        PermissionReference permissionReference = permIn;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)nodeRef, (Object)permissionReference);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, permissionReference, joinPoint};
        PermissionServiceImpl$AjcClosure21 permissionServiceImpl$AjcClosure21 = new PermissionServiceImpl$AjcClosure21(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure21.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = PermissionServiceImpl.class.getDeclaredMethod("hasPermission", NodeRef.class, PermissionReference.class).getAnnotation(Extend.class);
        }
        return (AccessStatus)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public AccessStatus hasPermission(Long aclID, PermissionContext context, String permission) {
        Long l = aclID;
        PermissionContext permissionContext = context;
        String string = permission;
        Object[] objectArray = new Object[]{l, permissionContext, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, l, permissionContext, string, joinPoint};
        PermissionServiceImpl$AjcClosure23 permissionServiceImpl$AjcClosure23 = new PermissionServiceImpl$AjcClosure23(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure23.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = PermissionServiceImpl.class.getDeclaredMethod("hasPermission", Long.class, PermissionContext.class, String.class).getAnnotation(Extend.class);
        }
        return (AccessStatus)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected AccessStatus hasPermission(Long aclId, PermissionContext context, PermissionReference permission) {
        boolean result;
        if (aclId == null) {
            HashSet aspectQNames;
            if (context.getStoreAcl() == null) {
                return AccessStatus.ALLOWED;
            }
            if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
                return AccessStatus.ALLOWED;
            }
            Authentication auth = AuthenticationUtil.getRunAsAuthentication();
            if (auth == null) {
                throw new IllegalStateException("Unauthenticated");
            }
            Set<String> storeAuthorisations = this.getAuthorisations(auth, null);
            QName typeQname = context.getType();
            AclTest aclTest = new AclTest(permission, typeQname, aspectQNames = context.getAspects());
            boolean result2 = aclTest.evaluate(storeAuthorisations, context.getStoreAcl(), context);
            AccessStatus status = result2 ? AccessStatus.ALLOWED : AccessStatus.DENIED;
            return status;
        }
        if (permission == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.getRunAsUser() == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.getRunAsUser().equals(AuthenticationUtil.getSystemUserName())) {
            return AccessStatus.ALLOWED;
        }
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        if (auth == null) {
            throw new IllegalStateException("Unauthenticated");
        }
        Set<String> authorisations = this.getAuthorisations(auth, context);
        final QName typeQname = context.getType();
        final HashSet aspectQNames = context.getAspects();
        Set available = (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<PermissionReference>>(){

            public Set<PermissionReference> doWork() throws Exception {
                return PermissionServiceImpl.this.modelDAO.getAllPermissions(typeQname, aspectQNames);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        available.add(this.getAllPermissionReference());
        available.add(OLD_ALL_PERMISSIONS_REFERENCE);
        if (!available.contains(permission)) {
            Set permissionsSystemBase = (Set)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<PermissionReference>>(){

                public Set<PermissionReference> doWork() throws Exception {
                    return PermissionServiceImpl.this.modelDAO.getAllPermissions(ContentModel.TYPE_BASE, aspectQNames);
                }
            });
            if (permissionsSystemBase.contains(permission) && authorisations.contains(AuthenticationUtil.getAdminRoleName())) {
                return AccessStatus.ALLOWED;
            }
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        if (permission.equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
            permission = this.getAllPermissionReference();
        }
        if (context.getStoreAcl() == null) {
            AclTest aclTest = new AclTest(permission, typeQname, aspectQNames);
            result = aclTest.evaluate(authorisations, aclId, context);
        } else {
            Set<String> storeAuthorisations = this.getAuthorisations(auth, null);
            AclTest aclTest = new AclTest(permission, typeQname, aspectQNames);
            result = aclTest.evaluate(authorisations, aclId, context) && aclTest.evaluate(storeAuthorisations, context.getStoreAcl(), context);
        }
        AccessStatus status = result ? AccessStatus.ALLOWED : AccessStatus.DENIED;
        return status;
    }

    Serializable generateKey(Set<String> auths, NodeRef nodeRef, PermissionReference perm, CacheType type) {
        LinkedHashSet<Object> key = new LinkedHashSet<Object>();
        key.add(perm.toString());
        if (auths instanceof AuthorityServiceImpl.UserAuthoritySet) {
            key.add((Serializable)((Object)Collections.singleton(((AuthorityServiceImpl.UserAuthoritySet)auths).getUsername())));
        } else {
            key.addAll(auths);
        }
        key.add(nodeRef);
        NodeRef.Status nodeStatus = this.nodeService.getNodeStatus(nodeRef);
        key.add(nodeStatus == null ? "null" : nodeStatus.getChangeTxnId());
        key.add((Object)type);
        return key;
    }

    protected Set<String> getCoreAuthorisations(Authentication auth) {
        if (auth == null) {
            return Collections.emptySet();
        }
        User user = (User)auth.getPrincipal();
        String username = user.getUsername();
        Set<String> auths = this.authorityService.getAuthoritiesForUser(username);
        auths.add(username);
        GrantedAuthority[] grantedAuthorityArray = auth.getAuthorities();
        int n = grantedAuthorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            GrantedAuthority grantedAuthority = grantedAuthorityArray[n2];
            auths.add(grantedAuthority.getAuthority());
            ++n2;
        }
        return auths;
    }

    protected Set<String> getAuthorisations(Authentication auth, NodeRef nodeRef, PermissionReference required) {
        Set<String> auths = this.getCoreAuthorisations(auth);
        if (auth != null) {
            auths.addAll(this.getDynamicAuthorities(auth, nodeRef, required));
        }
        return auths;
    }

    protected Set<String> getDynamicAuthorities(Authentication auth, NodeRef nodeRef, PermissionReference required) {
        HashSet<String> dynAuths = new HashSet<String>(64);
        User user = (User)auth.getPrincipal();
        String username = user.getUsername();
        if ((nodeRef = this.tenantService.getName(nodeRef)) != null && this.dynamicAuthorities != null) {
            for (DynamicAuthority da : this.dynamicAuthorities) {
                Set<PermissionReference> requiredFor = da.requiredFor();
                if (requiredFor != null && !requiredFor.contains(required) || !da.hasAuthority(nodeRef, username)) continue;
                dynAuths.add(da.getAuthority());
            }
        }
        return dynAuths;
    }

    protected Set<String> getAuthorisations(Authentication auth, PermissionContext context) {
        Set<String> auths = this.getCoreAuthorisations(auth);
        if (auth != null && context != null) {
            auths.addAll(this.getDynamicAuthorities(auth, context, auths));
        }
        return auths;
    }

    protected Set<String> getDynamicAuthorities(Authentication auth, PermissionContext context, Set<String> auths) {
        HashSet<String> dynAuths = new HashSet<String>();
        Map dynamicAuthorityAssignments = context.getDynamicAuthorityAssignment();
        for (String dynKey : dynamicAuthorityAssignments.keySet()) {
            Set dynos;
            if (!auths.contains(dynKey) || (dynos = (Set)dynamicAuthorityAssignments.get(dynKey)) == null) continue;
            dynAuths.addAll(dynos);
        }
        return dynAuths;
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public NodePermissionEntry explainPermission(NodeRef nodeRef, PermissionReference perm) {
        NodeRef nodeRef2 = nodeRef;
        PermissionReference permissionReference = perm;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)nodeRef2, (Object)permissionReference);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, permissionReference, joinPoint};
        PermissionServiceImpl$AjcClosure25 permissionServiceImpl$AjcClosure25 = new PermissionServiceImpl$AjcClosure25(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure25.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = PermissionServiceImpl.class.getDeclaredMethod("explainPermission", NodeRef.class, PermissionReference.class).getAnnotation(Extend.class);
        }
        return (NodePermissionEntry)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void clearPermission(StoreRef storeRef, String authority) {
        StoreRef storeRef2 = storeRef;
        String string = authority;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)storeRef2, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, storeRef2, string, joinPoint};
        PermissionServiceImpl$AjcClosure27 permissionServiceImpl$AjcClosure27 = new PermissionServiceImpl$AjcClosure27(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure27.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = PermissionServiceImpl.class.getDeclaredMethod("clearPermission", StoreRef.class, String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermission(StoreRef storeRef, String authority, String perm) {
        StoreRef storeRef2 = storeRef;
        String string = authority;
        String string2 = perm;
        Object[] objectArray = new Object[]{storeRef2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, storeRef2, string, string2, joinPoint};
        PermissionServiceImpl$AjcClosure29 permissionServiceImpl$AjcClosure29 = new PermissionServiceImpl$AjcClosure29(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure29.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = PermissionServiceImpl.class.getDeclaredMethod("deletePermission", StoreRef.class, String.class, String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected void deletePermission(StoreRef storeRef, String authority, PermissionReference perm) {
        this.permissionsDaoComponent.deletePermission(storeRef, authority, perm);
        this.accessCache.clear();
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermissions(StoreRef storeRef) {
        StoreRef storeRef2 = storeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)storeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, storeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure31 permissionServiceImpl$AjcClosure31 = new PermissionServiceImpl$AjcClosure31(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure31.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = PermissionServiceImpl.class.getDeclaredMethod("deletePermissions", StoreRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void setPermission(StoreRef storeRef, String authority, String perm, boolean allow) {
        StoreRef storeRef2 = storeRef;
        String string = authority;
        String string2 = perm;
        boolean bl = allow;
        Object[] objectArray = new Object[]{storeRef2, string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, storeRef2, string, string2, Conversions.booleanObject((boolean)bl), joinPoint};
        PermissionServiceImpl$AjcClosure33 permissionServiceImpl$AjcClosure33 = new PermissionServiceImpl$AjcClosure33(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure33.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = PermissionServiceImpl.class.getDeclaredMethod("setPermission", StoreRef.class, String.class, String.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected void setPermission(StoreRef storeRef, String authority, PermissionReference permission, boolean allow) {
        this.permissionsDaoComponent.setPermission(storeRef, authority, permission, allow);
        this.accessCache.clear();
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermissions(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure35 permissionServiceImpl$AjcClosure35 = new PermissionServiceImpl$AjcClosure35(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure35.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = PermissionServiceImpl.class.getDeclaredMethod("deletePermissions", NodeRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermissions(NodePermissionEntry nodePermissionEntry) {
        NodePermissionEntry nodePermissionEntry2 = nodePermissionEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)nodePermissionEntry2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodePermissionEntry2, joinPoint};
        PermissionServiceImpl$AjcClosure37 permissionServiceImpl$AjcClosure37 = new PermissionServiceImpl$AjcClosure37(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure37.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = PermissionServiceImpl.class.getDeclaredMethod("deletePermissions", NodePermissionEntry.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermission(PermissionEntry permissionEntry) {
        PermissionEntry permissionEntry2 = permissionEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)permissionEntry2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, permissionEntry2, joinPoint};
        PermissionServiceImpl$AjcClosure39 permissionServiceImpl$AjcClosure39 = new PermissionServiceImpl$AjcClosure39(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure39.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = PermissionServiceImpl.class.getDeclaredMethod("deletePermission", PermissionEntry.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected void deletePermission(NodeRef nodeRef, String authority, PermissionReference perm) {
        this.permissionsDaoComponent.deletePermission(this.tenantService.getName(nodeRef), authority, perm);
        this.accessCache.clear();
        this.invokeUpdateLocalPermissionsPolicy(nodeRef, authority, perm != null ? perm.getName() : null, false);
    }

    private void invokeUpdateLocalPermissionsPolicy(NodeRef nodeRef, String authority, String permission, boolean grantPermission) {
        if (!this.policyIgnoreUtil.ignorePolicy(nodeRef)) {
            if (grantPermission) {
                PermissionServicePolicies.OnGrantLocalPermission grantPermPolicy = this.onGrantLocalPermissionDelegate.get(this.nodeService.getType(nodeRef));
                grantPermPolicy.onGrantLocalPermission(nodeRef, authority, permission);
            } else {
                PermissionServicePolicies.OnRevokeLocalPermission revokePermPolicy = this.onRevokeLocalPermissionDelegate.get(this.nodeService.getType(nodeRef));
                revokePermPolicy.onRevokeLocalPermission(nodeRef, authority, permission);
            }
        }
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void clearPermission(NodeRef nodeRef, String authority) {
        NodeRef nodeRef2 = nodeRef;
        String string = authority;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)nodeRef2, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, string, joinPoint};
        PermissionServiceImpl$AjcClosure41 permissionServiceImpl$AjcClosure41 = new PermissionServiceImpl$AjcClosure41(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure41.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = PermissionServiceImpl.class.getDeclaredMethod("clearPermission", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected void setPermission(NodeRef nodeRef, String authority, PermissionReference perm, boolean allow) {
        this.permissionsDaoComponent.setPermission(this.tenantService.getName(nodeRef), authority, perm, allow);
        this.accessCache.clear();
        this.invokeUpdateLocalPermissionsPolicy(nodeRef, authority, perm.getName(), allow);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void setPermission(PermissionEntry permissionEntry) {
        PermissionEntry permissionEntry2 = permissionEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)permissionEntry2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, permissionEntry2, joinPoint};
        PermissionServiceImpl$AjcClosure43 permissionServiceImpl$AjcClosure43 = new PermissionServiceImpl$AjcClosure43(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure43.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$21;
        if (annotation == null) {
            annotation = ajc$anno$21 = PermissionServiceImpl.class.getDeclaredMethod("setPermission", PermissionEntry.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
        NodePermissionEntry nodePermissionEntry2 = nodePermissionEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)nodePermissionEntry2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodePermissionEntry2, joinPoint};
        PermissionServiceImpl$AjcClosure45 permissionServiceImpl$AjcClosure45 = new PermissionServiceImpl$AjcClosure45(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure45.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$22;
        if (annotation == null) {
            annotation = ajc$anno$22 = PermissionServiceImpl.class.getDeclaredMethod("setPermission", NodePermissionEntry.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        NodeRef nodeRef2 = nodeRef;
        boolean bl = inheritParentPermissions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)nodeRef2, (Object)Conversions.booleanObject((boolean)bl));
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, Conversions.booleanObject((boolean)bl), joinPoint};
        PermissionServiceImpl$AjcClosure47 permissionServiceImpl$AjcClosure47 = new PermissionServiceImpl$AjcClosure47(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure47.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$23;
        if (annotation == null) {
            annotation = ajc$anno$23 = PermissionServiceImpl.class.getDeclaredMethod("setInheritParentPermissions", NodeRef.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions, boolean asyncCall) {
        NodeRef nodeRef2 = nodeRef;
        boolean bl = inheritParentPermissions;
        boolean bl2 = asyncCall;
        Object[] objectArray = new Object[]{nodeRef2, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), joinPoint};
        PermissionServiceImpl$AjcClosure49 permissionServiceImpl$AjcClosure49 = new PermissionServiceImpl$AjcClosure49(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure49.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$24;
        if (annotation == null) {
            annotation = ajc$anno$24 = PermissionServiceImpl.class.getDeclaredMethod("setInheritParentPermissions", NodeRef.class, Boolean.TYPE, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private void invokeOnPermissionsInheritedPolicy(NodeRef nodeRef, boolean inheritParentPermissions, boolean async) {
        if (!this.policyIgnoreUtil.ignorePolicy(nodeRef)) {
            if (inheritParentPermissions) {
                PermissionServicePolicies.OnInheritPermissionsEnabled onInheritEnabledPolicy = this.onInheritPermissionsEnabledDelegate.get(ContentModel.TYPE_BASE);
                onInheritEnabledPolicy.onInheritPermissionsEnabled(nodeRef);
            } else {
                PermissionServicePolicies.OnInheritPermissionsDisabled onInheritDisabledPolicy = this.onInheritPermissionsDisabledDelegate.get(ContentModel.TYPE_BASE);
                onInheritDisabledPolicy.onInheritPermissionsDisabled(nodeRef, async);
            }
        }
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure51 permissionServiceImpl$AjcClosure51 = new PermissionServiceImpl$AjcClosure51(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure51.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$25;
        if (annotation == null) {
            annotation = ajc$anno$25 = PermissionServiceImpl.class.getDeclaredMethod("getInheritParentPermissions", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        QName qName = qname;
        String string = permissionName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)qName, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, qName, string, joinPoint};
        PermissionServiceImpl$AjcClosure53 permissionServiceImpl$AjcClosure53 = new PermissionServiceImpl$AjcClosure53(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure53.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$26;
        if (annotation == null) {
            annotation = ajc$anno$26 = PermissionServiceImpl.class.getDeclaredMethod("getPermissionReference", QName.class, String.class).getAnnotation(Extend.class);
        }
        return (PermissionReference)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public PermissionReference getAllPermissionReference() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        PermissionServiceImpl$AjcClosure55 permissionServiceImpl$AjcClosure55 = new PermissionServiceImpl$AjcClosure55(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure55.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$27;
        if (annotation == null) {
            annotation = ajc$anno$27 = PermissionServiceImpl.class.getDeclaredMethod("getAllPermissionReference", new Class[0]).getAnnotation(Extend.class);
        }
        return (PermissionReference)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public String getPermission(PermissionReference permissionReference) {
        PermissionReference permissionReference2 = permissionReference;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)permissionReference2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, permissionReference2, joinPoint};
        PermissionServiceImpl$AjcClosure57 permissionServiceImpl$AjcClosure57 = new PermissionServiceImpl$AjcClosure57(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure57.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$28;
        if (annotation == null) {
            annotation = ajc$anno$28 = PermissionServiceImpl.class.getDeclaredMethod("getPermission", PermissionReference.class).getAnnotation(Extend.class);
        }
        return (String)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public PermissionReference getPermissionReference(String permissionName) {
        String string = permissionName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, string, joinPoint};
        PermissionServiceImpl$AjcClosure59 permissionServiceImpl$AjcClosure59 = new PermissionServiceImpl$AjcClosure59(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure59.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$29;
        if (annotation == null) {
            annotation = ajc$anno$29 = PermissionServiceImpl.class.getDeclaredMethod("getPermissionReference", String.class).getAnnotation(Extend.class);
        }
        return (PermissionReference)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<PermissionReference> getSettablePermissionReferences(QName type) {
        QName qName = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)qName);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, qName, joinPoint};
        PermissionServiceImpl$AjcClosure61 permissionServiceImpl$AjcClosure61 = new PermissionServiceImpl$AjcClosure61(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure61.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$30;
        if (annotation == null) {
            annotation = ajc$anno$30 = PermissionServiceImpl.class.getDeclaredMethod("getSettablePermissionReferences", QName.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<PermissionReference> getSettablePermissionReferences(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure63 permissionServiceImpl$AjcClosure63 = new PermissionServiceImpl$AjcClosure63(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure63.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$31;
        if (annotation == null) {
            annotation = ajc$anno$31 = PermissionServiceImpl.class.getDeclaredMethod("getSettablePermissionReferences", NodeRef.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermission(NodeRef nodeRef, String authority, String perm) {
        NodeRef nodeRef2 = nodeRef;
        String string = authority;
        String string2 = perm;
        Object[] objectArray = new Object[]{nodeRef2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, string, string2, joinPoint};
        PermissionServiceImpl$AjcClosure65 permissionServiceImpl$AjcClosure65 = new PermissionServiceImpl$AjcClosure65(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure65.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$32;
        if (annotation == null) {
            annotation = ajc$anno$32 = PermissionServiceImpl.class.getDeclaredMethod("deletePermission", NodeRef.class, String.class, String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public AccessStatus hasPermission(NodeRef nodeRef, String perm) {
        NodeRef nodeRef2 = nodeRef;
        String string = perm;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)nodeRef2, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, string, joinPoint};
        PermissionServiceImpl$AjcClosure67 permissionServiceImpl$AjcClosure67 = new PermissionServiceImpl$AjcClosure67(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure67.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$33;
        if (annotation == null) {
            annotation = ajc$anno$33 = PermissionServiceImpl.class.getDeclaredMethod("hasPermission", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return (AccessStatus)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void setPermission(NodeRef nodeRef, String authority, String perm, boolean allow) {
        NodeRef nodeRef2 = nodeRef;
        String string = authority;
        String string2 = perm;
        boolean bl = allow;
        Object[] objectArray = new Object[]{nodeRef2, string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, string, string2, Conversions.booleanObject((boolean)bl), joinPoint};
        PermissionServiceImpl$AjcClosure69 permissionServiceImpl$AjcClosure69 = new PermissionServiceImpl$AjcClosure69(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure69.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$34;
        if (annotation == null) {
            annotation = ajc$anno$34 = PermissionServiceImpl.class.getDeclaredMethod("setPermission", NodeRef.class, String.class, String.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public void deletePermissions(String recipient) {
        String string = recipient;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, string, joinPoint};
        PermissionServiceImpl$AjcClosure71 permissionServiceImpl$AjcClosure71 = new PermissionServiceImpl$AjcClosure71(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure71.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$35;
        if (annotation == null) {
            annotation = ajc$anno$35 = PermissionServiceImpl.class.getDeclaredMethod("deletePermissions", String.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public AccessStatus hasReadPermission(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        PermissionServiceImpl$AjcClosure73 permissionServiceImpl$AjcClosure73 = new PermissionServiceImpl$AjcClosure73(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure73.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$36;
        if (annotation == null) {
            annotation = ajc$anno$36 = PermissionServiceImpl.class.getDeclaredMethod("hasReadPermission", NodeRef.class).getAnnotation(Extend.class);
        }
        return (AccessStatus)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected AccessStatus adminRead() {
        AccessStatus result = AccessStatus.DENIED;
        Set<String> authorisations = this.getAuthorisations();
        if (authorisations.contains(AuthenticationUtil.getAdminRoleName())) {
            result = AccessStatus.ALLOWED;
        }
        return result;
    }

    protected AccessStatus ownerRead(String username, NodeRef nodeRef) {
        AccessStatus result = AccessStatus.DENIED;
        String owner = this.ownableService.getOwner(nodeRef);
        if (owner == null) {
            result = AccessStatus.DENIED;
        }
        if (EqualsHelper.nullSafeEquals((Object)username, (Object)owner)) {
            return AccessStatus.ALLOWED;
        }
        return result;
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<String> getReaders(Long aclId) {
        Long l = aclId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)l);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, l, joinPoint};
        PermissionServiceImpl$AjcClosure75 permissionServiceImpl$AjcClosure75 = new PermissionServiceImpl$AjcClosure75(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure75.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$37;
        if (annotation == null) {
            annotation = ajc$anno$37 = PermissionServiceImpl.class.getDeclaredMethod("getReaders", Long.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<String> getReadersDenied(Long aclId) {
        Long l = aclId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)l);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, l, joinPoint};
        PermissionServiceImpl$AjcClosure77 permissionServiceImpl$AjcClosure77 = new PermissionServiceImpl$AjcClosure77(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure77.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$38;
        if (annotation == null) {
            annotation = ajc$anno$38 = PermissionServiceImpl.class.getDeclaredMethod("getReadersDenied", Long.class).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected AccessStatus canRead(Long aclId) {
        Set<String> authorities = this.getAuthorisations();
        if (this.anyDenyDenies) {
            Set<String> aclReadersDenied = this.getReadersDenied(aclId);
            for (String auth : aclReadersDenied) {
                if (!authorities.contains(auth)) continue;
                return AccessStatus.DENIED;
            }
        }
        Set<String> aclReaders = this.getReaders(aclId);
        for (String auth : aclReaders) {
            if (!authorities.contains(auth)) continue;
            return AccessStatus.ALLOWED;
        }
        return AccessStatus.DENIED;
    }

    protected boolean isVersionNodeRef(NodeRef nodeRef) {
        return nodeRef.getStoreRef().getProtocol().equals("versionStore") || nodeRef.getStoreRef().getIdentifier().equals("version2Store");
    }

    protected NodeRef convertVersionNodeRefToVersionedNodeRef(NodeRef versionNodeRef) {
        Map properties = this.nodeService.getProperties(versionNodeRef);
        NodeRef nodeRef = null;
        if (versionNodeRef.getStoreRef().getIdentifier().equals("version2Store")) {
            nodeRef = (NodeRef)properties.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
        } else if (versionNodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) {
            nodeRef = new NodeRef((String)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_PROTOCOL), (String)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_ID), (String)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_ID));
        }
        return nodeRef;
    }

    @Extend(traitAPI=PermissionServiceTrait.class, extensionAPI=PermissionServiceExtension.class)
    public Set<String> getAuthorisations() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        PermissionServiceImpl$AjcClosure79 permissionServiceImpl$AjcClosure79 = new PermissionServiceImpl$AjcClosure79(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = permissionServiceImpl$AjcClosure79.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$39;
        if (annotation == null) {
            annotation = ajc$anno$39 = PermissionServiceImpl.class.getDeclaredMethod("getAuthorisations", new Class[0]).getAnnotation(Extend.class);
        }
        return (Set)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    public <M extends Trait> ExtendedTrait<M> getTrait(Class<? extends M> traitAPI) {
        return this.permissionServiceTrait;
    }

    static final /* synthetic */ String getOwnerAuthority_aroundBody0(PermissionServiceImpl ajc$this, JoinPoint joinPoint) {
        return "ROLE_OWNER";
    }

    static final /* synthetic */ String getAllAuthorities_aroundBody2(PermissionServiceImpl ajc$this, JoinPoint joinPoint) {
        return "GROUP_EVERYONE";
    }

    static final /* synthetic */ String getAllPermission_aroundBody4(PermissionServiceImpl ajc$this, JoinPoint joinPoint) {
        return "All";
    }

    static final /* synthetic */ Set getPermissions_aroundBody6(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        return ajc$this.getAllPermissionsImpl(nodeRef, true, true);
    }

    static final /* synthetic */ Set getAllSetPermissions_aroundBody8(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        HashSet<AccessPermissionImpl> accessPermissions = new HashSet<AccessPermissionImpl>();
        NodePermissionEntry nodePremissionEntry = ajc$this.getSetPermissions(nodeRef);
        for (PermissionEntry permissionEntry : nodePremissionEntry.getPermissionEntries()) {
            accessPermissions.add(new AccessPermissionImpl(ajc$this.getPermission(permissionEntry.getPermissionReference()), permissionEntry.getAccessStatus(), permissionEntry.getAuthority(), permissionEntry.getPosition()));
        }
        return accessPermissions;
    }

    static final /* synthetic */ Set getAllSetPermissions_aroundBody10(PermissionServiceImpl ajc$this, StoreRef storeRef, JoinPoint joinPoint) {
        HashSet<AccessPermissionImpl> accessPermissions = new HashSet<AccessPermissionImpl>();
        NodePermissionEntry nodePremissionEntry = ajc$this.getSetPermissions(storeRef);
        for (PermissionEntry permissionEntry : nodePremissionEntry.getPermissionEntries()) {
            accessPermissions.add(new AccessPermissionImpl(ajc$this.getPermission(permissionEntry.getPermissionReference()), permissionEntry.getAccessStatus(), permissionEntry.getAuthority(), permissionEntry.getPosition()));
        }
        return accessPermissions;
    }

    static final /* synthetic */ Set getSettablePermissions_aroundBody12(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        Set<PermissionReference> settable = ajc$this.getSettablePermissionReferences(nodeRef);
        HashSet<String> strings = new HashSet<String>(settable.size());
        for (PermissionReference pr : settable) {
            strings.add(ajc$this.getPermission(pr));
        }
        return strings;
    }

    static final /* synthetic */ Set getSettablePermissions_aroundBody14(PermissionServiceImpl ajc$this, QName type, JoinPoint joinPoint) {
        Set<PermissionReference> settable = ajc$this.getSettablePermissionReferences(type);
        LinkedHashSet<String> strings = new LinkedHashSet<String>(settable.size());
        for (PermissionReference pr : settable) {
            strings.add(ajc$this.getPermission(pr));
        }
        return strings;
    }

    static final /* synthetic */ NodePermissionEntry getSetPermissions_aroundBody16(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        return ajc$this.permissionsDaoComponent.getPermissions(ajc$this.tenantService.getName(nodeRef));
    }

    static final /* synthetic */ NodePermissionEntry getSetPermissions_aroundBody18(PermissionServiceImpl ajc$this, StoreRef storeRef, JoinPoint joinPoint) {
        return ajc$this.permissionsDaoComponent.getPermissions(storeRef);
    }

    static final /* synthetic */ AccessStatus hasPermission_aroundBody20(PermissionServiceImpl ajc$this, NodeRef passedNodeRef, PermissionReference permIn, JoinPoint joinPoint) {
        if (passedNodeRef == null) {
            return AccessStatus.ALLOWED;
        }
        if (permIn == null) {
            return AccessStatus.DENIED;
        }
        if (ajc$this.isVersionNodeRef(passedNodeRef)) {
            passedNodeRef = ajc$this.convertVersionNodeRefToVersionedNodeRef(VersionUtil.convertNodeRef(passedNodeRef));
        }
        if (passedNodeRef == null || !ajc$this.nodeService.exists(passedNodeRef)) {
            return AccessStatus.ALLOWED;
        }
        final NodeRef nodeRef = ajc$this.tenantService.getName(passedNodeRef);
        final PermissionReference perm = permIn.equals(OLD_ALL_PERMISSIONS_REFERENCE) ? ajc$this.getAllPermissionReference() : permIn;
        if (AuthenticationUtil.getRunAsUser() == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        AccessControlListProperties properties = ajc$this.permissionsDaoComponent.getAccessControlListProperties(nodeRef);
        if (properties != null && properties.getAclType() != null && properties.getAclType() != ACLType.OLD) {
            QName typeQname = ajc$this.nodeService.getType(nodeRef);
            Set aspectQNames = ajc$this.nodeService.getAspects(nodeRef);
            PermissionContext context = new PermissionContext(typeQname);
            context.getAspects().addAll(aspectQNames);
            Authentication auth = AuthenticationUtil.getRunAsAuthentication();
            if (auth != null) {
                String user = AuthenticationUtil.getRunAsUser();
                for (String dynamicAuthority : ajc$this.getDynamicAuthorities(auth, nodeRef, perm)) {
                    context.addDynamicAuthorityAssignment(user, dynamicAuthority);
                }
            }
            return ajc$this.hasPermission(properties.getId(), context, perm);
        }
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        final Set<String> authorisations = ajc$this.getAuthorisations(auth, nodeRef, perm);
        Set available = (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<PermissionReference>>(){

            public Set<PermissionReference> doWork() throws Exception {
                return PermissionServiceImpl.this.modelDAO.getAllPermissions(nodeRef);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        available.add(ajc$this.getAllPermissionReference());
        available.add(OLD_ALL_PERMISSIONS_REFERENCE);
        final Serializable key = ajc$this.generateKey(authorisations, nodeRef, perm, CacheType.HAS_PERMISSION);
        if (!available.contains(perm)) {
            ajc$this.accessCache.put(key, (Object)AccessStatus.DENIED);
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        return (AccessStatus)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<AccessStatus>(){

            public AccessStatus doWork() throws Exception {
                AccessStatus status = (AccessStatus)PermissionServiceImpl.this.accessCache.get(key);
                if (status != null) {
                    return status;
                }
                QName typeQname = PermissionServiceImpl.this.nodeService.getType(nodeRef);
                Set aspectQNames = PermissionServiceImpl.this.nodeService.getAspects(nodeRef);
                NodeTest nt = new NodeTest(perm, typeQname, aspectQNames);
                boolean result = nt.evaluate(authorisations, nodeRef);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Permission <" + String.valueOf(perm) + "> is " + (result ? "allowed" : "denied") + " for " + AuthenticationUtil.getRunAsUser() + " on node " + String.valueOf(PermissionServiceImpl.this.nodeService.getPath(nodeRef))));
                }
                status = result ? AccessStatus.ALLOWED : AccessStatus.DENIED;
                PermissionServiceImpl.this.accessCache.put(key, (Object)status);
                return status;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    static final /* synthetic */ AccessStatus hasPermission_aroundBody22(PermissionServiceImpl ajc$this, Long aclID, PermissionContext context, String permission, JoinPoint joinPoint) {
        return ajc$this.hasPermission(aclID, context, ajc$this.getPermissionReference(permission));
    }

    static final /* synthetic */ NodePermissionEntry explainPermission_aroundBody24(PermissionServiceImpl ajc$this, NodeRef nodeRef, PermissionReference perm, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ void clearPermission_aroundBody26(PermissionServiceImpl ajc$this, StoreRef storeRef, String authority, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.deletePermissions(storeRef, authority);
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ void deletePermission_aroundBody28(PermissionServiceImpl ajc$this, StoreRef storeRef, String authority, String perm, JoinPoint joinPoint) {
        ajc$this.deletePermission(storeRef, authority, ajc$this.getPermissionReference(perm));
    }

    static final /* synthetic */ void deletePermissions_aroundBody30(PermissionServiceImpl ajc$this, StoreRef storeRef, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.deletePermissions(storeRef);
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ void setPermission_aroundBody32(PermissionServiceImpl ajc$this, StoreRef storeRef, String authority, String perm, boolean allow, JoinPoint joinPoint) {
        ajc$this.setPermission(storeRef, authority, ajc$this.getPermissionReference(perm), allow);
    }

    static final /* synthetic */ void deletePermissions_aroundBody34(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.deletePermissions(ajc$this.tenantService.getName(nodeRef));
        ajc$this.accessCache.clear();
        ajc$this.invokeUpdateLocalPermissionsPolicy(nodeRef, null, null, false);
    }

    static final /* synthetic */ void deletePermissions_aroundBody36(PermissionServiceImpl ajc$this, NodePermissionEntry nodePermissionEntry, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.deletePermissions(ajc$this.tenantService.getName(nodePermissionEntry.getNodeRef()));
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ void deletePermission_aroundBody38(PermissionServiceImpl ajc$this, PermissionEntry permissionEntry, JoinPoint joinPoint) {
        NodeRef nodeRef = permissionEntry.getNodeRef();
        String authority = permissionEntry.getAuthority();
        PermissionReference permission = permissionEntry.getPermissionReference();
        ajc$this.deletePermission(nodeRef, authority, permission);
    }

    static final /* synthetic */ void clearPermission_aroundBody40(PermissionServiceImpl ajc$this, NodeRef nodeRef, String authority, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.deletePermissions(ajc$this.tenantService.getName(nodeRef), authority);
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ void setPermission_aroundBody42(PermissionServiceImpl ajc$this, PermissionEntry permissionEntry, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.setPermission(permissionEntry);
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ void setPermission_aroundBody44(PermissionServiceImpl ajc$this, NodePermissionEntry nodePermissionEntry, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.setPermission(nodePermissionEntry);
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ void setInheritParentPermissions_aroundBody46(PermissionServiceImpl ajc$this, NodeRef nodeRef, boolean inheritParentPermissions, JoinPoint joinPoint) {
        NodeRef actualRef = ajc$this.tenantService.getName(nodeRef);
        ajc$this.permissionsDaoComponent.setInheritParentPermissions(actualRef, inheritParentPermissions);
        ajc$this.accessCache.clear();
        ajc$this.invokeOnPermissionsInheritedPolicy(nodeRef, inheritParentPermissions, false);
    }

    static final /* synthetic */ void setInheritParentPermissions_aroundBody48(PermissionServiceImpl ajc$this, NodeRef nodeRef, boolean inheritParentPermissions, boolean asyncCall, JoinPoint joinPoint) {
        NodeRef actualRef = ajc$this.tenantService.getName(nodeRef);
        if (asyncCall) {
            AlfrescoTransactionSupport.bindResource((Object)"FIXED_ACL_ASYNC_CALL", (Object)true);
            ajc$this.permissionsDaoComponent.setInheritParentPermissions(actualRef, inheritParentPermissions);
            boolean asyncCallRequired = BooleanUtils.toBoolean((Boolean)((Boolean)AlfrescoTransactionSupport.getResource((Object)"FIXED_ACL_ASYNC_REQUIRED")));
            if (asyncCallRequired) {
                AlfrescoTransactionSupport.bindListener(ajc$this.fixedAclUpdater);
            }
            ajc$this.invokeOnPermissionsInheritedPolicy(nodeRef, inheritParentPermissions, asyncCallRequired);
        } else {
            ajc$this.permissionsDaoComponent.setInheritParentPermissions(actualRef, inheritParentPermissions);
            ajc$this.invokeOnPermissionsInheritedPolicy(nodeRef, inheritParentPermissions, false);
        }
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ boolean getInheritParentPermissions_aroundBody50(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        return ajc$this.permissionsDaoComponent.getInheritParentPermissions(ajc$this.tenantService.getName(nodeRef));
    }

    static final /* synthetic */ PermissionReference getPermissionReference_aroundBody52(PermissionServiceImpl ajc$this, QName qname, String permissionName, JoinPoint joinPoint) {
        return ajc$this.modelDAO.getPermissionReference(qname, permissionName);
    }

    static final /* synthetic */ PermissionReference getAllPermissionReference_aroundBody54(PermissionServiceImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.allPermissionReference;
    }

    static final /* synthetic */ String getPermission_aroundBody56(PermissionServiceImpl ajc$this, PermissionReference permissionReference, JoinPoint joinPoint) {
        if (ajc$this.modelDAO.isUnique(permissionReference)) {
            return permissionReference.getName();
        }
        return permissionReference.toString();
    }

    static final /* synthetic */ PermissionReference getPermissionReference_aroundBody58(PermissionServiceImpl ajc$this, String permissionName, JoinPoint joinPoint) {
        return ajc$this.modelDAO.getPermissionReference(null, permissionName);
    }

    static final /* synthetic */ Set getSettablePermissionReferences_aroundBody60(PermissionServiceImpl ajc$this, QName type, JoinPoint joinPoint) {
        return ajc$this.modelDAO.getExposedPermissions(type);
    }

    static final /* synthetic */ Set getSettablePermissionReferences_aroundBody62(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        return ajc$this.modelDAO.getExposedPermissions(ajc$this.tenantService.getName(nodeRef));
    }

    static final /* synthetic */ void deletePermission_aroundBody64(PermissionServiceImpl ajc$this, NodeRef nodeRef, String authority, String perm, JoinPoint joinPoint) {
        ajc$this.deletePermission(nodeRef, authority, ajc$this.getPermissionReference(perm));
    }

    static final /* synthetic */ AccessStatus hasPermission_aroundBody66(PermissionServiceImpl ajc$this, NodeRef nodeRef, String perm, JoinPoint joinPoint) {
        return ajc$this.hasPermission(nodeRef, ajc$this.getPermissionReference(perm));
    }

    static final /* synthetic */ void setPermission_aroundBody68(PermissionServiceImpl ajc$this, NodeRef nodeRef, String authority, String perm, boolean allow, JoinPoint joinPoint) {
        ajc$this.setPermission(nodeRef, authority, ajc$this.getPermissionReference(perm), allow);
    }

    static final /* synthetic */ void deletePermissions_aroundBody70(PermissionServiceImpl ajc$this, String recipient, JoinPoint joinPoint) {
        ajc$this.permissionsDaoComponent.deletePermissions(recipient);
        ajc$this.accessCache.clear();
    }

    static final /* synthetic */ AccessStatus hasReadPermission_aroundBody72(PermissionServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        AccessStatus status = AccessStatus.DENIED;
        if (nodeRef == null) {
            return AccessStatus.ALLOWED;
        }
        if (!ajc$this.nodeService.exists(nodeRef)) {
            return AccessStatus.ALLOWED;
        }
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser == null) {
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return AccessStatus.ALLOWED;
        }
        Boolean forceHasPermission = (Boolean)AlfrescoTransactionSupport.getResource((Object)"forceHasPermission");
        if (forceHasPermission == null) {
            for (DynamicAuthority dynamicAuthority : ajc$this.dynamicAuthorities) {
                String authority = dynamicAuthority.getAuthority();
                Set<PermissionReference> requiredFor = dynamicAuthority.requiredFor();
                if (authority == "ROLE_OWNER" || authority == "ROLE_ADMINISTRATOR" || authority == "ROLE_LOCK_OWNER" || requiredFor != null && !requiredFor.contains(ajc$this.modelDAO.getPermissionReference(null, "FullControl")) && !requiredFor.contains(ajc$this.modelDAO.getPermissionReference(null, "Read"))) continue;
                forceHasPermission = Boolean.TRUE;
                break;
            }
            AlfrescoTransactionSupport.bindResource((Object)"forceHasPermission", (Object)forceHasPermission);
        }
        if (forceHasPermission == Boolean.TRUE) {
            return ajc$this.hasPermission(nodeRef, "Read");
        }
        Long aclID = ajc$this.nodeService.getNodeAclId(nodeRef);
        status = aclID == null ? ajc$this.hasPermission(nodeRef, ajc$this.getPermissionReference(null, "Read")) : (ajc$this.canRead(aclID) == AccessStatus.ALLOWED || ajc$this.adminRead() == AccessStatus.ALLOWED || ajc$this.ownerRead(runAsUser, nodeRef) == AccessStatus.ALLOWED ? AccessStatus.ALLOWED : AccessStatus.DENIED);
        return status;
    }

    static final /* synthetic */ Set getReaders_aroundBody74(PermissionServiceImpl ajc$this, Long aclId, JoinPoint joinPoint) {
        AccessControlList acl = ajc$this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        Set aclReaders = (Set)ajc$this.readersCache.get((Serializable)((Object)acl.getProperties()));
        if (aclReaders != null) {
            return aclReaders;
        }
        HashSet<String> assigned = new HashSet<String>();
        HashSet<String> readers = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            UnconditionalAclTest test = ajc$this.new UnconditionalAclTest(ajc$this.getPermissionReference("Read"));
            if (!test.evaluate(authority, aclId)) continue;
            readers.add(authority);
        }
        aclReaders = Collections.unmodifiableSet(readers);
        ajc$this.readersCache.put((Serializable)((Object)acl.getProperties()), aclReaders);
        return aclReaders;
    }

    static final /* synthetic */ Set getReadersDenied_aroundBody76(PermissionServiceImpl ajc$this, Long aclId, JoinPoint joinPoint) {
        AccessControlList acl = ajc$this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        HashSet<String> denied = (HashSet<String>)ajc$this.readersDeniedCache.get((Serializable)aclId);
        if (denied != null) {
            return denied;
        }
        denied = new HashSet<String>();
        HashSet<String> assigned = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            UnconditionalDeniedAclTest test = ajc$this.new UnconditionalDeniedAclTest(ajc$this.getPermissionReference("Read"));
            if (!test.evaluate(authority, aclId)) continue;
            denied.add(authority);
        }
        ajc$this.readersDeniedCache.put((Serializable)((Object)acl.getProperties()), denied);
        return denied;
    }

    static final /* synthetic */ Set getAuthorisations_aroundBody78(PermissionServiceImpl ajc$this, JoinPoint joinPoint) {
        Set<String> auths = (Set<String>)AlfrescoTransactionSupport.getResource((Object)"MyAuthCache");
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        if (!(auths == null || auth != null && auths.contains(((User)auth.getPrincipal()).getUsername()))) {
            auths = null;
        }
        if (auths == null) {
            auths = ajc$this.getCoreAuthorisations(auth);
            AlfrescoTransactionSupport.bindResource((Object)"MyAuthCache", auths);
        }
        return Collections.unmodifiableSet(auths);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PermissionServiceImpl.java", PermissionServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerAuthority", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "", "", "", "java.lang.String"), 421);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllAuthorities", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "", "", "", "java.lang.String"), 428);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.repo.security.permissions.PermissionReference", "passedNodeRef:permIn", "", "org.alfresco.service.cmr.security.AccessStatus"), 536);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "java.lang.Long:org.alfresco.service.cmr.security.PermissionContext:java.lang.String", "aclID:context:permission", "", "org.alfresco.service.cmr.security.AccessStatus"), 680);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "explainPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.repo.security.permissions.PermissionReference", "nodeRef:perm", "", "org.alfresco.repo.security.permissions.NodePermissionEntry"), 952);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.StoreRef:java.lang.String", "storeRef:authority", "", "void"), 960);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.StoreRef:java.lang.String:java.lang.String", "storeRef:authority:perm", "", "void"), 968);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.StoreRef", "storeRef", "", "void"), 981);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.StoreRef:java.lang.String:java.lang.String:boolean", "storeRef:authority:perm:allow", "", "void"), 989);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "void"), 1002);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.repo.security.permissions.NodePermissionEntry", "nodePermissionEntry", "", "void"), 1012);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.repo.security.permissions.PermissionEntry", "permissionEntry", "", "void"), 1023);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "", "", "", "java.lang.String"), 435);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "nodeRef:authority", "", "void"), 1058);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.repo.security.permissions.PermissionEntry", "permissionEntry", "", "void"), 1074);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.repo.security.permissions.NodePermissionEntry", "nodePermissionEntry", "", "void"), 1083);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInheritParentPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean", "nodeRef:inheritParentPermissions", "", "void"), 1092);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInheritParentPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean:boolean", "nodeRef:inheritParentPermissions:asyncCall", "", "void"), 1103);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getInheritParentPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 1153);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPermissionReference", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.namespace.QName:java.lang.String", "qname:permissionName", "", "org.alfresco.repo.security.permissions.PermissionReference"), 1160);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllPermissionReference", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "", "", "", "org.alfresco.repo.security.permissions.PermissionReference"), 1167);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.repo.security.permissions.PermissionReference", "permissionReference", "", "java.lang.String"), 1174);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPermissionReference", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "java.lang.String", "permissionName", "", "org.alfresco.repo.security.permissions.PermissionReference"), 1188);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "java.util.Set"), 442);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSettablePermissionReferences", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.namespace.QName", "type", "", "java.util.Set"), 1195);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSettablePermissionReferences", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "java.util.Set"), 1202);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String:java.lang.String", "nodeRef:authority:perm", "", "void"), 1209);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "nodeRef:perm", "", "org.alfresco.service.cmr.security.AccessStatus"), 1216);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String:java.lang.String:boolean", "nodeRef:authority:perm:allow", "", "void"), 1223);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "java.lang.String", "recipient", "", "void"), 1230);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasReadPermission", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.security.AccessStatus"), 1245);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReaders", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "java.lang.Long", "aclId", "", "java.util.Set"), 1365);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReadersDenied", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "java.lang.Long", "aclId", "", "java.util.Set"), 1407);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthorisations", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "", "", "", "java.util.Set"), 2913);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllSetPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "java.util.Set"), 449);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllSetPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.StoreRef", "storeRef", "", "java.util.Set"), 462);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSettablePermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "java.util.Set"), 496);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSettablePermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.namespace.QName", "type", "", "java.util.Set"), 509);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSetPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.repo.security.permissions.NodePermissionEntry"), 522);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSetPermissions", "org.alfresco.repo.security.permissions.impl.PermissionServiceImpl", "org.alfresco.service.cmr.repository.StoreRef", "storeRef", "", "org.alfresco.repo.security.permissions.NodePermissionEntry"), 529);
    }

    protected class AclTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();
        QName typeQName;
        Set<QName> aspectQNames;

        AclTest(PermissionReference required, QName typeQName, Set<QName> aspectQNames) {
            this.required = required;
            this.typeQName = typeQName;
            this.aspectQNames = aspectQNames;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), typeQName, aspectQNames, RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.NODE);
            if (PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.PARENT).size() > 0) {
                throw new IllegalStateException("Parent permissions can not be checked for an acl");
            }
            if (PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.CHILDREN).size() > 0) {
                throw new IllegalStateException("Child permissions can not be checked for an acl");
            }
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(Set<String> authorisations, Long aclId, PermissionContext context) {
            boolean success = true;
            if (PermissionServiceImpl.this.modelDAO.checkPermission(this.required) && !(success &= this.hasSinglePermission(authorisations, aclId, context))) {
                return false;
            }
            for (PermissionReference pr : this.nodeRequirements) {
                AclTest nt = new AclTest(pr, this.typeQName, this.aspectQNames);
                if (success &= nt.evaluate(authorisations, aclId, context)) continue;
                return false;
            }
            return success;
        }

        boolean hasSinglePermission(Set<String> authorisations, Long aclId, PermissionContext context) {
            if (this.checkGlobalPermissions(authorisations)) {
                return true;
            }
            return this.checkRequired(authorisations, aclId, context);
        }

        private boolean checkGlobalPermissions(Set<String> authorisations) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations)) continue;
                return true;
            }
            return false;
        }

        boolean checkRequired(Set<String> authorisations, Long aclId, PermissionContext context) {
            AccessControlList acl = PermissionServiceImpl.this.aclDaoComponent.getAccessControlList(aclId);
            if (acl == null) {
                return false;
            }
            if (PermissionServiceImpl.this.anyDenyDenies) {
                HashSet<Pair<String, PermissionReference>> allowed = new HashSet<Pair<String, PermissionReference>>();
                for (AccessControlEntry ace : acl.getEntries()) {
                    if (!this.isDenied(ace, authorisations, allowed, context)) continue;
                    return false;
                }
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            for (AccessControlEntry ace : acl.getEntries()) {
                if (!this.isGranted(ace, authorisations, denied, context)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(AccessControlEntry ace, Set<String> authorisations, Set<Pair<String, PermissionReference>> denied, PermissionContext context) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.DENIED) {
                denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(context.getType(), context.getAspects())) {
                        denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authorisations.contains(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isDenied(AccessControlEntry ace, Set<String> authorisations, Set<Pair<String, PermissionReference>> allowed, PermissionContext context) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.ALLOWED) {
                allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(context.getType(), context.getAspects())) {
                        allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (allowed != null && allowed.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authorisations.contains(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isGranted(PermissionEntry pe, Set<String> authorisations) {
            if (pe.isDenied()) {
                return false;
            }
            return this.granters.contains(pe.getPermissionReference()) && authorisations.contains(pe.getAuthority());
        }
    }

    static enum CacheType {
        HAS_PERMISSION,
        SINGLE_PERMISSION,
        SINGLE_PERMISSION_GLOBAL;

    }

    protected static class MutableBoolean {
        private boolean value;

        MutableBoolean(boolean value) {
            this.value = value;
        }

        void setValue(boolean value) {
            this.value = value;
        }

        boolean getValue() {
            return this.value;
        }
    }

    protected class NodeTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();
        Set<PermissionReference> parentRequirements = new HashSet<PermissionReference>();
        Set<PermissionReference> childrenRequirements = new HashSet<PermissionReference>();
        QName typeQName;
        Set<QName> aspectQNames;

        NodeTest(PermissionReference required, QName typeQName, Set<QName> aspectQNames) {
            this.required = required;
            this.typeQName = typeQName;
            this.aspectQNames = aspectQNames;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), typeQName, aspectQNames, RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.NODE);
            this.parentRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.PARENT);
            this.childrenRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.CHILDREN);
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(Set<String> authorisations, NodeRef nodeRef) {
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            return this.evaluate(authorisations, nodeRef, denied, null);
        }

        boolean evaluate(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied, MutableBoolean recursiveIn) {
            NodePermissionEntry nodePermissions;
            ChildAssociationRef car;
            MutableBoolean recursiveOut = null;
            HashSet<Pair<String, PermissionReference>> locallyDenied = new HashSet<Pair<String, PermissionReference>>();
            locallyDenied.addAll(denied);
            locallyDenied.addAll(this.getDenied(nodeRef));
            boolean success = true;
            if (PermissionServiceImpl.this.modelDAO.checkPermission(this.required)) {
                if (this.parentRequirements.contains(this.required)) {
                    if (this.checkGlobalPermissions(authorisations) || this.checkRequired(authorisations, nodeRef, locallyDenied)) {
                        if (recursiveIn != null) {
                            recursiveIn.setValue(true);
                        }
                    } else {
                        recursiveOut = new MutableBoolean(false);
                    }
                } else {
                    success &= this.hasSinglePermission(authorisations, nodeRef);
                }
                if (!success) {
                    return false;
                }
            }
            for (PermissionReference pr : this.nodeRequirements) {
                NodeTest nt = new NodeTest(pr, this.typeQName, this.aspectQNames);
                if (success &= nt.evaluate(authorisations, nodeRef, locallyDenied, null)) continue;
                return false;
            }
            if (success && (car = PermissionServiceImpl.this.nodeService.getPrimaryParent(nodeRef)).getParentRef() != null && ((nodePermissions = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(car.getChildRef())) == null || nodePermissions.inheritPermissions())) {
                locallyDenied.addAll(this.getDenied(car.getParentRef()));
                for (PermissionReference pr : this.parentRequirements) {
                    if (pr.equals(this.required)) {
                        success &= this.evaluate(authorisations, car.getParentRef(), locallyDenied, recursiveOut);
                        if (recursiveOut != null && recursiveOut.getValue() && recursiveIn != null) {
                            recursiveIn.setValue(true);
                        }
                    } else {
                        NodeTest nt = new NodeTest(pr, this.typeQName, this.aspectQNames);
                        success &= nt.evaluate(authorisations, car.getParentRef(), locallyDenied, null);
                    }
                    if (success) continue;
                    return false;
                }
            }
            if (recursiveOut != null && !recursiveOut.getValue()) {
                return false;
            }
            if (this.childrenRequirements.size() > 0) {
                List childAssocRefs = PermissionServiceImpl.this.nodeService.getChildAssocs(nodeRef);
                for (PermissionReference pr : this.childrenRequirements) {
                    for (ChildAssociationRef child : childAssocRefs) {
                        if (success &= PermissionServiceImpl.this.hasPermission(child.getChildRef(), pr) == AccessStatus.ALLOWED) continue;
                        return false;
                    }
                }
            }
            return success;
        }

        boolean hasSinglePermission(Set<String> authorisations, NodeRef nodeRef) {
            Serializable key = PermissionServiceImpl.this.generateKey(authorisations, nodeRef = PermissionServiceImpl.this.tenantService.getName(nodeRef), this.required, CacheType.SINGLE_PERMISSION_GLOBAL);
            AccessStatus status = (AccessStatus)PermissionServiceImpl.this.accessCache.get(key);
            if (status != null) {
                return status == AccessStatus.ALLOWED;
            }
            if (this.checkGlobalPermissions(authorisations)) {
                PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.ALLOWED);
                return true;
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            return this.hasSinglePermission(authorisations, nodeRef, denied);
        }

        boolean hasSinglePermission(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied) {
            AccessStatus status;
            nodeRef = PermissionServiceImpl.this.tenantService.getName(nodeRef);
            denied.addAll(this.getDenied(nodeRef));
            Serializable key = null;
            if (denied.size() == 0) {
                key = PermissionServiceImpl.this.generateKey(authorisations, nodeRef, this.required, CacheType.SINGLE_PERMISSION);
            }
            if (key != null && (status = (AccessStatus)PermissionServiceImpl.this.accessCache.get(key)) != null) {
                return status == AccessStatus.ALLOWED;
            }
            if (this.checkRequired(authorisations, nodeRef, denied)) {
                if (key != null) {
                    PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.ALLOWED);
                }
                return true;
            }
            ChildAssociationRef car = PermissionServiceImpl.this.nodeService.getPrimaryParent(nodeRef);
            if (car.getParentRef() != null) {
                NodePermissionEntry nodePermissions = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
                if (nodePermissions == null || nodePermissions.inheritPermissions()) {
                    if (this.hasSinglePermission(authorisations, car.getParentRef(), denied)) {
                        if (key != null) {
                            PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.ALLOWED);
                        }
                        return true;
                    }
                    if (key != null) {
                        PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.DENIED);
                    }
                    return false;
                }
                if (key != null) {
                    PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.DENIED);
                }
                return false;
            }
            if (key != null) {
                PermissionServiceImpl.this.accessCache.put(key, (Object)AccessStatus.DENIED);
            }
            return false;
        }

        private boolean checkGlobalPermissions(Set<String> authorisations) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations, null)) continue;
                return true;
            }
            return false;
        }

        Set<Pair<String, PermissionReference>> getDenied(NodeRef nodeRef) {
            HashSet<Pair<String, PermissionReference>> deniedSet = new HashSet<Pair<String, PermissionReference>>();
            NodePermissionEntry nodeEntry = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
            if (nodeEntry != null) {
                for (PermissionEntry permissionEntry : nodeEntry.getPermissionEntries()) {
                    if (!permissionEntry.isDenied()) continue;
                    Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(permissionEntry.getPermissionReference());
                    for (PermissionReference granter : granters) {
                        deniedSet.add((Pair<String, PermissionReference>)new Pair((Object)permissionEntry.getAuthority(), (Object)granter));
                    }
                    Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(permissionEntry.getPermissionReference());
                    for (PermissionReference grantee : grantees) {
                        deniedSet.add((Pair<String, PermissionReference>)new Pair((Object)permissionEntry.getAuthority(), (Object)grantee));
                    }
                    if (!permissionEntry.getPermissionReference().equals(PermissionServiceImpl.this.getAllPermissionReference()) && !permissionEntry.getPermissionReference().equals(OLD_ALL_PERMISSIONS_REFERENCE)) continue;
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(nodeRef)) {
                        deniedSet.add((Pair<String, PermissionReference>)new Pair((Object)permissionEntry.getAuthority(), (Object)deny));
                    }
                }
            }
            return deniedSet;
        }

        boolean checkRequired(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied) {
            NodePermissionEntry nodeEntry = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
            if (nodeEntry == null) {
                return false;
            }
            for (PermissionEntry permissionEntry : nodeEntry.getPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations, denied)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(PermissionEntry pe, Set<String> authorisations, Set<Pair<String, PermissionReference>> denied) {
            Pair specific;
            if (pe.isDenied()) {
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair((Object)pe.getAuthority(), (Object)this.required))) {
                return false;
            }
            if (PermissionServiceImpl.this.anyDenyDenies && denied != null) {
                for (String auth : authorisations) {
                    Pair specific2 = new Pair((Object)auth, (Object)this.required);
                    if (denied.contains(specific2)) {
                        return false;
                    }
                    for (PermissionReference perm : this.granters) {
                        specific2 = new Pair((Object)auth, (Object)perm);
                        if (!denied.contains(specific2)) continue;
                        return false;
                    }
                }
            }
            return authorisations.contains(pe.getAuthority()) && this.granters.contains(pe.getPermissionReference());
        }
    }

    protected class UnconditionalAclTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();

        UnconditionalAclTest(PermissionReference required) {
            this.required = required;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.NODE);
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.PARENT).size() > 0) {
                throw new IllegalStateException("Parent permissions can not be checked for an acl");
            }
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.CHILDREN).size() > 0) {
                throw new IllegalStateException("Child permissions can not be checked for an acl");
            }
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(String authority, Long aclId) {
            boolean success = true;
            if (!(success &= this.hasSinglePermission(authority, aclId))) {
                return false;
            }
            for (PermissionReference pr : this.nodeRequirements) {
                UnconditionalAclTest nt = new UnconditionalAclTest(pr);
                if (success &= nt.evaluate(authority, aclId)) continue;
                return false;
            }
            return success;
        }

        boolean hasSinglePermission(String authority, Long aclId) {
            if (this.checkGlobalPermissions(authority)) {
                return true;
            }
            if (aclId == null) {
                return false;
            }
            return this.checkRequired(authority, aclId);
        }

        private boolean checkGlobalPermissions(String authority) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authority)) continue;
                return true;
            }
            return false;
        }

        boolean checkRequired(String authority, Long aclId) {
            AccessControlList acl = PermissionServiceImpl.this.aclDaoComponent.getAccessControlList(aclId);
            if (acl == null) {
                return false;
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            for (AccessControlEntry ace : acl.getEntries()) {
                if (!this.isGranted(ace, authority, denied)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(AccessControlEntry ace, String authority, Set<Pair<String, PermissionReference>> denied) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.DENIED) {
                denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions()) {
                        denied.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authority.equals(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isGranted(PermissionEntry pe, String authority) {
            if (pe.isDenied()) {
                return false;
            }
            return this.granters.contains(pe.getPermissionReference()) && authority.equals(pe.getAuthority());
        }
    }

    protected class UnconditionalDeniedAclTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();

        UnconditionalDeniedAclTest(PermissionReference required) {
            this.required = required;
            this.nodeRequirements = required.equals(PermissionServiceImpl.this.getPermissionReference("All")) ? PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(PermissionServiceImpl.this.getPermissionReference("FullControl"), RequiredPermission.On.NODE) : PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.NODE);
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.PARENT).size() > 0) {
                throw new IllegalStateException("Parent permissions can not be checked for an acl");
            }
            if (PermissionServiceImpl.this.modelDAO.getUnconditionalRequiredPermissions(required, RequiredPermission.On.CHILDREN).size() > 0) {
                throw new IllegalStateException("Child permissions can not be checked for an acl");
            }
            this.granters = new LinkedHashSet<PermissionReference>(128, 1.0f);
            this.granters.addAll(PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required));
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(String authority, Long aclId) {
            boolean success = true;
            if (!(success &= this.hasSinglePermission(authority, aclId))) {
                return false;
            }
            for (PermissionReference pr : this.nodeRequirements) {
                UnconditionalDeniedAclTest nt = new UnconditionalDeniedAclTest(pr);
                if (success &= nt.evaluate(authority, aclId)) continue;
                return false;
            }
            return success;
        }

        boolean hasSinglePermission(String authority, Long aclId) {
            if (this.checkGlobalPermissions(authority)) {
                return true;
            }
            if (aclId == null) {
                return false;
            }
            return this.checkRequired(authority, aclId);
        }

        private boolean checkGlobalPermissions(String authority) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isDenied(permissionEntry, authority)) continue;
                return true;
            }
            return false;
        }

        boolean checkRequired(String authority, Long aclId) {
            AccessControlList acl = PermissionServiceImpl.this.aclDaoComponent.getAccessControlList(aclId);
            if (acl == null) {
                return false;
            }
            HashSet<Pair<String, PermissionReference>> allowed = new HashSet<Pair<String, PermissionReference>>();
            for (AccessControlEntry ace : acl.getEntries()) {
                if (!this.isDenied(ace, authority, allowed)) continue;
                return true;
            }
            return false;
        }

        private boolean isDenied(AccessControlEntry ace, String authority, Set<Pair<String, PermissionReference>> allowed) {
            Pair specific;
            if (ace.getAccessStatus() == AccessStatus.ALLOWED) {
                allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)ace.getPermission()));
                Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(ace.getPermission());
                for (PermissionReference granter : granters) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)granter));
                }
                Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(ace.getPermission());
                for (PermissionReference grantee : grantees) {
                    allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)grantee));
                }
                if (ace.getPermission().equals(PermissionServiceImpl.this.getAllPermissionReference()) || ace.getPermission().equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions()) {
                        allowed.add((Pair<String, PermissionReference>)new Pair((Object)ace.getAuthority(), (Object)deny));
                    }
                }
                return false;
            }
            if (allowed != null && allowed.contains(specific = new Pair((Object)ace.getAuthority(), (Object)this.required))) {
                return false;
            }
            return authority.equals(ace.getAuthority()) && this.granters.contains(ace.getPermission());
        }

        private boolean isDenied(PermissionEntry pe, String authority) {
            if (pe.isAllowed()) {
                return false;
            }
            return this.granters.contains(pe.getPermissionReference()) && authority.equals(pe.getAuthority());
        }
    }
}

