/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.sync;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.dictionary.constraint.NameChecker;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.AuthenticatorDeletedEvent;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.security.sync.ChainingUserRegistrySynchronizerStatus;
import org.alfresco.repo.security.sync.NodeDescription;
import org.alfresco.repo.security.sync.SyncStatus;
import org.alfresco.repo.security.sync.SynchronizeDiagnostic;
import org.alfresco.repo.security.sync.SynchronizeDiagnosticImpl;
import org.alfresco.repo.security.sync.SynchronizeDirectoryEndEvent;
import org.alfresco.repo.security.sync.SynchronizeDirectoryStartEvent;
import org.alfresco.repo.security.sync.SynchronizeEndEvent;
import org.alfresco.repo.security.sync.SynchronizeStartEvent;
import org.alfresco.repo.security.sync.TestableChainingUserRegistrySynchronizer;
import org.alfresco.repo.security.sync.UserRegistry;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.security.sync.ldap.LDAPUserRegistry;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TraceableThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class ChainingUserRegistrySynchronizer
extends AbstractLifecycleBean
implements UserRegistrySynchronizer,
ChainingUserRegistrySynchronizerStatus,
TestableChainingUserRegistrySynchronizer,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(ChainingUserRegistrySynchronizer.class);
    public static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ChainingUserRegistrySynchronizer");
    private static final long LOCK_TTL = 120000L;
    public static final String ROOT_ATTRIBUTE_PATH = ".ChainingUserRegistrySynchronizer";
    private static final String GROUP_LAST_MODIFIED_ATTRIBUTE = "GROUP";
    private static final String PERSON_LAST_MODIFIED_ATTRIBUTE = "PERSON";
    private static final String STATUS_ATTRIBUTE = "STATUS";
    private static final String LAST_ERROR_ATTRIBUTE = "LAST_ERROR";
    private static final String START_TIME_ATTRIBUTE = "START_TIME";
    private static final String END_TIME_ATTRIBUTE = "END_TIME";
    private static final String SERVER_ATTRIBUTE = "LAST_RUN_HOST";
    private static final String SUMMARY_ATTRIBUTE = "SUMMARY";
    private ChildApplicationContextManager applicationContextManager;
    private String sourceBeanName;
    private AuthorityService authorityService;
    private PersonService personService;
    private AttributeService attributeService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean syncWhenMissingPeopleLogIn = true;
    private boolean syncOnStartup = true;
    private boolean autoCreatePeopleOnLogin = true;
    private int loggingInterval = 100;
    private int workerThreads = 2;
    private MBeanServerConnection mbeanServer;
    private boolean allowDeletions = true;
    private boolean syncDelete = true;
    private NameChecker nameChecker;
    private SysAdminParams sysAdminParams;
    private String externalUserControl = "";
    private String externalUserControlSubsystemName = "";

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"attributeService", (Object)this.attributeService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"attributeService", (Object)this.attributeService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"applicationEventPublisher", (Object)this.applicationEventPublisher);
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
    }

    public void setExternalUserControl(String externalUserControl) {
        this.externalUserControl = externalUserControl;
    }

    public void setExternalUserControlSubsystemName(String externalUserControlSubsystemName) {
        this.externalUserControlSubsystemName = externalUserControlSubsystemName;
    }

    public void setNameChecker(NameChecker nameChecker) {
        this.nameChecker = nameChecker;
    }

    public void setApplicationContextManager(ChildApplicationContextManager applicationContextManager) {
        this.applicationContextManager = applicationContextManager;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setAutoCreatePeopleOnLogin(boolean autoCreatePeopleOnLogin) {
        this.autoCreatePeopleOnLogin = autoCreatePeopleOnLogin;
    }

    public void setSyncWhenMissingPeopleLogIn(boolean syncWhenMissingPeopleLogIn) {
        this.syncWhenMissingPeopleLogIn = syncWhenMissingPeopleLogIn;
    }

    public void setSyncOnStartup(boolean syncOnStartup) {
        this.syncOnStartup = syncOnStartup;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setAllowDeletions(boolean allowDeletions) {
        this.allowDeletions = allowDeletions;
    }

    public void setSyncDelete(boolean syncDelete) {
        this.syncDelete = syncDelete;
    }

    @Override
    public SynchronizeDiagnostic testSynchronize(String authenticatorName) {
        SynchronizeDiagnosticImpl ret = new SynchronizeDiagnosticImpl();
        Collection<String> instanceIds = this.applicationContextManager.getInstanceIds();
        if (instanceIds.contains(authenticatorName)) {
            ApplicationContext context = this.applicationContextManager.getApplicationContext(authenticatorName);
            UserRegistry plugin = (UserRegistry)context.getBean(this.sourceBeanName);
            if (plugin instanceof ActivateableBean && !((ActivateableBean)((Object)plugin)).isActive()) {
                ret.setActive(false);
            }
            long groupLastModifiedMillis = this.getMostRecentUpdateTime(GROUP_LAST_MODIFIED_ATTRIBUTE, authenticatorName, false);
            long personLastModifiedMillis = this.getMostRecentUpdateTime(PERSON_LAST_MODIFIED_ATTRIBUTE, authenticatorName, false);
            Date groupLastModified = groupLastModifiedMillis == -1L ? null : new Date(groupLastModifiedMillis);
            Date personLastModified = personLastModifiedMillis == -1L ? null : new Date(personLastModifiedMillis);
            ret.setGroups(plugin.getGroupNames());
            ret.setUsers(plugin.getPersonNames());
            if (groupLastModified != null) {
                ret.setGroupLastSynced(groupLastModified);
            } else {
                groupLastModified = new Date();
            }
            plugin.getGroups(groupLastModified);
            if (personLastModified != null) {
                ret.setPersonLastSynced(personLastModified);
            } else {
                personLastModified = new Date();
            }
            plugin.getPersons(personLastModified);
            return ret;
        }
        Object[] params = new Object[]{authenticatorName};
        throw new AuthenticationException("authentication.err.validation.authenticator.notfound", params);
    }

    @Override
    public void synchronize(boolean forceUpdate, boolean isFullSync) {
        this.synchronizeInternal(forceUpdate, isFullSync, true);
    }

    private void synchronizeInternal(boolean forceUpdate, boolean isFullSync, final boolean splitTxns) {
        if (logger.isDebugEnabled()) {
            if (forceUpdate) {
                logger.debug((Object)"Running a full sync.");
            } else {
                logger.debug((Object)"Running a differential sync.");
            }
            if (this.allowDeletions) {
                logger.debug((Object)"deletions are allowed");
            } else {
                logger.debug((Object)"deletions are not allowed");
            }
            if (this.transactionService.isReadOnly()) {
                logger.warn((Object)"Unable to proceed with user registry synchronization. Repository is read only.");
                return;
            }
        }
        if (this.transactionService.isReadOnly()) {
            logger.warn((Object)"Unable to proceed with user registry synchronization. Repository is read only.");
            return;
        }
        String lockToken = null;
        TraceableThreadFactory threadFactory = new TraceableThreadFactory();
        threadFactory.setNamePrefix("ChainingUserRegistrySynchronizer lock refresh");
        threadFactory.setThreadDaemon(true);
        ScheduledThreadPoolExecutor lockRefresher = new ScheduledThreadPoolExecutor(1, (ThreadFactory)threadFactory);
        try {
            lockToken = splitTxns ? this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    return ChainingUserRegistrySynchronizer.this.jobLockService.getLock(LOCK_QNAME, 120000L, 0L, 1);
                }
            }, false, splitTxns) : this.jobLockService.getLock(LOCK_QNAME, 120000L, 3000L, 10);
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            logger.warn((Object)"User registry synchronization already running in another thread. Synchronize aborted");
            if (lockToken != null) {
                int trys = 0;
                do {
                    lockRefresher.shutdown();
                    try {
                        lockRefresher.awaitTermination(120000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (!lockRefresher.isTerminated() && trys++ < 3);
                if (!lockRefresher.isTerminated()) {
                    lockRefresher.shutdownNow();
                    logger.error((Object)"Failed to shut down lock refresher");
                }
                String token = lockToken;
                this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(token){
                    private final /* synthetic */ String val$token;
                    {
                        this.val$token = string;
                    }

                    @Override
                    public Object execute() throws Throwable {
                        ChainingUserRegistrySynchronizer.this.jobLockService.releaseLock(this.val$token, LOCK_QNAME);
                        return null;
                    }
                }, false, splitTxns);
            }
            return;
        }
        try {
            try {
                UserRegistry plugin;
                final String token = lockToken;
                lockRefresher.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Throwable {
                                (this).ChainingUserRegistrySynchronizer.this.jobLockService.refreshLock(token, LOCK_QNAME, 120000L);
                                return null;
                            }
                        }, false, splitTxns);
                    }
                }, 60000L, 60000L, TimeUnit.MILLISECONDS);
                TreeSet<String> visitedZoneIds = new TreeSet<String>();
                Collection<String> instanceIds = this.applicationContextManager.getInstanceIds();
                TreeSet<String> allZoneIds = new TreeSet<String>();
                for (String id : instanceIds) {
                    allZoneIds.add("AUTH.EXT." + id);
                }
                HashMap<String, UserRegistry> plugins = new HashMap<String, UserRegistry>();
                for (String id : instanceIds) {
                    try {
                        ApplicationContext context = this.applicationContextManager.getApplicationContext(id);
                        plugin = (UserRegistry)context.getBean(this.sourceBeanName);
                    }
                    catch (RuntimeException runtimeException) {
                        continue;
                    }
                    if (plugin instanceof ActivateableBean && !((ActivateableBean)((Object)plugin)).isActive()) continue;
                    plugins.put(id, plugin);
                }
                this.notifySyncStart(plugins.keySet());
                for (String id : instanceIds) {
                    block59: {
                        plugin = (UserRegistry)plugins.get(id);
                        if (plugin == null) continue;
                        if (logger.isDebugEnabled()) {
                            this.mbeanServer = (MBeanServerConnection)this.getApplicationContext().getBean("alfrescoMBeanServer");
                            try {
                                StringBuilder nameBuff = new StringBuilder(200).append("Alfresco:Type=Configuration,Category=Authentication,id1=managed,id2=").append(URLDecoder.decode(id, "UTF-8"));
                                ObjectName name = new ObjectName(nameBuff.toString());
                                if (this.mbeanServer != null && this.mbeanServer.isRegistered(name)) {
                                    MBeanInfo info = this.mbeanServer.getMBeanInfo(name);
                                    MBeanAttributeInfo[] attributes = info.getAttributes();
                                    logger.debug((Object)(id + " attributes:"));
                                    MBeanAttributeInfo[] mBeanAttributeInfoArray = attributes;
                                    int n = attributes.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        MBeanAttributeInfo attribute = mBeanAttributeInfoArray[n2];
                                        Object value = this.mbeanServer.getAttribute(name, attribute.getName());
                                        logger.debug((Object)(attribute.getName() + " = " + String.valueOf(value)));
                                        ++n2;
                                    }
                                }
                            }
                            catch (UnsupportedEncodingException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (MalformedObjectNameException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (InstanceNotFoundException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (IntrospectionException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (AttributeNotFoundException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (ReflectionException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (MBeanException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn((Object)"Exception during logging", (Throwable)e);
                                }
                            }
                            catch (IOException e) {
                                if (!logger.isWarnEnabled()) break block59;
                                logger.warn((Object)"Exception during logging", (Throwable)e);
                            }
                        }
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Synchronizing users and groups with user registry '" + id + "'"));
                    }
                    if (isFullSync && logger.isWarnEnabled()) {
                        if (this.allowDeletions) {
                            logger.warn((Object)"Some users and groups previously created by synchronization with this user registry may be removed.");
                        } else {
                            logger.warn((Object)"Deletions are disabled. Users and groups removed from this registry will be logged only and will remain in the repository. Users previously found in a different registry will be moved in the repository rather than recreated.");
                        }
                    }
                    boolean requiresNew = splitTxns || AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
                    try {
                        this.syncWithPlugin(id, plugin, forceUpdate, isFullSync, requiresNew, visitedZoneIds, allZoneIds);
                        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeDirectoryEndEvent(this, id));
                    }
                    catch (RuntimeException e) {
                        this.notifySyncDirectoryEnd(id, e);
                        throw e;
                    }
                }
                this.notifySyncEnd();
            }
            catch (RuntimeException e) {
                this.notifySyncEnd(e);
                logger.error((Object)"Synchronization aborted due to error", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (lockToken != null) {
                int trys = 0;
                do {
                    lockRefresher.shutdown();
                    try {
                        lockRefresher.awaitTermination(120000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (!lockRefresher.isTerminated() && trys++ < 3);
                if (!lockRefresher.isTerminated()) {
                    lockRefresher.shutdownNow();
                    logger.error((Object)"Failed to shut down lock refresher");
                }
                String token = lockToken;
                this.transactionService.getRetryingTransactionHelper().doInTransaction(new /* invalid duplicate definition of identical inner class */, false, splitTxns);
            }
            throw throwable;
        }
        if (lockToken != null) {
            int trys = 0;
            do {
                lockRefresher.shutdown();
                try {
                    lockRefresher.awaitTermination(120000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            } while (!lockRefresher.isTerminated() && trys++ < 3);
            if (!lockRefresher.isTerminated()) {
                lockRefresher.shutdownNow();
                logger.error((Object)"Failed to shut down lock refresher");
            }
            String token = lockToken;
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new /* invalid duplicate definition of identical inner class */, false, splitTxns);
        }
    }

    @Override
    public Set<QName> getPersonMappedProperties(String username) {
        Set<String> authorityZones = this.authorityService.getAuthorityZones(username);
        if (authorityZones == null) {
            return Collections.emptySet();
        }
        Collection<String> instanceIds = this.applicationContextManager.getInstanceIds();
        for (String id : instanceIds) {
            String zoneId = "AUTH.EXT." + id;
            if (!authorityZones.contains(zoneId)) continue;
            try {
                ApplicationContext context = this.applicationContextManager.getApplicationContext(id);
                UserRegistry plugin = (UserRegistry)context.getBean(this.sourceBeanName);
                if (plugin instanceof ActivateableBean && !((ActivateableBean)((Object)plugin)).isActive()) continue;
                return plugin.getPersonMappedProperties();
            }
            catch (RuntimeException runtimeException) {}
        }
        return Collections.emptySet();
    }

    @Override
    public boolean createMissingPerson(String userName) {
        if (userName != null && !userName.equals(AuthenticationUtil.getSystemUserName())) {
            AuthorityType authorityType;
            if (this.syncWhenMissingPeopleLogIn) {
                try {
                    this.synchronizeInternal(false, false, false);
                }
                catch (Exception e) {
                    logger.warn((Object)"User authenticated but failed to sync with user registry", (Throwable)e);
                }
                if (this.personService.personExists(userName)) {
                    return true;
                }
            }
            if (this.autoCreatePeopleOnLogin && this.personService.createMissingPeople() && (authorityType = AuthorityType.getAuthorityType((String)userName)) == AuthorityType.USER) {
                this.personService.getPerson(userName);
                return true;
            }
        }
        return false;
    }

    private void syncWithPlugin(String zone, UserRegistry userRegistry, boolean forceUpdate, boolean isFullSync, boolean splitTxns, Set<String> visitedZoneIds, Set<String> allZoneIds) {
        Date lastModified;
        final String zoneId = "AUTH.EXT." + zone;
        String[] reservedBatchProcessNames = new String[]{SyncProcess.GROUP_ANALYSIS.getTitle(zone), SyncProcess.USER_CREATION.getTitle(zone), SyncProcess.MISSING_AUTHORITY.getTitle(zone), SyncProcess.GROUP_CREATION_AND_ASSOCIATION_DELETION.getTitle(zone), SyncProcess.GROUP_ASSOCIATION_CREATION.getTitle(zone), SyncProcess.PERSON_ASSOCIATION.getTitle(zone), SyncProcess.AUTHORITY_DELETION.getTitle(zone)};
        this.notifySyncDirectoryStart(zone, reservedBatchProcessNames);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.authorityService.getOrCreateZone(zoneId);
                return null;
            }
        }, false, splitTxns);
        Set<String> zoneSet = this.getZones(zoneId);
        long lastModifiedMillis = forceUpdate ? -1L : this.getMostRecentUpdateTime(GROUP_LAST_MODIFIED_ATTRIBUTE, zoneId, splitTxns);
        Date date = lastModified = lastModifiedMillis == -1L ? null : new Date(lastModifiedMillis);
        if (logger.isInfoEnabled()) {
            if (lastModified == null) {
                logger.info((Object)("Retrieving all groups from user registry '" + zone + "'"));
            } else {
                logger.info((Object)("Retrieving groups changed since " + DateFormat.getDateTimeInstance().format(lastModified) + " from user registry '" + zone + "'"));
            }
        }
        BatchProcessor<NodeDescription> groupProcessor = new BatchProcessor<NodeDescription>(SyncProcess.GROUP_ANALYSIS.getTitle(zone), this.transactionService.getRetryingTransactionHelper(), userRegistry.getGroups(lastModified), this.workerThreads, 20, this.applicationEventPublisher, logger, this.loggingInterval);
        class Analyzer
        extends BaseBatchProcessWorker<NodeDescription> {
            private final Map<String, String> groupsToCreate;
            private final Map<String, Set<String>> personParentAssocsToCreate;
            private final Map<String, Set<String>> personParentAssocsToDelete;
            private final List<String> personToRezone;
            private Map<String, Set<String>> groupParentAssocsToCreate;
            private final Map<String, Set<String>> groupParentAssocsToDelete;
            private final List<String> groupToRezone;
            private final Map<String, Set<String>> finalGroupChildAssocs;
            private List<String> personsProcessed;
            private Set<String> allZonePersons;
            private Set<String> deletionCandidates;
            private long latestTime;
            private final /* synthetic */ Set val$allZoneIds;
            private final /* synthetic */ Set val$visitedZoneIds;
            private final /* synthetic */ String val$zoneId;
            private final /* synthetic */ String val$zone;
            private final /* synthetic */ Set val$zoneSet;

            public Analyzer(long latestTime, Set set, Set set2, String string, String string2, Set set3) {
                this.val$allZoneIds = set;
                this.val$visitedZoneIds = set2;
                this.val$zoneId = string;
                this.val$zone = string2;
                this.val$zoneSet = set3;
                this.groupsToCreate = new TreeMap<String, String>();
                this.personParentAssocsToCreate = this.newPersonMap();
                this.personParentAssocsToDelete = this.newPersonMap();
                this.personToRezone = new LinkedList<String>();
                this.groupParentAssocsToCreate = new TreeMap<String, Set<String>>();
                this.groupParentAssocsToDelete = new TreeMap<String, Set<String>>();
                this.groupToRezone = new LinkedList<String>();
                this.finalGroupChildAssocs = new TreeMap<String, Set<String>>();
                this.personsProcessed = new LinkedList<String>();
                this.allZonePersons = Collections.emptySet();
                this.latestTime = latestTime;
            }

            public long getLatestTime() {
                return this.latestTime;
            }

            public Set<String> getDeletionCandidates() {
                return this.deletionCandidates;
            }

            @Override
            public String getIdentifier(NodeDescription entry) {
                return entry.getSourceId();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeDescription group) throws Throwable {
                PropertyMap groupProperties = group.getProperties();
                String groupName = (String)groupProperties.get(ContentModel.PROP_AUTHORITY_NAME);
                String groupShortName = ChainingUserRegistrySynchronizer.this.authorityService.getShortName(groupName);
                Set<String> groupZones = ChainingUserRegistrySynchronizer.this.authorityService.getAuthorityZones(groupName);
                if (groupZones == null) {
                    this.updateGroup(group, false);
                } else {
                    TreeSet<String> intersection = new TreeSet<String>(groupZones);
                    intersection.retainAll(this.val$allZoneIds);
                    TreeSet<String> visited = new TreeSet<String>((Collection<String>)intersection);
                    visited.retainAll(this.val$visitedZoneIds);
                    if (groupZones.contains(this.val$zoneId)) {
                        this.updateGroup(group, true);
                    } else {
                        if (!visited.isEmpty()) {
                            return;
                        }
                        if (!ChainingUserRegistrySynchronizer.this.allowDeletions || intersection.isEmpty()) {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("Updating group '" + groupShortName + "'. This group will in future be assumed to originate from user registry '" + this.val$zone + "'."));
                            }
                            ChainingUserRegistrySynchronizer.this.updateAuthorityZones(groupName, groupZones, this.val$zoneSet);
                            this.updateGroup(group, true);
                        } else {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("Recreating occluded group '" + groupShortName + "'. This group was previously created through synchronization with a lower priority user registry."));
                            }
                            ChainingUserRegistrySynchronizer.this.authorityService.deleteAuthority(groupName);
                            this.updateGroup(group, false);
                        }
                    }
                }
                Analyzer analyzer = this;
                synchronized (analyzer) {
                    Date groupLastModified = group.getLastModified();
                    if (groupLastModified != null) {
                        this.latestTime = Math.max(this.latestTime, groupLastModified.getTime());
                    }
                }
            }

            private Set<String> getContainedAuthorities(String groupName) {
                Set<String> children = this.finalGroupChildAssocs.get(groupName);
                if (children != null) {
                    return children;
                }
                for (String parent : ChainingUserRegistrySynchronizer.this.authorityService.getContainingAuthorities(null, groupName, true)) {
                    this.getContainedAuthorities(parent);
                }
                return this.cacheContainedAuthorities(groupName);
            }

            private Set<String> cacheContainedAuthorities(String groupName) {
                Set<String> children = this.finalGroupChildAssocs.get(groupName);
                if (children != null) {
                    return children;
                }
                children = ChainingUserRegistrySynchronizer.this.authorityService.getContainedAuthorities(null, groupName, true);
                this.finalGroupChildAssocs.put(groupName, children);
                for (String child : children) {
                    if (AuthorityType.getAuthorityType((String)child) == AuthorityType.USER) continue;
                    this.cacheContainedAuthorities(child);
                }
                return children;
            }

            private synchronized void updateGroup(NodeDescription group, boolean existed) {
                PropertyMap groupProperties = group.getProperties();
                String groupName = (String)groupProperties.get(ContentModel.PROP_AUTHORITY_NAME);
                String groupDisplayName = (String)groupProperties.get(ContentModel.PROP_AUTHORITY_DISPLAY_NAME);
                if (groupDisplayName == null) {
                    groupDisplayName = ChainingUserRegistrySynchronizer.this.authorityService.getShortName(groupName);
                }
                Set<String> newChildPersons = this.newPersonSet();
                TreeSet<String> newChildGroups = new TreeSet<String>();
                for (String child : group.getChildAssociations()) {
                    if (AuthorityType.getAuthorityType((String)child) == AuthorityType.USER) {
                        newChildPersons.add(child);
                        continue;
                    }
                    newChildGroups.add(child);
                }
                if (existed) {
                    ChainingUserRegistrySynchronizer.this.authorityService.setAuthorityDisplayName(groupName, groupDisplayName);
                    for (String child : new TreeSet<String>(this.getContainedAuthorities(groupName))) {
                        if (AuthorityType.getAuthorityType((String)child) == AuthorityType.USER) {
                            if (newChildPersons.remove(child)) continue;
                            this.recordParentAssociationDeletion(child, groupName);
                            continue;
                        }
                        if (newChildGroups.remove(child)) continue;
                        this.recordParentAssociationDeletion(child, groupName);
                    }
                } else {
                    this.recordParentAssociationDeletion(groupName, null);
                    this.groupsToCreate.put(groupName, groupDisplayName);
                }
                for (String child : newChildPersons) {
                    this.recordParentAssociationDeletion(child, null);
                    this.recordParentAssociationCreation(child, groupName);
                }
                for (String child : newChildGroups) {
                    this.recordParentAssociationDeletion(child, null);
                    this.recordParentAssociationCreation(child, groupName);
                }
            }

            private void recordParentAssociationDeletion(String child, String parent) {
                Map<String, Set<String>> parentAssocs;
                if (AuthorityType.getAuthorityType((String)child) == AuthorityType.USER) {
                    parentAssocs = this.personParentAssocsToDelete;
                } else {
                    parentAssocs = this.groupParentAssocsToDelete;
                    if (parent != null) {
                        Set<String> children = this.finalGroupChildAssocs.get(parent);
                        children.remove(child);
                    }
                }
                Set<String> parents = parentAssocs.get(child);
                if (parents == null) {
                    parents = new TreeSet<String>();
                    parentAssocs.put(child, parents);
                }
                if (parent != null) {
                    parents.add(parent);
                }
            }

            private void recordParentAssociationCreation(String child, String parent) {
                Map<String, Set<String>> parentAssocs = AuthorityType.getAuthorityType((String)child) == AuthorityType.USER ? this.personParentAssocsToCreate : this.groupParentAssocsToCreate;
                Set<String> parents = parentAssocs.get(child);
                if (parents == null) {
                    parents = new TreeSet<String>();
                    parentAssocs.put(child, parents);
                }
                if (parent != null) {
                    parents.add(parent);
                }
            }

            private void recordParentAssociationAuthoritiesToRezone(String child) {
                if (child != null) {
                    List<String> toRezone = AuthorityType.getAuthorityType((String)child) == AuthorityType.USER ? this.personToRezone : this.groupToRezone;
                    toRezone.add(child);
                }
            }

            private void validateGroupParentAssocsToCreate() {
                Iterator<Map.Entry<String, Set<String>>> i = this.groupParentAssocsToCreate.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, Set<String>> entry = i.next();
                    String group = entry.getKey();
                    Set<String> parents = entry.getValue();
                    LinkedList<String> visited = new LinkedList<String>();
                    Iterator<String> j = parents.iterator();
                    while (j.hasNext()) {
                        String parent = j.next();
                        visited.add(parent);
                        if (this.validateAuthorityChildren(visited, group)) {
                            Set<String> children = this.finalGroupChildAssocs.get(parent);
                            if (children == null) {
                                children = new TreeSet<String>();
                                this.finalGroupChildAssocs.put(parent, children);
                            }
                            children.add(group);
                        } else {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("Not adding group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(group) + "' to group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(parent) + "' as this creates a cyclic relationship"));
                            }
                            j.remove();
                        }
                        visited.removeLast();
                    }
                    if (!parents.isEmpty()) continue;
                    i.remove();
                }
                LinkedHashMap<String, Set<String>> sortedGroupAssociations = new LinkedHashMap<String, Set<String>>(this.groupParentAssocsToCreate.size() * 2);
                LinkedList<String> visited = new LinkedList<String>();
                for (String authority : this.groupParentAssocsToCreate.keySet()) {
                    this.visitGroupParentAssocs(visited, authority, this.groupParentAssocsToCreate, sortedGroupAssociations);
                }
                this.groupParentAssocsToCreate = sortedGroupAssociations;
            }

            private boolean validateAuthorityChildren(Deque<String> visited, String authority) {
                if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.USER) {
                    return true;
                }
                if (visited.contains(authority)) {
                    return false;
                }
                visited.add(authority);
                try {
                    Set<String> children = this.finalGroupChildAssocs.get(authority);
                    if (children != null) {
                        for (String child : children) {
                            if (this.validateAuthorityChildren(visited, child)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                finally {
                    visited.removeLast();
                }
            }

            private boolean visitGroupParentAssocs(Deque<String> visited, String authority, Map<String, Set<String>> associationsOld, Map<String, Set<String>> associationsNew) {
                if (visited.contains(authority)) {
                    return false;
                }
                visited.add(authority);
                try {
                    Set<String> oldParents;
                    if (!associationsNew.containsKey(authority) && (oldParents = associationsOld.get(authority)) != null) {
                        TreeSet<String> newParents = new TreeSet<String>();
                        for (String parent : oldParents) {
                            if (!this.visitGroupParentAssocs(visited, parent, associationsOld, associationsNew)) continue;
                            newParents.add(parent);
                        }
                        associationsNew.put(authority, newParents);
                    }
                    return true;
                }
                finally {
                    visited.removeLast();
                }
            }

            private Set<String> newPersonSet() {
                return ChainingUserRegistrySynchronizer.this.personService.getUserNamesAreCaseSensitive() ? new TreeSet<String>() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
            }

            private Map<String, Set<String>> newPersonMap() {
                return ChainingUserRegistrySynchronizer.this.personService.getUserNamesAreCaseSensitive() ? new TreeMap<String, Set<String>>() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }

            private void logRetainParentAssociations(Map<String, Set<String>> parentAssocs, Set<String> toRetain) {
                Iterator<Map.Entry<String, Set<String>>> i = parentAssocs.entrySet().iterator();
                StringBuilder groupList = null;
                while (i.hasNext()) {
                    Map.Entry<String, Set<String>> entry = i.next();
                    String child = entry.getKey();
                    if (toRetain.contains(child)) continue;
                    if (!this.shouldRezone(child)) {
                        if (logger.isDebugEnabled()) {
                            if (groupList == null) {
                                groupList = new StringBuilder(1024);
                            } else {
                                groupList.setLength(0);
                            }
                            for (String parent : entry.getValue()) {
                                if (groupList.length() > 0) {
                                    groupList.append(", ");
                                }
                                groupList.append('\'').append(ChainingUserRegistrySynchronizer.this.authorityService.getShortName(parent)).append('\'');
                            }
                            logger.debug((Object)("Ignoring non-existent member '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(child) + "' in groups {" + groupList.toString() + "}"));
                        }
                        i.remove();
                        continue;
                    }
                    this.recordParentAssociationAuthoritiesToRezone(child);
                }
            }

            private boolean shouldRezone(String authorityName) {
                boolean exists = ChainingUserRegistrySynchronizer.this.authorityService.authorityExists(authorityName);
                if (exists) {
                    Set<String> zones = ChainingUserRegistrySynchronizer.this.authorityService.getAuthorityZones(authorityName);
                    return ChainingUserRegistrySynchronizer.this.isInZone(authorityName, zones, "AUTH.ALF") && !ChainingUserRegistrySynchronizer.this.isInZone(authorityName, zones, this.val$zoneId);
                }
                return false;
            }

            private void processGroups(UserRegistry userRegistry, boolean isFullSync, boolean splitTxns) {
                if (!(!ChainingUserRegistrySynchronizer.this.syncDelete && this.groupsToCreate.isEmpty() || !isFullSync && this.groupParentAssocsToDelete.isEmpty())) {
                    final Set<String> allZonePersons = this.newPersonSet();
                    final TreeSet<String> allZoneGroups = new TreeSet<String>();
                    ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            allZonePersons.addAll(((Analyzer)this).ChainingUserRegistrySynchronizer.this.authorityService.getAllAuthoritiesInZone(val$zoneId, AuthorityType.USER));
                            allZoneGroups.addAll(((Analyzer)this).ChainingUserRegistrySynchronizer.this.authorityService.getAllAuthoritiesInZone(val$zoneId, AuthorityType.GROUP));
                            return null;
                        }
                    }, true, splitTxns);
                    allZoneGroups.addAll(this.groupsToCreate.keySet());
                    if (isFullSync) {
                        Set<String> personDeletionCandidates = this.newPersonSet();
                        personDeletionCandidates.addAll(allZonePersons);
                        TreeSet<String> groupDeletionCandidates = new TreeSet<String>();
                        groupDeletionCandidates.addAll(allZoneGroups);
                        this.deletionCandidates = new TreeSet<String>();
                        for (String person : userRegistry.getPersonNames()) {
                            personDeletionCandidates.remove(person);
                        }
                        for (String group : userRegistry.getGroupNames()) {
                            groupDeletionCandidates.remove(group);
                        }
                        this.deletionCandidates = new TreeSet<String>();
                        this.deletionCandidates.addAll(personDeletionCandidates);
                        this.deletionCandidates.addAll(groupDeletionCandidates);
                        if (ChainingUserRegistrySynchronizer.this.allowDeletions) {
                            allZonePersons.removeAll(personDeletionCandidates);
                            allZoneGroups.removeAll(groupDeletionCandidates);
                        } else {
                            BatchProcessor<String> groupScanner = new BatchProcessor<String>(this.val$zone + " Missing Authority Scanning", ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper(), this.deletionCandidates, ChainingUserRegistrySynchronizer.this.workerThreads, 20, ChainingUserRegistrySynchronizer.this.applicationEventPublisher, logger, ChainingUserRegistrySynchronizer.this.loggingInterval);
                            groupScanner.process((BatchProcessor.BatchProcessWorker<String>)new BaseBatchProcessWorker<String>(ChainingUserRegistrySynchronizer.this){

                                @Override
                                public String getIdentifier(String entry) {
                                    return entry;
                                }

                                @Override
                                public void process(String authority) throws Throwable {
                                    ChainingUserRegistrySynchronizer.this.updateAuthorityZones(authority, Collections.singleton(val$zoneId), Collections.singleton("AUTH.ALF"));
                                }
                            }, splitTxns);
                        }
                    }
                    this.groupParentAssocsToCreate.keySet().retainAll(allZoneGroups);
                    this.logRetainParentAssociations(this.groupParentAssocsToCreate, allZoneGroups);
                    this.finalGroupChildAssocs.keySet().retainAll(allZoneGroups);
                    this.allZonePersons = allZonePersons;
                    if (!this.groupParentAssocsToDelete.isEmpty()) {
                        BatchProcessor<Map.Entry<String, Set<String>>> groupCreator = new BatchProcessor<Map.Entry<String, Set<String>>>(SyncProcess.GROUP_CREATION_AND_ASSOCIATION_DELETION.getTitle(this.val$zone), ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper(), this.groupParentAssocsToDelete.entrySet(), ChainingUserRegistrySynchronizer.this.workerThreads, 20, ChainingUserRegistrySynchronizer.this.applicationEventPublisher, logger, ChainingUserRegistrySynchronizer.this.loggingInterval);
                        groupCreator.process((BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>>)new BaseBatchProcessWorker<Map.Entry<String, Set<String>>>(ChainingUserRegistrySynchronizer.this){

                            @Override
                            public String getIdentifier(Map.Entry<String, Set<String>> entry) {
                                return entry.getKey() + " " + String.valueOf(entry.getValue());
                            }

                            @Override
                            public void process(Map.Entry<String, Set<String>> entry) throws Throwable {
                                String child = entry.getKey();
                                String groupDisplayName = groupsToCreate.get(child);
                                if (groupDisplayName != null) {
                                    String groupShortName = ((Analyzer)this).ChainingUserRegistrySynchronizer.this.authorityService.getShortName(child);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Creating group '" + groupShortName + "'"));
                                    }
                                    ((Analyzer)this).ChainingUserRegistrySynchronizer.this.authorityService.createAuthority(AuthorityType.getAuthorityType((String)child), groupShortName, groupDisplayName, val$zoneSet);
                                } else {
                                    this.maintainAssociationDeletions(child);
                                }
                            }
                        }, splitTxns);
                    }
                }
            }

            private void finalizeAssociations(UserRegistry userRegistry, boolean splitTxns) {
                BatchProcessor<Map.Entry<String, Set<String>>> groupCreator;
                this.validateGroupParentAssocsToCreate();
                if (!this.groupParentAssocsToCreate.isEmpty()) {
                    groupCreator = new BatchProcessor<Map.Entry<String, Set<String>>>(SyncProcess.GROUP_ASSOCIATION_CREATION.getTitle(this.val$zone), ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper(), this.groupParentAssocsToCreate.entrySet(), ChainingUserRegistrySynchronizer.this.workerThreads, 20, ChainingUserRegistrySynchronizer.this.applicationEventPublisher, logger, ChainingUserRegistrySynchronizer.this.loggingInterval);
                    groupCreator.process((BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>>)new BaseBatchProcessWorker<Map.Entry<String, Set<String>>>(ChainingUserRegistrySynchronizer.this){

                        @Override
                        public String getIdentifier(Map.Entry<String, Set<String>> entry) {
                            return entry.getKey() + " " + String.valueOf(entry.getValue());
                        }

                        @Override
                        public void process(Map.Entry<String, Set<String>> entry) throws Throwable {
                            this.maintainAssociationCreations(entry.getKey());
                            this.maintainAssociationCreationsToRezone(entry.getKey());
                        }
                    }, splitTxns);
                }
                this.personParentAssocsToDelete.keySet().removeAll(this.personsProcessed);
                this.logRetainParentAssociations(this.personParentAssocsToCreate, this.allZonePersons);
                if (!this.personParentAssocsToDelete.isEmpty()) {
                    groupCreator = new BatchProcessor<Map.Entry<String, Set<String>>>(SyncProcess.PERSON_ASSOCIATION.getTitle(this.val$zone), ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper(), this.personParentAssocsToDelete.entrySet(), ChainingUserRegistrySynchronizer.this.workerThreads, 20, ChainingUserRegistrySynchronizer.this.applicationEventPublisher, logger, ChainingUserRegistrySynchronizer.this.loggingInterval);
                    groupCreator.process((BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>>)new BaseBatchProcessWorker<Map.Entry<String, Set<String>>>(ChainingUserRegistrySynchronizer.this){

                        @Override
                        public String getIdentifier(Map.Entry<String, Set<String>> entry) {
                            return entry.getKey() + " " + String.valueOf(entry.getValue());
                        }

                        @Override
                        public void process(Map.Entry<String, Set<String>> entry) throws Throwable {
                            this.maintainAssociationDeletions(entry.getKey());
                            this.maintainAssociationCreations(entry.getKey());
                            this.maintainAssociationCreationsToRezone(entry.getKey());
                        }
                    }, splitTxns);
                }
            }

            private void maintainAssociationDeletions(String authorityName) {
                Set<String> parentsToDelete;
                boolean isPerson = AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER;
                Set<String> set = parentsToDelete = isPerson ? this.personParentAssocsToDelete.get(authorityName) : this.groupParentAssocsToDelete.get(authorityName);
                if (parentsToDelete != null && !parentsToDelete.isEmpty()) {
                    for (String parent : parentsToDelete) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Removing '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authorityName) + "' from group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(parent) + "'"));
                        }
                        ChainingUserRegistrySynchronizer.this.authorityService.removeAuthority(parent, authorityName);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void maintainAssociationCreations(String authorityName) {
                Set<String> parents;
                boolean isPerson = AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER;
                Set<String> set = parents = isPerson ? this.personParentAssocsToCreate.get(authorityName) : this.groupParentAssocsToCreate.get(authorityName);
                if (parents != null && !parents.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        for (String groupName : parents) {
                            logger.debug((Object)("Adding '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authorityName) + "' to group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(groupName) + "'"));
                        }
                    }
                    try {
                        ChainingUserRegistrySynchronizer.this.authorityService.addAuthority(parents, authorityName);
                    }
                    catch (UnknownAuthorityException e) {
                        throw new ConcurrencyFailureException("Forcing batch retry for unknown authority", (Throwable)((Object)e));
                    }
                    catch (InvalidNodeRefException e) {
                        throw new ConcurrencyFailureException("Forcing batch retry for invalid node", (Throwable)e);
                    }
                }
                if (isPerson) {
                    Analyzer analyzer = this;
                    synchronized (analyzer) {
                        this.personsProcessed.add(authorityName);
                    }
                }
            }

            private void maintainAssociationCreationsToRezone(String authorityName) {
                Map<String, Set<String>> parentAssocsToCreate;
                boolean isPerson = AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER;
                List<String> authorities = isPerson ? this.personToRezone : this.groupToRezone;
                Map<String, Set<String>> map = parentAssocsToCreate = isPerson ? this.personParentAssocsToCreate : this.groupParentAssocsToCreate;
                if (authorities != null && !authorities.isEmpty() && parentAssocsToCreate.containsKey(authorityName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Changing  '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authorityName) + "' to zone '" + this.val$zoneId + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.updateAuthorityZones(authorityName, ChainingUserRegistrySynchronizer.this.authorityService.getAuthorityZones(authorityName), this.val$zoneSet);
                }
            }
        }
        Analyzer groupAnalyzer = new Analyzer(lastModifiedMillis, allZoneIds, visitedZoneIds, zoneId, zone, zoneSet);
        int groupProcessedCount = groupProcessor.process(groupAnalyzer, splitTxns);
        groupAnalyzer.processGroups(userRegistry, isFullSync, splitTxns);
        lastModifiedMillis = forceUpdate ? -1L : this.getMostRecentUpdateTime(PERSON_LAST_MODIFIED_ATTRIBUTE, zoneId, splitTxns);
        Date date2 = lastModified = lastModifiedMillis == -1L ? null : new Date(lastModifiedMillis);
        if (logger.isInfoEnabled()) {
            if (lastModified == null) {
                logger.info((Object)("Retrieving all users from user registry '" + zone + "'"));
            } else {
                logger.info((Object)("Retrieving users changed since " + DateFormat.getDateTimeInstance().format(lastModified) + " from user registry '" + zone + "'"));
            }
        }
        BatchProcessor<NodeDescription> personProcessor = new BatchProcessor<NodeDescription>(SyncProcess.USER_CREATION.getTitle(zone), this.transactionService.getRetryingTransactionHelper(), userRegistry.getPersons(lastModified), this.workerThreads, 10, this.applicationEventPublisher, logger, this.loggingInterval);
        UserRegistry userRegistryFinalRef = userRegistry;
        class PersonWorker
        extends BaseBatchProcessWorker<NodeDescription> {
            private long latestTime;
            private final /* synthetic */ String val$zone;
            private final /* synthetic */ UserRegistry val$userRegistryFinalRef;
            private final /* synthetic */ Set val$zoneSet;
            private final /* synthetic */ String val$zoneId;
            private final /* synthetic */ Set val$allZoneIds;
            private final /* synthetic */ Set val$visitedZoneIds;
            private final /* synthetic */ Analyzer val$groupAnalyzer;

            public PersonWorker(long latestTime, String string, UserRegistry userRegistry, Set set, String string2, Set set2, Set set3, Analyzer analyzer) {
                this.val$zone = string;
                this.val$userRegistryFinalRef = userRegistry;
                this.val$zoneSet = set;
                this.val$zoneId = string2;
                this.val$allZoneIds = set2;
                this.val$visitedZoneIds = set3;
                this.val$groupAnalyzer = analyzer;
                this.latestTime = latestTime;
            }

            public long getLatestTime() {
                return this.latestTime;
            }

            @Override
            public String getIdentifier(NodeDescription entry) {
                return entry.getSourceId();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeDescription person) throws Throwable {
                HashMap<QName, Serializable> personProperties = new HashMap<QName, Serializable>(person.getProperties());
                String personName = personProperties.get(ContentModel.PROP_USERNAME).toString().trim();
                personProperties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)personName));
                if (Boolean.parseBoolean(ChainingUserRegistrySynchronizer.this.externalUserControl) && ChainingUserRegistrySynchronizer.this.externalUserControlSubsystemName.equals(this.val$zone) && this.val$userRegistryFinalRef instanceof LDAPUserRegistry) {
                    try {
                        QName propertyNameToCheck;
                        LDAPUserRegistry ldapUserRegistry = (LDAPUserRegistry)this.val$userRegistryFinalRef;
                        if (ldapUserRegistry.getUserAccountStatusInterpreter() != null && (personProperties.get(propertyNameToCheck = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"userAccountStatusProperty")) != null || ldapUserRegistry.getUserAccountStatusInterpreter().acceptsNullArgument())) {
                            boolean isUserAccountDisabled = ldapUserRegistry.getUserAccountStatusInterpreter().isUserAccountDisabled(personProperties.get(propertyNameToCheck));
                            personProperties.put(ContentModel.PROP_ENABLED, Boolean.valueOf(!isUserAccountDisabled));
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        logger.debug((Object)iae.getMessage(), (Throwable)iae);
                    }
                }
                ChainingUserRegistrySynchronizer.this.nameChecker.evaluate((Object)personName);
                Set<String> zones = ChainingUserRegistrySynchronizer.this.authorityService.getAuthorityZones(personName);
                if (zones == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating user '" + personName + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.personService.createPerson(personProperties, this.val$zoneSet);
                } else if (zones.contains(this.val$zoneId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Updating user '" + personName + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.personService.setPersonProperties(personName, personProperties, false);
                } else {
                    TreeSet<String> intersection = new TreeSet<String>(zones);
                    intersection.retainAll(this.val$allZoneIds);
                    TreeSet<String> visited = new TreeSet<String>((Collection<String>)intersection);
                    visited.retainAll(this.val$visitedZoneIds);
                    if (visited.size() > 0) {
                        return;
                    }
                    if (!ChainingUserRegistrySynchronizer.this.allowDeletions || intersection.isEmpty()) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Updating user '" + personName + "'. This user will in future be assumed to originate from user registry '" + this.val$zone + "'."));
                        }
                        ChainingUserRegistrySynchronizer.this.updateAuthorityZones(personName, zones, this.val$zoneSet);
                        ChainingUserRegistrySynchronizer.this.personService.setPersonProperties(personName, personProperties, false);
                    } else {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Recreating occluded user '" + personName + "'. This user was previously created through synchronization with a lower priority user registry."));
                        }
                        ChainingUserRegistrySynchronizer.this.personService.deletePerson(personName);
                        ChainingUserRegistrySynchronizer.this.personService.createPerson(personProperties, this.val$zoneSet);
                    }
                }
                this.val$groupAnalyzer.maintainAssociationDeletions(personName);
                this.val$groupAnalyzer.maintainAssociationCreations(personName);
                this.val$groupAnalyzer.maintainAssociationCreationsToRezone(personName);
                PersonWorker personWorker = this;
                synchronized (personWorker) {
                    Date personLastModified = person.getLastModified();
                    if (personLastModified != null) {
                        this.latestTime = Math.max(this.latestTime, personLastModified.getTime());
                    }
                }
            }
        }
        PersonWorker persons = new PersonWorker(lastModifiedMillis, zone, userRegistryFinalRef, zoneSet, zoneId, allZoneIds, visitedZoneIds, groupAnalyzer);
        int personProcessedCount = personProcessor.process(persons, splitTxns);
        groupAnalyzer.finalizeAssociations(userRegistry, splitTxns);
        long latestTime = groupAnalyzer.getLatestTime();
        if (latestTime != -1L) {
            this.setMostRecentUpdateTime(GROUP_LAST_MODIFIED_ATTRIBUTE, zoneId, latestTime, splitTxns);
        }
        if ((latestTime = persons.getLatestTime()) != -1L) {
            this.setMostRecentUpdateTime(PERSON_LAST_MODIFIED_ATTRIBUTE, zoneId, latestTime, splitTxns);
        }
        Set<String> deletionCandidates = groupAnalyzer.getDeletionCandidates();
        if (isFullSync && this.allowDeletions && !deletionCandidates.isEmpty()) {
            BatchProcessor<String> authorityDeletionProcessor = new BatchProcessor<String>(SyncProcess.AUTHORITY_DELETION.getTitle(zone), this.transactionService.getRetryingTransactionHelper(), deletionCandidates, this.workerThreads, 10, this.applicationEventPublisher, logger, this.loggingInterval);
            class AuthorityDeleter
            extends BaseBatchProcessWorker<String> {
                private int personProcessedCount;
                private int groupProcessedCount;

                AuthorityDeleter() {
                }

                public int getPersonProcessedCount() {
                    return this.personProcessedCount;
                }

                public int getGroupProcessedCount() {
                    return this.groupProcessedCount;
                }

                @Override
                public String getIdentifier(String entry) {
                    return entry;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(String authority) throws Throwable {
                    if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.USER) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Deleting user '" + authority + "'"));
                        }
                        ChainingUserRegistrySynchronizer.this.personService.deletePerson(authority);
                        AuthorityDeleter authorityDeleter = this;
                        synchronized (authorityDeleter) {
                            ++this.personProcessedCount;
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authority) + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.authorityService.deleteAuthority(authority);
                    AuthorityDeleter authorityDeleter = this;
                    synchronized (authorityDeleter) {
                        ++this.groupProcessedCount;
                    }
                }
            }
            AuthorityDeleter authorityDeleter = new AuthorityDeleter();
            authorityDeletionProcessor.process(authorityDeleter, splitTxns);
            groupProcessedCount += authorityDeleter.getGroupProcessedCount();
            personProcessedCount += authorityDeleter.getPersonProcessedCount();
        }
        visitedZoneIds.add(zoneId);
        Object[] statusParams = new Object[]{personProcessedCount, groupProcessedCount};
        String statusMessage = I18NUtil.getMessage((String)"synchronization.summary.status", (Object[])statusParams);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Finished synchronizing users and groups with user registry '" + zone + "'"));
            logger.info((Object)statusMessage);
        }
        this.notifySyncDirectoryEnd(zone, statusMessage);
    }

    private long getMostRecentUpdateTime(final String label, final String zoneId, boolean splitTxns) {
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                Long updateTime = (Long)ChainingUserRegistrySynchronizer.this.attributeService.getAttribute(new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, label, zoneId});
                return updateTime == null ? -1L : updateTime;
            }
        }, true, splitTxns);
    }

    private void setMostRecentUpdateTime(final String label, final String zoneId, final long lastModifiedMillis, boolean splitTxns) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(Long.valueOf(lastModifiedMillis), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, label, zoneId});
                return null;
            }
        }, false, splitTxns);
    }

    private Set<String> getZones(String zoneId) {
        HashSet<String> zones = new HashSet<String>(5);
        zones.add("APP.DEFAULT");
        zones.add(zoneId);
        return zones;
    }

    private void updateAuthorityZones(String authorityName, Set<String> oldZones, Set<String> newZones) {
        HashSet<String> zonesToRemove = new HashSet<String>(oldZones);
        zonesToRemove.removeAll(newZones);
        zonesToRemove.remove("AUTH.ALF");
        if (!zonesToRemove.isEmpty()) {
            this.authorityService.removeAuthorityFromZones(authorityName, zonesToRemove);
        }
        HashSet<String> zonesToAdd = new HashSet<String>(newZones);
        zonesToAdd.removeAll(oldZones);
        if (!zonesToAdd.isEmpty()) {
            Set<String> currentZones = this.authorityService.getAuthorityZones(authorityName);
            if (currentZones != null && !currentZones.isEmpty()) {
                zonesToAdd.removeAll(currentZones);
            }
            this.authorityService.addAuthorityToZones(authorityName, zonesToAdd);
        }
    }

    private boolean isInZone(String authorityName, Set<String> authorityZones, String zoneToCheck) {
        return authorityName != null && authorityZones != null && zoneToCheck != null && authorityZones.contains(zoneToCheck);
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.syncOnStartup) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    try {
                        ChainingUserRegistrySynchronizer.this.synchronizeInternal(false, false, true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed initial synchronize with user registries", (Throwable)e);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    private void notifySyncStart(final Set<String> toSync) {
        final String serverId = this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeStartEvent(this));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(Long.valueOf(new Date().getTime()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.START_TIME_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(Long.valueOf(-1L), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.END_TIME_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)serverId), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.SERVER_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.IN_PROGRESS.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(null, new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.LAST_ERROR_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)""), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.SUMMARY_ATTRIBUTE});
                for (String zoneId : toSync) {
                    ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.WAITING.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE, zoneId});
                }
                return null;
            }
        }, false, true);
    }

    private void notifySyncEnd() {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeEndEvent(this));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.COMPLETE.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(Long.valueOf(new Date().getTime()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.END_TIME_ATTRIBUTE});
                return null;
            }
        }, false, true);
    }

    private void notifySyncEnd(final Exception e) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeEndEvent(this, e));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)e.getMessage()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.LAST_ERROR_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.COMPLETE_ERROR.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(Long.valueOf(new Date().getTime()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.END_TIME_ATTRIBUTE});
                return null;
            }
        }, false, true);
    }

    private void notifyZoneDeleted(final String zoneId) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)""), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)""), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.SUMMARY_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(null, new Serializable[]{ChainingUserRegistrySynchronizer.LAST_ERROR_ATTRIBUTE, ChainingUserRegistrySynchronizer.SUMMARY_ATTRIBUTE, zoneId});
                return null;
            }
        }, false, true);
    }

    private void notifySyncDirectoryStart(final String zoneId, String[] batchProcessNames) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeDirectoryStartEvent(this, zoneId, batchProcessNames));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.IN_PROGRESS.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)""), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.SUMMARY_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(null, new Serializable[]{ChainingUserRegistrySynchronizer.LAST_ERROR_ATTRIBUTE, ChainingUserRegistrySynchronizer.SUMMARY_ATTRIBUTE, zoneId});
                return null;
            }
        }, false, true);
    }

    private void notifySyncDirectoryEnd(final String zoneId, final String statusMessage) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeDirectoryEndEvent(this, zoneId));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.COMPLETE.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)""), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.LAST_ERROR_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)statusMessage), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.SUMMARY_ATTRIBUTE, zoneId});
                return null;
            }
        }, false, true);
    }

    private void notifySyncDirectoryEnd(final String zoneId, final Exception e) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SynchronizeDirectoryEndEvent(this, zoneId, e));
        logger.error((Object)"Synchronization aborted due to error", (Throwable)e);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)SyncStatus.COMPLETE_ERROR.toString()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.STATUS_ATTRIBUTE, zoneId});
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute((Serializable)((Object)e.getMessage()), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, ChainingUserRegistrySynchronizer.LAST_ERROR_ATTRIBUTE, zoneId});
                return null;
            }
        }, false, true);
    }

    @Override
    public Date getSyncStartTime() {
        Long start = (Long)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, START_TIME_ATTRIBUTE});
        Date lastUserUpdate = start == -1L ? null : new Date(start);
        return lastUserUpdate;
    }

    @Override
    public Date getSyncEndTime() {
        Long start = (Long)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, END_TIME_ATTRIBUTE});
        Date lastUserUpdate = start == -1L ? null : new Date(start);
        return lastUserUpdate;
    }

    @Override
    public String getLastErrorMessage() {
        String status = (String)((Object)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, LAST_ERROR_ATTRIBUTE}));
        return status;
    }

    @Override
    public String getLastRunOnServer() {
        String status = (String)((Object)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, SERVER_ATTRIBUTE}));
        return status;
    }

    @Override
    public String getSynchronizationStatus() {
        String status = (String)((Object)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, STATUS_ATTRIBUTE}));
        return status;
    }

    @Override
    public String getSynchronizationStatus(String zoneId) {
        String status = (String)((Object)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, STATUS_ATTRIBUTE, zoneId}));
        return status;
    }

    @Override
    public Date getSynchronizationLastUserUpdateTime(String id) {
        String zoneId = "AUTH.EXT." + id;
        long time = this.getMostRecentUpdateTime(PERSON_LAST_MODIFIED_ATTRIBUTE, zoneId, false);
        Date lastUserUpdate = time == -1L ? null : new Date(time);
        return lastUserUpdate;
    }

    @Override
    public Date getSynchronizationLastGroupUpdateTime(String id) {
        String zoneId = "AUTH.EXT." + id;
        long time = this.getMostRecentUpdateTime(GROUP_LAST_MODIFIED_ATTRIBUTE, zoneId, false);
        Date lastGroupUpdate = time == -1L ? null : new Date(time);
        return lastGroupUpdate;
    }

    @Override
    public String getSynchronizationLastError(String zoneId) {
        String status = (String)((Object)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, LAST_ERROR_ATTRIBUTE, zoneId}));
        return status;
    }

    @Override
    public String getSynchronizationSummary(String zoneId) {
        String status = (String)((Object)this.attributeService.getAttribute(new Serializable[]{ROOT_ATTRIBUTE_PATH, SUMMARY_ATTRIBUTE, zoneId}));
        return status;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public SysAdminParams getSysAdminParams() {
        return this.sysAdminParams;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthenticatorDeletedEvent) {
            AuthenticatorDeletedEvent deleteEvent = (AuthenticatorDeletedEvent)event;
            this.notifyZoneDeleted((String)deleteEvent.getSource());
        } else {
            super.onApplicationEvent(event);
        }
    }

    protected abstract class BaseBatchProcessWorker<T>
    implements BatchProcessor.BatchProcessWorker<T> {
        protected BaseBatchProcessWorker() {
        }

        @Override
        public final void beforeProcess() throws Throwable {
            AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        }

        @Override
        public final void afterProcess() throws Throwable {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    private static enum SyncProcess {
        GROUP_ANALYSIS("1 Group Analysis"),
        MISSING_AUTHORITY("2 Missing Authority Scanning"),
        GROUP_CREATION_AND_ASSOCIATION_DELETION("3 Group Creation and Association Deletion"),
        GROUP_ASSOCIATION_CREATION("4 Group Association Creation"),
        PERSON_ASSOCIATION("5 User Association"),
        USER_CREATION("6 User Creation and Association"),
        AUTHORITY_DELETION("7 Authority Deletion");

        private String title;

        private SyncProcess(String title) {
            this.title = title;
        }

        public String getTitle(String zone) {
            return "Synchronization,Category=directory,id1=" + zone + ",id2=" + this.title;
        }
    }
}

