/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.TestSynchronousTransformClient;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

public class TestAsynchronousTransformClient<T>
implements TransformClient {
    private ContentService contentService;
    private TransformClient delegate;
    private RenditionService2Impl renditionService2;

    public TestAsynchronousTransformClient(ContentService contentService, TransformClient delegate, RenditionService2Impl renditionService2) {
        this.contentService = contentService;
        this.delegate = delegate;
        this.renditionService2 = renditionService2;
    }

    public void checkSupported(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, String sourceMimetype, long sourceSizeInBytes, String contentUrl) {
        String targetMimetype = renditionDefinition.getTargetMimetype();
        if (!TestSynchronousTransformClient.isATest(sourceMimetype, targetMimetype)) {
            this.delegate.checkSupported(sourceNodeRef, renditionDefinition, sourceMimetype, sourceSizeInBytes, contentUrl);
        }
    }

    public void transform(final NodeRef sourceNodeRef, final RenditionDefinition2 renditionDefinition, String user, final int sourceContentHashCode) throws UnsupportedTransformationException, ContentIOException {
        String targetMimetype;
        ContentReader reader = this.contentService.getReader(sourceNodeRef, ContentModel.PROP_CONTENT);
        String sourceMimetype = reader.getMimetype();
        if (TestSynchronousTransformClient.isATest(sourceMimetype, targetMimetype = renditionDefinition.getTargetMimetype())) {
            ContentWriter writer = this.contentService.getTempWriter();
            writer.setMimetype(targetMimetype);
            TestSynchronousTransformClient.doTest(sourceMimetype, targetMimetype, writer, new TestSynchronousTransformClient.TestTransformClientCallback(){

                @Override
                public void successfulTransform(ContentWriter writer) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream("SUCCESS".getBytes());
                    TestAsynchronousTransformClient.this.renditionService2.consume(sourceNodeRef, (InputStream)inputStream, renditionDefinition, sourceContentHashCode);
                }
            });
        } else {
            this.delegate.transform(sourceNodeRef, renditionDefinition, user, sourceContentHashCode);
        }
    }
}

