/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.model;

import java.util.List;
import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

@AlfrescoPublicApi
public interface FileFolderService {
    @Auditable(parameters={"contextNodeRef"})
    public List<FileInfo> list(NodeRef var1);

    @Auditable(parameters={"contextNodeRef", "files", "folders", "ignoreTypeQNames", "sortProps", "pagingRequest"})
    public PagingResults<FileInfo> list(NodeRef var1, boolean var2, boolean var3, Set<QName> var4, List<Pair<QName, Boolean>> var5, PagingRequest var6);

    @Auditable(parameters={"contextNodeRef", "files", "folders", "ignoreTypeQNames", "sortProps", "pagingRequest"})
    public PagingResults<FileInfo> list(NodeRef var1, boolean var2, boolean var3, String var4, Set<QName> var5, List<Pair<QName, Boolean>> var6, PagingRequest var7);

    @Auditable(parameters={"folderNodeRef"})
    public List<FileInfo> listFiles(NodeRef var1);

    @Auditable(parameters={"contextNodeRef"})
    public List<FileInfo> listFolders(NodeRef var1);

    @Auditable(parameters={"contextNodeRef"})
    public List<FileInfo> listDeepFolders(NodeRef var1, SubFolderFilter var2);

    @Auditable(parameters={"nodeRef"})
    public NodeRef getLocalizedSibling(NodeRef var1);

    @Auditable(parameters={"contextNodeRef", "name"})
    public NodeRef searchSimple(NodeRef var1, String var2);

    @Auditable(parameters={"contextNodeRef", "namePattern", "includeSubFolders"})
    public List<FileInfo> search(NodeRef var1, String var2, boolean var3);

    @Auditable(parameters={"contextNodeRef", "namePattern", "fileSearch", "folderSearch", "includeSubFolders"})
    public List<FileInfo> search(NodeRef var1, String var2, boolean var3, boolean var4, boolean var5);

    @Auditable(parameters={"fileFolderRef", "newName"})
    public FileInfo rename(NodeRef var1, String var2) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"sourceNodeRef", "targetParentRef", "newName"})
    public FileInfo move(NodeRef var1, NodeRef var2, String var3) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"sourceNodeRef", "sourceParentRef", "targetParentRef", "newName"})
    public FileInfo moveFrom(NodeRef var1, NodeRef var2, NodeRef var3, String var4) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"sourceNodeRef", "sourceParentRef", "targetParentRef", "newName"})
    public FileInfo move(NodeRef var1, NodeRef var2, NodeRef var3, String var4) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"sourceNodeRef", "targetParentRef", "newName"})
    public FileInfo copy(NodeRef var1, NodeRef var2, String var3) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"parentNodeRef", "name", "typeQName"})
    public FileInfo create(NodeRef var1, String var2, QName var3) throws FileExistsException;

    @Auditable(parameters={"parentNodeRef", "name", "typeQName"})
    public FileInfo create(NodeRef var1, String var2, QName var3, QName var4) throws FileExistsException;

    @Auditable(parameters={"nodeRef"})
    public void delete(NodeRef var1);

    @Auditable(parameters={"rootNodeRef", "nodeRef"})
    public List<FileInfo> getNamePath(NodeRef var1, NodeRef var2) throws FileNotFoundException;

    @Auditable(parameters={"rootNodeRef", "nodeRef"})
    public List<String> getNameOnlyPath(NodeRef var1, NodeRef var2) throws FileNotFoundException;

    @Auditable(parameters={"rootNodeRef", "pathElements"})
    public FileInfo resolveNamePath(NodeRef var1, List<String> var2) throws FileNotFoundException;

    @Auditable(parameters={"rootNodeRef", "pathElements", "mustExist"})
    public FileInfo resolveNamePath(NodeRef var1, List<String> var2, boolean var3) throws FileNotFoundException;

    @Auditable(parameters={"nodeRef"})
    public FileInfo getFileInfo(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public ContentReader getReader(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public ContentWriter getWriter(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public boolean exists(NodeRef var1);

    @Auditable(parameters={"typeQName"})
    public FileFolderServiceType getType(QName var1);

    @Deprecated
    public boolean isHidden(NodeRef var1);

    @Deprecated
    public void setHidden(NodeRef var1, boolean var2);

    @Auditable(parameters={"rootNodeRef"})
    public PagingResults<FileInfo> list(NodeRef var1, Set<QName> var2, Set<QName> var3, List<Pair<QName, Boolean>> var4, PagingRequest var5);

    @Auditable(parameters={"rootNodeRef"})
    public PagingResults<FileInfo> list(NodeRef var1, Set<QName> var2, Set<QName> var3, Set<QName> var4, List<Pair<QName, Boolean>> var5, List<FilterProp> var6, PagingRequest var7);

    @Auditable(parameters={"nodeRefs"})
    public List<FileInfo> toFileInfoList(List<NodeRef> var1);
}

