/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.Map;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentServiceTransientException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

public class TestSynchronousTransformClient<T>
implements SynchronousTransformClient {
    public static final String TEST_FAILING_MIME_TYPE = "application/vnd.alfresco.test.transientfailure";
    public static final String TEST_LONG_RUNNING_MIME_TYPE = "application/vnd.alfresco.test.longrunning";
    public static final String TEST_USER_MIME_TYPE = "image/alfresco.test.user";
    public static final long TEST_LONG_RUNNING_TRANSFORM_TIME = 5000L;
    public static final String TEST_LONG_RUNNING_PROPERTY_VALUE = "NewValue";
    public static final String EXPECTED_USER = "UserOne";
    private SynchronousTransformClient delegate;

    public TestSynchronousTransformClient(SynchronousTransformClient delegate) {
        this.delegate = delegate;
    }

    public boolean isSupported(String sourceMimetype, long sourceSizeInBytes, String contentUrl, String targetMimetype, Map<String, String> actualOptions, String transformName, NodeRef sourceNodeRef) {
        boolean supported = true;
        if (!TestSynchronousTransformClient.isATest(sourceMimetype, targetMimetype)) {
            supported = this.delegate.isSupported(sourceMimetype, sourceSizeInBytes, contentUrl, targetMimetype, actualOptions, transformName, sourceNodeRef);
        }
        return supported;
    }

    public void transform(ContentReader reader, ContentWriter writer, Map<String, String> actualOptions, String transformName, NodeRef sourceNodeRef) {
        String targetMimetype;
        String sourceMimetype = reader.getMimetype();
        if (TestSynchronousTransformClient.isATest(sourceMimetype, targetMimetype = writer.getMimetype())) {
            TestSynchronousTransformClient.doTest(sourceMimetype, targetMimetype, writer, new TestTransformClientCallback());
        } else {
            this.delegate.transform(reader, writer, actualOptions, transformName, sourceNodeRef);
        }
    }

    static boolean isATest(String sourceMimetype, String targetMimetype) {
        return TestSynchronousTransformClient.isFailingTest(sourceMimetype, targetMimetype) || TestSynchronousTransformClient.isLongRunningTest(sourceMimetype, targetMimetype) || TestSynchronousTransformClient.isUserTest(sourceMimetype, targetMimetype);
    }

    static boolean isFailingTest(String sourceMimetype, String targetMimetype) {
        return sourceMimetype.equals(TEST_FAILING_MIME_TYPE) || targetMimetype.equals(TEST_FAILING_MIME_TYPE);
    }

    static boolean isLongRunningTest(String sourceMimetype, String targetMimetype) {
        return sourceMimetype.equals(TEST_LONG_RUNNING_MIME_TYPE) || targetMimetype.equals(TEST_LONG_RUNNING_MIME_TYPE);
    }

    static boolean isUserTest(String sourceMimetype, String targetMimetype) {
        return sourceMimetype.equals(TEST_USER_MIME_TYPE) || targetMimetype.equals(TEST_USER_MIME_TYPE);
    }

    static void doTest(String sourceMimetype, String targetMimetype, ContentWriter writer, TestTransformClientCallback callback) {
        if (TestSynchronousTransformClient.isFailingTest(sourceMimetype, targetMimetype)) {
            throw new ContentServiceTransientException("Transformation intentionally failed for test purposes.");
        }
        if (TestSynchronousTransformClient.isLongRunningTest(sourceMimetype, targetMimetype)) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            callback.successfulTransform(writer);
        } else if (TestSynchronousTransformClient.isUserTest(sourceMimetype, targetMimetype)) {
            String username = AuthenticationUtil.getFullyAuthenticatedUser();
            if (!EXPECTED_USER.equals(username)) {
                throw new ContentIOException("Expected username 'UserOne' but found '" + username + "'");
            }
            callback.successfulTransform(writer);
        }
    }

    public String getName() {
        return this.delegate.getName();
    }

    static class TestTransformClientCallback {
        TestTransformClientCallback() {
        }

        public void successfulTransform(ContentWriter writer) {
            writer.putContent("SUCCESS");
        }
    }
}

