/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.repo.download.cannedquery.DownloadEntity;
import org.alfresco.repo.download.cannedquery.GetDownloadsCannedQuery;
import org.alfresco.repo.download.cannedquery.GetDownloadsCannedQueryFactory;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.SystemNodeUtils;
import org.alfresco.service.cmr.download.DownloadRequest;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadStorage {
    private static final Log log = LogFactory.getLog(DownloadStorage.class);
    private ImporterBootstrap bootstrap;
    private Repository repositoryHelper;
    private NodeService nodeService;
    private NodeService noPermissionCheckNodeService;
    private NamespaceService namespaceService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> queryRegistry;

    public void setImporterBootstrap(ImporterBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void setQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> queryRegistry) {
        this.queryRegistry = queryRegistry;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNoPermissionCheckNodeService(NodeService noPermissionCheckNodeService) {
        this.noPermissionCheckNodeService = noPermissionCheckNodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NodeRef getOrCreateDowloadContainer() {
        NodeRef downloadsContainer = this.getContainer();
        if (downloadsContainer == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Lazy creating the Downloads System Container ");
            }
            downloadsContainer = (NodeRef)SystemNodeUtils.getOrCreateSystemChildContainer(this.getContainerQName(), this.nodeService, this.repositoryHelper).getFirst();
        }
        return downloadsContainer;
    }

    private NodeRef getContainer() {
        return SystemNodeUtils.getSystemChildContainer(this.getContainerQName(), this.nodeService, this.repositoryHelper);
    }

    private QName getContainerQName() {
        String name = this.bootstrap.getConfiguration().getProperty("system.downloads_container.childname");
        QName container = QName.createQName((String)name, (NamespacePrefixResolver)this.namespaceService);
        return container;
    }

    public NodeRef createDownloadNode(boolean recursive) {
        NodeRef downloadsContainer = this.getOrCreateDowloadContainer();
        HashMap<QName, Boolean> downloadProperties = new HashMap<QName, Boolean>();
        downloadProperties.put(DownloadModel.PROP_RECURSIVE, recursive);
        ChildAssociationRef newChildAssoc = this.noPermissionCheckNodeService.createNode(downloadsContainer, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, DownloadModel.TYPE_DOWNLOAD, downloadProperties);
        NodeRef downloadNodeRef = newChildAssoc.getChildRef();
        HashMap<QName, Boolean> aspectProperties = new HashMap<QName, Boolean>(2);
        aspectProperties.put(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        aspectProperties.put(ContentModel.PROP_IS_CONTENT_INDEXED, Boolean.FALSE);
        this.nodeService.addAspect(downloadNodeRef, ContentModel.ASPECT_INDEX_CONTROL, aspectProperties);
        if (log.isDebugEnabled()) {
            String downloadNodeRefString = "Download-NodeRef=" + String.valueOf(downloadNodeRef);
            StringBuilder msg = new StringBuilder();
            msg.append("Created Download. ").append(downloadNodeRefString);
            log.debug((Object)msg.toString());
        }
        return downloadNodeRef;
    }

    public void cancelDownload(NodeRef downloadNodeRef) {
        this.validateNode(downloadNodeRef);
        this.nodeService.setProperty(downloadNodeRef, DownloadModel.PROP_CANCELLED, (Serializable)Boolean.valueOf(true));
    }

    public boolean isCancelled(NodeRef downloadNodeRef) {
        this.validateNode(downloadNodeRef);
        return (Boolean)this.nodeService.getProperty(downloadNodeRef, DownloadModel.PROP_CANCELLED);
    }

    public void addNodeToDownload(NodeRef downloadNode, NodeRef nodeToAdd) {
        this.nodeService.createAssociation(downloadNode, nodeToAdd, DownloadModel.ASSOC_REQUESTED_NODES);
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Node added to Download-NodeRef '").append(downloadNode).append("'. RequestedNode=").append(nodeToAdd);
            log.debug((Object)msg.toString());
        }
    }

    public DownloadRequest getDownloadRequest(NodeRef downloadNodeRef) {
        this.validateNode(downloadNodeRef);
        Map properties = this.nodeService.getProperties(downloadNodeRef);
        List requestedNodes = this.nodeService.getTargetAssocs(downloadNodeRef, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
        return new DownloadRequest((Boolean)properties.get(DownloadModel.PROP_RECURSIVE), requestedNodes, (String)properties.get(ContentModel.PROP_CREATOR));
    }

    private void validateNode(NodeRef downloadNodeRef) {
        if (!this.nodeService.getType(downloadNodeRef).equals((Object)DownloadModel.TYPE_DOWNLOAD)) {
            throw new IllegalArgumentException("Invalid node type for nodeRef: " + String.valueOf(downloadNodeRef));
        }
    }

    public DownloadStatus getDownloadStatus(NodeRef downloadNodeRef) {
        this.validateNode(downloadNodeRef);
        Map properties = this.nodeService.getProperties(downloadNodeRef);
        Long done = (Long)properties.get(DownloadModel.PROP_DONE);
        Long total = (Long)properties.get(DownloadModel.PROP_TOTAL);
        Long filesAdded = (Long)properties.get(DownloadModel.PROP_FILES_ADDED);
        Long totalFiles = (Long)properties.get(DownloadModel.PROP_TOTAL_FILES);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Status for Download-NodeRef: " + String.valueOf(downloadNodeRef) + ": done: " + String.valueOf(done) + ", total: " + String.valueOf(total) + ", filesAdded: " + String.valueOf(filesAdded) + ", totalFiles: " + String.valueOf(totalFiles)));
        }
        return new DownloadStatus(DownloadStatus.Status.valueOf((String)properties.get(DownloadModel.PROP_STATUS)), done != null ? done : 0L, total != null ? total : 0L, filesAdded != null ? filesAdded : 0L, totalFiles != null ? totalFiles : 0L);
    }

    public int getSequenceNumber(NodeRef nodeRef) {
        this.validateNode(nodeRef);
        Serializable sequenceNumber = this.nodeService.getProperty(nodeRef, DownloadModel.PROP_SEQUENCE_NUMBER);
        return (Integer)sequenceNumber;
    }

    public void updateStatus(NodeRef nodeRef, DownloadStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating status for Download-NodeRef: " + String.valueOf(nodeRef) + " to status: " + String.valueOf((Object)status.getStatus())));
        }
        this.validateNode(nodeRef);
        this.nodeService.setProperty(nodeRef, DownloadModel.PROP_STATUS, (Serializable)((Object)status.getStatus().toString()));
        this.nodeService.setProperty(nodeRef, DownloadModel.PROP_DONE, (Serializable)Long.valueOf(status.getDone()));
        this.nodeService.setProperty(nodeRef, DownloadModel.PROP_TOTAL, (Serializable)Long.valueOf(status.getTotal()));
        this.nodeService.setProperty(nodeRef, DownloadModel.PROP_FILES_ADDED, (Serializable)Long.valueOf(status.getFilesAdded()));
        this.nodeService.setProperty(nodeRef, DownloadModel.PROP_TOTAL_FILES, (Serializable)Long.valueOf(status.getTotalFiles()));
    }

    public List<List<DownloadEntity>> getDownloadsCreatedBefore(Date before, int batchSize, boolean cleanAllSysDownloadFolders) {
        List<NodeRef> allFoldersToBeCleaned = this.getAllFoldersToBeCleaned(cleanAllSysDownloadFolders);
        if (allFoldersToBeCleaned.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<DownloadEntity>> childDownloads = new ArrayList<List<DownloadEntity>>();
        for (NodeRef folderToBeCleaned : allFoldersToBeCleaned) {
            this.gatherDownloadFilesToBeCleanedFromFolder(childDownloads, before, batchSize, folderToBeCleaned);
        }
        return childDownloads;
    }

    private void gatherDownloadFilesToBeCleanedFromFolder(List<List<DownloadEntity>> childDownloads, Date before, int batchSize, NodeRef folderToBeCleaned) {
        GetDownloadsCannedQueryFactory getDownloadCannedQueryFactory = (GetDownloadsCannedQueryFactory)((Object)this.queryRegistry.getNamedObject("downloadGetDownloadsCannedQueryFactory"));
        GetDownloadsCannedQuery cq = (GetDownloadsCannedQuery)getDownloadCannedQueryFactory.getDownloadsCannedQuery(folderToBeCleaned, before);
        CannedQueryResults results = cq.execute();
        List downloadsInThisFolder = results.getPages();
        if (batchSize > 0) {
            int i = 0;
            while (childDownloads.size() < batchSize && downloadsInThisFolder.size() > i) {
                childDownloads.add((List)downloadsInThisFolder.get(i++));
            }
        } else {
            childDownloads.addAll(downloadsInThisFolder);
        }
    }

    private List<NodeRef> getAllFoldersToBeCleaned(boolean cleanAllSysDownloadFolders) {
        ArrayList<NodeRef> allFoldersToBeCleaned = new ArrayList<NodeRef>();
        if (cleanAllSysDownloadFolders) {
            for (NodeRef nodeRef : SystemNodeUtils.getSystemChildContainers(this.getContainerQName(), this.nodeService, this.repositoryHelper)) {
                if (nodeRef == null) continue;
                allFoldersToBeCleaned.add(nodeRef);
            }
        } else {
            NodeRef container = this.getContainer();
            if (container != null) {
                allFoldersToBeCleaned.add(container);
            }
        }
        return allFoldersToBeCleaned;
    }

    public void delete(NodeRef nodeRef) {
        this.validateNode(nodeRef);
        this.nodeService.deleteNode(nodeRef);
    }
}

