/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.util.Arrays;
import java.util.Collections;
import org.alfresco.repo.template.DocumentationURLMethod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentationURLMethodTest {
    public static final String BASE_URL = "baseUrl";
    public static final String ACS_VERSION = "_acs_";
    public static final String SEARCH_VERSION = "_solr_";
    public static final String SEARCH_ENTERPRISE_VERSION = "_es_";
    public static final String DEFAULT_DOCUMENTATION_URL = "defaultDocumentationUrl";
    DocumentationURLMethod documentationURLMethod;

    @Before
    public void setUp() throws Exception {
        this.documentationURLMethod = new DocumentationURLMethod();
        this.documentationURLMethod.setAcsVersion(ACS_VERSION);
        this.documentationURLMethod.setAlfrescoSearchVersion(SEARCH_VERSION);
        this.documentationURLMethod.setAlfrescoSearchEnterpriseVersion(SEARCH_ENTERPRISE_VERSION);
        this.documentationURLMethod.setDocumentationBaseUrl(BASE_URL);
        this.documentationURLMethod.setDefaultDocumentationUrl(DEFAULT_DOCUMENTATION_URL);
    }

    @Test
    public void testGetDocumentationUrl_NoArgs() throws TemplateModelException {
        Object result = this.documentationURLMethod.exec(Collections.emptyList());
        Assert.assertEquals((Object)DEFAULT_DOCUMENTATION_URL, (Object)result);
    }

    @Test
    public void testGetDocumentationUrl_EmptyTopicUidAndUrlComponent() throws TemplateModelException {
        Object result = this.documentationURLMethod.exec(Arrays.asList(new SimpleScalar(""), new SimpleScalar("")));
        Assert.assertEquals((Object)DEFAULT_DOCUMENTATION_URL, (Object)result);
    }

    @Test
    public void testGetDocumentationUrl_WithTopicUid_AcsVersion() throws TemplateModelException {
        Object result = this.documentationURLMethod.exec(Collections.singletonList(new SimpleScalar("/topic")));
        Assert.assertEquals((Object)"baseUrl/topic_acs_", (Object)result);
    }

    @Test
    public void testGetDocumentationUrl_WithTopicUidAndUrlComponent_AcsVersion() throws TemplateModelException {
        Object result = this.documentationURLMethod.exec(Arrays.asList(new SimpleScalar("/topic"), new SimpleScalar("urlComponent")));
        Assert.assertEquals((Object)"baseUrl/topic_acs_urlComponent", (Object)result);
    }

    @Test
    public void testGetDocumentationUrl_WithSolrVersion() throws TemplateModelException {
        Object result = this.documentationURLMethod.exec(Arrays.asList(new SimpleScalar("/topic"), new SimpleScalar("urlComponent"), new SimpleScalar("solr")));
        Assert.assertEquals((Object)"baseUrl/topic_solr_urlComponent", (Object)result);
    }

    @Test
    public void testGetDocumentationUrl_WithElasticSearchVersion() throws TemplateModelException {
        Object result = this.documentationURLMethod.exec(Arrays.asList(new SimpleScalar("/topic"), new SimpleScalar("urlComponent"), new SimpleScalar("elasticsearch")));
        Assert.assertEquals((Object)"baseUrl/topic_es_urlComponent", (Object)result);
    }
}

