/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.manifest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import org.alfresco.repo.transfer.manifest.TestTransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.xml.sax.helpers.DefaultHandler;

public class TransferManifestTest
extends TestCase {
    public void testCreateAndReadSnapshot() throws Exception {
        String prefix = "TRX-SNAP";
        String suffix = ".xml";
        String repoId = "repoId";
        File snapshotFile = TempFileProvider.createTempFile((String)prefix, (String)suffix);
        BufferedWriter snapshotWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(snapshotFile), "UTF-8"));
        XMLTransferManifestWriter formatter = new XMLTransferManifestWriter();
        TransferManifestHeader header = new TransferManifestHeader();
        header.setCreatedDate(new Date());
        header.setRepositoryId(repoId);
        formatter.startTransferManifest((Writer)snapshotWriter);
        formatter.writeTransferManifestHeader(header);
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        NodeRef nodeRefA = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "123");
        node.setNodeRef(nodeRefA);
        node.setParentPath(new Path());
        HashSet<QName> aspects = new HashSet<QName>();
        aspects.add(QName.createQName((String)"{gsxhjsx}", (String)"cm:wobble"));
        aspects.add(QName.createQName((String)"{gsxhjsx}", (String)"cm:wibble"));
        node.setAspects(aspects);
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"cm:name"), "brian.jpg");
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"cm:created"), new Date());
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"trx:enabled"), Boolean.FALSE);
        MLText mltext = new MLText();
        mltext.addValue(Locale.FRENCH, "Bonjour");
        mltext.addValue(Locale.ENGLISH, "Hello");
        mltext.addValue(Locale.ITALY, "Buongiorno");
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"cm:title"), mltext);
        String password = "helloWorld";
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"trx:password"), password.toCharArray());
        ArrayList<String> a1 = new ArrayList<String>();
        a1.add("Rhubarb");
        a1.add("Custard");
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"trx:arrayList"), a1);
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("Rhubarb", "Rhubarb");
        m1.put("Custard", "Custard");
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"trx:hashMap"), m1);
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"cm:nullTest"), null);
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"trx:nodeRef"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "P1"));
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryParent = new ChildAssociationRef(QName.createQName((String)"{gsxhjsx}", (String)"cm:contains"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "P1"), QName.createQName((String)"{gsxhjsx}", (String)"app:smashing"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "123"), true, -1);
        parents.add(primaryParent);
        parents.add(new ChildAssociationRef(QName.createQName((String)"{gsxhjsx}", (String)"app:wibble"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "P1"), QName.createQName((String)"{gsxhjsx}", (String)"app:jskjsdc"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "123"), false, -1));
        node.setParentAssocs(parents);
        node.setPrimaryParentAssoc(primaryParent);
        ArrayList<ChildAssociationRef> children = new ArrayList<ChildAssociationRef>();
        children.add(new ChildAssociationRef(QName.createQName((String)"{gsxhjsx}", (String)"cm:contains"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "P1"), QName.createQName((String)"{gsxhjsx}", (String)"app:super"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "P5"), true, -1));
        node.setChildAssocs(children);
        HashSet<String> values = new HashSet<String>();
        values.add("red");
        values.add("blue");
        values.add("green");
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"xyz:colours"), values);
        ContentData contentHeader = new ContentData("http://wibble", "mimeType", 123L, "utf-8", Locale.ENGLISH);
        properties.put(QName.createQName((String)"{gsxhjsx}", (String)"cm:content"), contentHeader);
        node.setProperties(properties);
        node.setType(QName.createQName((String)"{gsxhjsx}", (String)"trx:nsbbmbs"));
        ArrayList<AssociationRef> targetAssocs = new ArrayList<AssociationRef>();
        ArrayList<AssociationRef> sourceAssocs = new ArrayList<AssociationRef>();
        targetAssocs.add(new AssociationRef(null, new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "SA"), QName.createQName((String)"{gsxhjsx}", (String)"app:super"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "TA")));
        sourceAssocs.add(new AssociationRef(null, new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "HH"), QName.createQName((String)"{gsxhjsx}", (String)"app:super"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "JJ")));
        node.setSourceAssocs(sourceAssocs);
        node.setTargetAssocs(targetAssocs);
        formatter.writeTransferManifestNode((TransferManifestNode)node);
        TransferManifestNormalNode node2 = new TransferManifestNormalNode();
        node2.setNodeRef(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "456"));
        node2.setType(QName.createQName((String)"{gsxhjsx}", (String)"trx:dummy"));
        formatter.writeTransferManifestNode((TransferManifestNode)node2);
        TransferManifestDeletedNode node3 = new TransferManifestDeletedNode();
        node3.setNodeRef(new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, "567"));
        ChildAssociationRef origPrimaryParent = new ChildAssociationRef(QName.createQName((String)"{gsxhjsx}", (String)"cm:contains"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "P1"), QName.createQName((String)"{gsxhjsx}", (String)"app:whopper"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "567"), true, -1);
        node3.setPrimaryParentAssoc(origPrimaryParent);
        node3.setParentPath(new Path());
        formatter.writeTransferManifestNode((TransferManifestNode)node3);
        formatter.endTransferManifest();
        ((Writer)snapshotWriter).close();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(snapshotFile), "UTF-8"));
        String s = reader.readLine();
        while (s != null) {
            System.out.println(s);
            s = reader.readLine();
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser parser = saxParserFactory.newSAXParser();
        TestTransferManifestProcessor tp = new TestTransferManifestProcessor();
        XMLTransferManifestReader xmlReader = new XMLTransferManifestReader((TransferManifestProcessor)tp);
        parser.parse(snapshotFile, (DefaultHandler)xmlReader);
        Map<NodeRef, TransferManifestNode> nodes = tp.getNodes();
        TransferManifestNormalNode rxNodeA = (TransferManifestNormalNode)nodes.get(nodeRefA);
        TransferManifestTest.assertNotNull((String)"rxNodeA is null", (Object)rxNodeA);
        Map rxNodeAProps = rxNodeA.getProperties();
        System.out.println(rxNodeAProps.get(QName.createQName((String)"{gsxhjsx}", (String)"trx:password")));
        for (Map.Entry value : rxNodeAProps.entrySet()) {
            System.out.println("key = " + String.valueOf(value.getKey()) + " value =" + String.valueOf(value.getValue()));
            if (value.getValue() == null || !((Serializable)value.getValue()).getClass().isArray()) continue;
            System.out.println("arrayValue=" + ((Serializable)value.getValue()).toString());
            char[] chars = (char[])value.getValue();
            System.out.println(chars);
        }
        tp.getHeader();
        snapshotFile.delete();
    }

    public class TestPrivateBean
    implements Serializable {
        private static final long serialVersionUID = 1053132227110567282L;
        private String a;

        public void setA(String a) {
            this.a = a;
        }

        public String getA() {
            return this.a;
        }
    }
}

