/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import lib3party.org.apache.chemistry.opencmis.server.support.wrapper.ConformanceCmisServiceWrapper;
import org.alfresco.opencmis.AlfrescoCmisExceptionInterceptor;
import org.alfresco.opencmis.AlfrescoCmisService;
import org.alfresco.opencmis.AlfrescoCmisServiceImpl;
import org.alfresco.opencmis.AlfrescoCmisServiceInterceptor;
import org.alfresco.opencmis.AlfrescoCmisStreamInterceptor;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.CMISTransactionAwareHolderInterceptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionInterceptor;
import org.alfresco.service.cmr.security.AuthorityService;
import org.aopalliance.aop.Advice;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;

public class AlfrescoCmisServiceFactory
extends AbstractServiceFactory {
    private static final Log logger = LogFactory.getLog(AlfrescoCmisServiceFactory.class);
    private int memoryThreshold = super.getMemoryThreshold();
    private long maxContentSize = super.getMaxContentSize();
    private CMISConnector connector;
    private RetryingTransactionInterceptor cmisTransactions;
    private AlfrescoCmisExceptionInterceptor cmisExceptions;
    private AlfrescoCmisServiceInterceptor cmisControl;
    private AlfrescoCmisStreamInterceptor cmisStreams;
    private CMISTransactionAwareHolderInterceptor cmisHolder;
    private AuthorityService authorityService;
    private String cmisCreateDocRequestRenditionsSet = null;

    public void setMemoryThreshold(double memoryThreshold) {
        this.memoryThreshold = (int)memoryThreshold * 1024;
    }

    public void setMaxContentSize(double maxContentSize) {
        this.maxContentSize = (long)maxContentSize * 1024L * 1024L;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMaxContentSize() {
        return this.maxContentSize;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setCmisConnector(CMISConnector connector) {
        this.connector = connector;
    }

    public void setCmisTransactions(RetryingTransactionInterceptor cmisTransactions) {
        this.cmisTransactions = cmisTransactions;
    }

    public void setCmisExceptions(AlfrescoCmisExceptionInterceptor cmisExceptions) {
        this.cmisExceptions = cmisExceptions;
    }

    public void setCmisControl(AlfrescoCmisServiceInterceptor cmisControl) {
        this.cmisControl = cmisControl;
    }

    public void setCmisStreams(AlfrescoCmisStreamInterceptor cmisStreams) {
        this.cmisStreams = cmisStreams;
    }

    public void setCmisHolder(CMISTransactionAwareHolderInterceptor cmisHolder) {
        this.cmisHolder = cmisHolder;
    }

    public String getCmisCreateDocRequestRenditionsSet() {
        return this.cmisCreateDocRequestRenditionsSet;
    }

    public void setCmisCreateDocRequestRenditionsSet(String cmisCreateDocRequestRenditionsSet) {
        this.cmisCreateDocRequestRenditionsSet = cmisCreateDocRequestRenditionsSet;
    }

    public void init(Map<String, String> parameters) {
    }

    public void init() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("init: cmis.create.doc.request.renditions.set=" + this.cmisCreateDocRequestRenditionsSet));
        }
    }

    public void destroy() {
    }

    public CmisService getService(CallContext context) {
        AlfrescoCmisService service;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("getService: ").append(AuthenticationUtil.getFullyAuthenticatedUser()).append(" [runAsUser=").append(AuthenticationUtil.getRunAsUser()).append(",ctxUserName=").append(context.getUsername()).append(",ctxRepoId=").append(context.getRepositoryId()).append("]");
            logger.debug((Object)sb.toString());
        }
        if (AuthenticationUtil.getFullyAuthenticatedUser() != null && this.authorityService.isGuestAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
        if ((service = this.getCmisServiceTarget(this.connector)) instanceof AlfrescoCmisServiceImpl) {
            Set<String> stringSet = this.parseCommaSeparatedSet(this.getCmisCreateDocRequestRenditionsSet());
            ((AlfrescoCmisServiceImpl)service).setCmisRequestRenditionsOnCreateDoc(stringSet);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("getService: cmis.create.doc.request.renditions.set=" + String.valueOf(stringSet)));
            }
        }
        ProxyFactory proxyFactory = new ProxyFactory((Object)service);
        proxyFactory.addInterface(AlfrescoCmisService.class);
        proxyFactory.addAdvice((Advice)this.cmisExceptions);
        proxyFactory.addAdvice((Advice)this.cmisControl);
        proxyFactory.addAdvice((Advice)this.cmisStreams);
        proxyFactory.addAdvice((Advice)this.cmisTransactions);
        proxyFactory.addAdvice((Advice)this.cmisHolder);
        AlfrescoCmisService cmisService = (AlfrescoCmisService)proxyFactory.getProxy();
        ConformanceCmisServiceWrapper wrapperService = new ConformanceCmisServiceWrapper(cmisService, this.connector.getTypesDefaultMaxItems(), this.connector.getTypesDefaultDepth(), this.connector.getObjectsDefaultMaxItems(), this.connector.getObjectsDefaultDepth());
        cmisService.open(context);
        return wrapperService;
    }

    protected AlfrescoCmisService getCmisServiceTarget(CMISConnector connector) {
        return new AlfrescoCmisServiceImpl(connector);
    }

    private Set<String> parseCommaSeparatedSet(String str) {
        HashSet<String> stringSet = new HashSet<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken().trim();
                if (entry.isEmpty()) continue;
                stringSet.add(entry);
            }
        }
        return stringSet;
    }
}

