/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.node.DefaultFieldProcessor;
import org.alfresco.repo.forms.processor.node.MockClassAttributeDefinition;
import org.alfresco.repo.forms.processor.node.MockFieldProcessorRegistry;
import org.alfresco.repo.forms.processor.workflow.AbstractWorkflowFormProcessor;
import org.alfresco.repo.forms.processor.workflow.ExtendedPropertyFieldProcessor;
import org.alfresco.repo.forms.processor.workflow.FormProcessorTest;
import org.alfresco.repo.forms.processor.workflow.TaskFormProcessor;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.NamespaceServiceMemoryImpl;
import org.alfresco.service.namespace.QName;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TaskFormProcessorTest
extends FormProcessorTest {
    private static final String TASK_ID = "foo$Real Id";
    private static final NodeRef USER_NODE = new NodeRef("http://www.alfresco.org/model/content/1.0/admin");
    private static final String NO_MESSAGE = "(No Message)";
    private WorkflowTask task;
    private AuthenticationService authenticationService;
    private PersonService personService;
    private WorkflowTask newTask;
    private Map<QName, Serializable> actualProperties = null;
    private Map<QName, List<NodeRef>> actualAdded = null;
    private Map<QName, List<NodeRef>> actualRemoved = null;

    public void testGetTypedItem() throws Exception {
        try {
            this.processor.getTypedItem(null);
            TaskFormProcessorTest.fail((String)"Should have thrown an Exception here!");
        }
        catch (FormNotFoundException formNotFoundException) {}
        try {
            this.processor.getTypedItem(new Item("task", "bad id"));
            TaskFormProcessorTest.fail((String)"Should have thrown an Exception here!");
        }
        catch (FormNotFoundException formNotFoundException) {}
        WorkflowTask result = (WorkflowTask)((TaskFormProcessor)this.processor).getTypedItem(this.item);
        TaskFormProcessorTest.assertNotNull((Object)result);
        TaskFormProcessorTest.assertEquals((String)TASK_ID, (String)result.getId());
        result = (WorkflowTask)((TaskFormProcessor)this.processor).getTypedItem(this.item);
        TaskFormProcessorTest.assertNotNull((Object)result);
        TaskFormProcessorTest.assertEquals((String)TASK_ID, (String)result.getId());
    }

    public void testGenerateSetsItemAndUrl() throws Exception {
        Form form = ((TaskFormProcessor)this.processor).generate(this.item, null, null, null);
        Item formItem = form.getItem();
        TaskFormProcessorTest.assertEquals((String)this.item.getId(), (String)formItem.getId());
        TaskFormProcessorTest.assertEquals((String)this.item.getKind(), (String)formItem.getKind());
        String expType = "bpm:TaskDef";
        TaskFormProcessorTest.assertEquals((String)expType, (String)formItem.getType());
        TaskFormProcessorTest.assertEquals((String)"api/task-instances/foo$Real Id", (String)formItem.getUrl());
    }

    public void testGenerateSingleProperty() {
        String fieldName = FormProcessorTest.STATUS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fieldName);
        Form form = this.processForm(fields);
        this.checkSingleProperty(form, fieldName, (Serializable)WorkflowTaskState.IN_PROGRESS);
        String fullPropertyName = "prop:" + fieldName;
        fields = Arrays.asList(fullPropertyName);
        form = this.processForm(fields);
        this.checkSingleProperty(form, fieldName, (Serializable)WorkflowTaskState.IN_PROGRESS);
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testGenerateSingleAssociation() {
        String fieldName = FormProcessorTest.ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fieldName);
        Form form = this.processForm(fields);
        Serializable fieldData = (Serializable)((Object)Arrays.asList(FormProcessorTest.FAKE_NODE.toString()));
        this.checkSingleAssociation(form, fieldName, fieldData);
        String fullAssociationName = "assoc:" + fieldName;
        fields = Arrays.asList(fullAssociationName);
        form = this.processForm(fields);
        this.checkSingleAssociation(form, fieldName, fieldData);
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testIgnoresUnknownFields() throws Exception {
        String fakeFieldName = "bpm:Fake Field";
        String statusFieldName = FormProcessorTest.STATUS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fakeFieldName, statusFieldName);
        Form form = this.processForm(fields);
        this.checkSingleProperty(form, statusFieldName, (Serializable)WorkflowTaskState.IN_PROGRESS);
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testGenerateDefaultForm() throws Exception {
        Form form = this.processForm(new String[0]);
        List fieldDefs = form.getFieldDefinitionNames();
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains(FormProcessorTest.ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains(FormProcessorTest.ASSOC_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains(FormProcessorTest.DESC_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains(FormProcessorTest.STATUS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains(FormProcessorTest.PROP_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains("packageItems"));
        TaskFormProcessorTest.assertTrue((boolean)fieldDefs.contains("transitions"));
        TaskFormProcessorTest.assertFalse((boolean)fieldDefs.contains(FormProcessorTest.ACTORS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PACKAGE_ACTION_GROUP.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        TaskFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        Serializable fieldData = (Serializable)((Object)Arrays.asList(FormProcessorTest.FAKE_NODE.toString()));
        FormData formData = form.getFormData();
        TaskFormProcessorTest.assertEquals((Object)fieldData, (Object)formData.getFieldData("assoc_bpm_assignee").getValue());
        this.checkPackageActionGroups(formData);
        TaskFormProcessorTest.assertEquals((Object)WorkflowTaskState.IN_PROGRESS, (Object)formData.getFieldData("prop_bpm_status").getValue());
    }

    public void testGenerateTransitions() throws Exception {
        String fieldName = "transitions";
        Form form = this.processForm(fieldName);
        String transitionValues = "";
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)transitionValues));
        WorkflowTransition transition1 = this.makeTransition("id1", "title1");
        WorkflowTransition transition2 = this.makeTransition("id2", "title2");
        WorkflowTransition transition3 = this.makeTransition("id3", "title3");
        this.task = this.makeTask(transition1, transition2, transition3);
        Serializable hiddenValue = (Serializable)((Object)Collections.singletonList("id3"));
        this.task.getProperties().put(WorkflowModel.PROP_HIDDEN_TRANSITIONS, hiddenValue);
        form = this.processForm(fieldName);
        transitionValues = "id1|title1,id2|title2";
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)transitionValues));
    }

    public void testGenerateMessage() throws Exception {
        String message = NO_MESSAGE;
        String fieldName = "message";
        Form form = this.processForm(fieldName);
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)message));
        message = "This is some text the user may have entered";
        this.task.getProperties().put(WorkflowModel.PROP_DESCRIPTION, message);
        form = this.processForm(fieldName);
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)message));
        this.task.getProperties().put(WorkflowModel.PROP_DESCRIPTION, this.task.getTitle());
        form = this.processForm(fieldName);
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)NO_MESSAGE));
    }

    public void testGenerateTaskOwner() throws Exception {
        String fieldName = "taskOwner";
        Form form = this.processForm(fieldName);
        this.checkSingleProperty(form, fieldName, null);
        this.task.getProperties().put(ContentModel.PROP_OWNER, "admin");
        form = this.processForm(fieldName);
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)"admin|System|Administrator"));
    }

    public void testGeneratePackageItems() throws Exception {
        String fieldName = "packageItems";
        Form form = this.processForm(fieldName);
        Serializable packageItems = (Serializable)((Object)Collections.emptyList());
        this.checkSingleAssociation(form, fieldName, packageItems);
        List<NodeRef> value = Arrays.asList(FormProcessorTest.FAKE_NODE, FormProcessorTest.FAKE_NODE2, FormProcessorTest.FAKE_NODE3);
        Mockito.when((Object)this.workflowService.getPackageContents(TASK_ID)).thenReturn(value);
        form = this.processForm(fieldName);
        packageItems = (Serializable)((Object)Arrays.asList(FormProcessorTest.FAKE_NODE.toString(), FormProcessorTest.FAKE_NODE2.toString(), FormProcessorTest.FAKE_NODE3.toString()));
        this.checkSingleAssociation(form, fieldName, packageItems);
    }

    private WorkflowTransition makeTransition(String id, String title) {
        return new WorkflowTransition(id, title, null, false);
    }

    public void testPersistPropertyChanged() throws Exception {
        String fieldName = FormProcessorTest.DESC_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "New Description";
        this.processPersist(dataKey, value);
        TaskFormProcessorTest.assertEquals((int)1, (int)this.actualProperties.size());
        TaskFormProcessorTest.assertEquals((Object)value, (Object)this.actualProperties.get(FormProcessorTest.DESC_NAME));
    }

    public void testPersistConvertsPropertyValueToCorrectType() {
        String fieldName = WorkflowModel.PROP_PRIORITY.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "2";
        this.processPersist(dataKey, value);
        TaskFormProcessorTest.assertEquals((Object)2, (Object)this.actualProperties.get(WorkflowModel.PROP_PRIORITY));
    }

    public void testPersistPropertyWith_() throws Exception {
        String fieldName = FormProcessorTest.PROP_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "New _ Value";
        this.processPersist(dataKey, value);
        TaskFormProcessorTest.assertEquals((int)1, (int)this.actualProperties.size());
        TaskFormProcessorTest.assertEquals((Object)value, (Object)this.actualProperties.get(FormProcessorTest.PROP_WITH_));
    }

    public void testPersistAssociationAdded() throws Exception {
        String fieldName = FormProcessorTest.ACTORS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, true);
        String nodeRef1 = FormProcessorTest.FAKE_NODE.toString() + "1";
        String nodeRef2 = FormProcessorTest.FAKE_NODE.toString() + "2";
        String value = nodeRef1 + ", " + nodeRef2;
        this.processPersist(dataKey, value);
        TaskFormProcessorTest.assertEquals((int)1, (int)this.actualAdded.size());
        List<NodeRef> nodeRefs = this.actualAdded.get(FormProcessorTest.ACTORS_NAME);
        TaskFormProcessorTest.assertNotNull(nodeRefs);
        TaskFormProcessorTest.assertEquals((int)2, (int)nodeRefs.size());
        TaskFormProcessorTest.assertTrue((boolean)nodeRefs.contains(new NodeRef(nodeRef1)));
        TaskFormProcessorTest.assertTrue((boolean)nodeRefs.contains(new NodeRef(nodeRef2)));
    }

    public void testPersistAssociationsRemoved() throws Exception {
        String fieldName = FormProcessorTest.ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, false);
        String value = FormProcessorTest.FAKE_NODE.toString();
        this.processPersist(dataKey, value);
        TaskFormProcessorTest.assertEquals((int)1, (int)this.actualRemoved.size());
        List<NodeRef> nodeRefs = this.actualRemoved.get(FormProcessorTest.ASSIGNEE_NAME);
        TaskFormProcessorTest.assertNotNull(nodeRefs);
        TaskFormProcessorTest.assertEquals((int)1, (int)nodeRefs.size());
        TaskFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE));
    }

    public void testPersistAssociationAddedWith_() throws Exception {
        String fieldName = FormProcessorTest.ASSOC_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, true);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2);
        this.processPersist(dataKey, value);
        TaskFormProcessorTest.assertEquals((int)1, (int)this.actualAdded.size());
        List<NodeRef> nodeRefs = this.actualAdded.get(FormProcessorTest.ASSOC_WITH_);
        TaskFormProcessorTest.assertNotNull(nodeRefs);
        TaskFormProcessorTest.assertEquals((int)2, (int)nodeRefs.size());
        TaskFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE));
        TaskFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE2));
    }

    public void testPersistTransitions() throws Exception {
        this.processPersist("prop_bpm_foo", "foo");
        ((WorkflowService)Mockito.verify((Object)this.workflowService, (VerificationMode)Mockito.times((int)1))).updateTask((String)Mockito.eq((Object)TASK_ID), Mockito.anyMap(), Mockito.anyMap(), Mockito.anyMap());
        ((WorkflowService)Mockito.verify((Object)this.workflowService, (VerificationMode)Mockito.never())).endTask((String)Mockito.eq((Object)TASK_ID), Mockito.anyString());
        String dataKey = this.makeDataKeyName("transitions");
        this.processPersist(dataKey, null);
        ((WorkflowService)Mockito.verify((Object)this.workflowService, (VerificationMode)Mockito.times((int)1))).endTask(TASK_ID, null);
        this.processPersist(dataKey, "foo");
        ((WorkflowService)Mockito.verify((Object)this.workflowService, (VerificationMode)Mockito.times((int)1))).endTask(TASK_ID, "foo");
    }

    public void testPersistPropertyAndTransition() throws Exception {
        FormData data = new FormData();
        data.addFieldData("prop_bpm_foo", (Object)"bar");
        String dataKey = this.makeDataKeyName("transitions");
        data.addFieldData(dataKey, (Object)"foo");
        WorkflowTask persistedItem = (WorkflowTask)this.processor.persist(this.item, data);
        TaskFormProcessorTest.assertEquals((Object)this.newTask, (Object)persistedItem);
        ((WorkflowService)Mockito.verify((Object)this.workflowService, (VerificationMode)Mockito.times((int)1))).updateTask((String)Mockito.eq((Object)TASK_ID), Mockito.anyMap(), Mockito.anyMap(), Mockito.anyMap());
        ((WorkflowService)Mockito.verify((Object)this.workflowService, (VerificationMode)Mockito.times((int)1))).endTask(TASK_ID, "foo");
    }

    public void testPersistPropertyComment() throws Exception {
        super.testPersistPropertyComment(TASK_ID);
    }

    public void testPersistPackageItemsAdded() throws Exception {
        this.mockPackageItems(FormProcessorTest.FAKE_NODE3);
        String dataKey = this.makeDataKeyName("packageItems", true);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2);
        this.processPersist(dataKey, value);
        this.checkAddPackageItem(FormProcessorTest.FAKE_NODE, true);
        this.checkAddPackageItem(FormProcessorTest.FAKE_NODE2, true);
        this.checkAddPackageItem(FormProcessorTest.FAKE_NODE3, false);
    }

    public void testPersistPackageItemsRemoved() throws Exception {
        this.mockPackageItems(FormProcessorTest.FAKE_NODE, FormProcessorTest.FAKE_NODE2);
        String dataKey = this.makeDataKeyName("packageItems", false);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2) + "," + String.valueOf(FormProcessorTest.FAKE_NODE3);
        this.processPersist(dataKey, value);
        this.checkRemovedPackageItem(FormProcessorTest.FAKE_NODE, true);
        this.checkRemovedPackageItem(FormProcessorTest.FAKE_NODE2, true);
        this.checkRemovedPackageItem(FormProcessorTest.FAKE_NODE3, false);
    }

    public void testEscapeMultiValuedProperty() throws Exception {
        try {
            ExtendedPropertyFieldProcessor extendedProcessor = new ExtendedPropertyFieldProcessor();
            extendedProcessor.addEscapedPropertyName(FormProcessorTest.STATUS_NAME);
            this.processor.setExtendedPropertyFieldProcessor(extendedProcessor);
            String fieldName = FormProcessorTest.STATUS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            List<String> fields = Arrays.asList(fieldName);
            Form form = this.processForm(fields);
            this.checkSingleProperty(form, fieldName, (Serializable)WorkflowTaskState.IN_PROGRESS);
            String fullPropertyName = "prop:" + fieldName;
            fields = Arrays.asList(fullPropertyName);
            form = this.processForm(fields);
            this.checkSingleProperty(form, fieldName, (Serializable)WorkflowTaskState.IN_PROGRESS);
            this.checkPackageActionGroups(form.getFormData());
        }
        finally {
            this.processor.setExtendedPropertyFieldProcessor(null);
        }
    }

    private void processPersist(String dataKey, String value) {
        FormData data = new FormData();
        data.addFieldData(dataKey, (Object)value);
        WorkflowTask persistedItem = (WorkflowTask)this.processor.persist(this.item, data);
        TaskFormProcessorTest.assertEquals((Object)this.newTask, (Object)persistedItem);
    }

    private Form processForm(String ... fields) {
        return this.processForm(Arrays.asList(fields));
    }

    private Form processForm(List<String> fields) {
        Form form = ((TaskFormProcessor)this.processor).generate(this.item, fields, null, null);
        return form;
    }

    private void checkPackageActionGroups(FormData formData) {
        FormData.FieldData pckgActionData = formData.getFieldData("prop_bpm_packageActionGroup");
        TaskFormProcessorTest.assertNotNull((Object)pckgActionData);
        TaskFormProcessorTest.assertEquals((Object)"", (Object)pckgActionData.getValue());
        FormData.FieldData pckgItemActionData = formData.getFieldData("prop_bpm_packageItemActionGroup");
        TaskFormProcessorTest.assertNotNull((Object)pckgItemActionData);
        TaskFormProcessorTest.assertEquals((Object)"read_package_item_actions", (Object)pckgItemActionData.getValue());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.item = new Item("task", TASK_ID);
        this.task = this.makeTask(new WorkflowTransition[0]);
        this.workflowService = this.makeWorkflowService();
        this.nodeService = this.makeNodeService();
        DictionaryService dictionaryService = this.makeDictionaryService();
        this.namespaceService = this.makeNamespaceService();
        this.authenticationService = this.makeAuthenticationService();
        this.personService = this.makePersonService();
        MockFieldProcessorRegistry fieldProcessorRegistry = new MockFieldProcessorRegistry(this.namespaceService, dictionaryService);
        DefaultFieldProcessor defaultProcessor = super.makeDefaultFieldProcessor(dictionaryService);
        this.processor = this.makeTaskFormProcessor(dictionaryService, fieldProcessorRegistry, defaultProcessor);
    }

    private TaskFormProcessor makeTaskFormProcessor(DictionaryService dictionaryService, MockFieldProcessorRegistry fieldProcessorRegistry, DefaultFieldProcessor defaultProcessor) {
        TaskFormProcessor processor1 = new TaskFormProcessor();
        processor1 = (TaskFormProcessor)super.makeTaskFormProcessor((AbstractWorkflowFormProcessor)processor1, dictionaryService, fieldProcessorRegistry, defaultProcessor);
        processor1.setAuthenticationService(this.authenticationService);
        processor1.setPersonService(this.personService);
        return processor1;
    }

    private WorkflowTask makeTask(WorkflowTransition ... transitions) {
        String id = TASK_ID;
        String title = "Test";
        WorkflowTaskState state = WorkflowTaskState.IN_PROGRESS;
        WorkflowTaskDefinition taskDef = this.makeTaskDefinition(transitions);
        HashMap<QName, Serializable> properties = this.makeTaskProperties();
        WorkflowDefinition definition = new WorkflowDefinition("42", "Test", "1.0", "Test", "Test", null);
        NodeRef wfPackage = FormProcessorTest.PCKG_NODE;
        WorkflowInstance instance = new WorkflowInstance(null, definition, null, null, wfPackage, null, true, null, null);
        WorkflowNode node = new WorkflowNode("", "", "", "", true, new WorkflowTransition[0]);
        WorkflowPath path = new WorkflowPath(null, instance, node, true);
        return new WorkflowTask(id, taskDef, null, title, null, state, path, properties);
    }

    private HashMap<QName, Serializable> makeTaskProperties() {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(FormProcessorTest.STATUS_NAME, (Serializable)WorkflowTaskState.IN_PROGRESS);
        properties.put(FormProcessorTest.ASSIGNEE_NAME, (Serializable)FormProcessorTest.FAKE_NODE);
        return properties;
    }

    private WorkflowTaskDefinition makeTaskDefinition(WorkflowTransition ... transitions) {
        String id = "DefinitionId";
        TypeDefinition metadata = this.makeTypeDef();
        WorkflowNode node = new WorkflowNode("", "", "", "", true, transitions);
        return new WorkflowTaskDefinition(id, node, metadata);
    }

    private TypeDefinition makeTypeDef() {
        TypeDefinition typeDef = (TypeDefinition)Mockito.mock(TypeDefinition.class);
        QName name = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"TaskDef");
        Mockito.when((Object)typeDef.getName()).thenReturn((Object)name);
        Map<QName, PropertyDefinition> propertyDefs = this.makeTaskPropertyDefs();
        Mockito.when((Object)typeDef.getProperties()).thenReturn(propertyDefs);
        Map<QName, AssociationDefinition> associationDefs = this.makeTaskAssociationDefs();
        Mockito.when((Object)typeDef.getAssociations()).thenReturn(associationDefs);
        return typeDef;
    }

    private Map<QName, PropertyDefinition> makeTaskPropertyDefs() {
        HashMap<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>();
        QName textType = DataTypeDefinition.TEXT;
        MockClassAttributeDefinition descValue = MockClassAttributeDefinition.mockPropertyDefinition(FormProcessorTest.DESC_NAME, textType);
        properties.put(FormProcessorTest.DESC_NAME, descValue);
        MockClassAttributeDefinition titleValue = MockClassAttributeDefinition.mockPropertyDefinition(FormProcessorTest.STATUS_NAME, textType);
        properties.put(FormProcessorTest.STATUS_NAME, titleValue);
        MockClassAttributeDefinition with_ = MockClassAttributeDefinition.mockPropertyDefinition(FormProcessorTest.PROP_WITH_, textType);
        properties.put(FormProcessorTest.PROP_WITH_, with_);
        QName pckgActionGroup = WorkflowModel.PROP_PACKAGE_ACTION_GROUP;
        MockClassAttributeDefinition pckgAction = MockClassAttributeDefinition.mockPropertyDefinition(pckgActionGroup, textType, "");
        properties.put(pckgActionGroup, pckgAction);
        QName pckgItemActionGroup = WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP;
        MockClassAttributeDefinition pckgItemAction = MockClassAttributeDefinition.mockPropertyDefinition(pckgItemActionGroup, textType, "read_package_item_actions");
        properties.put(pckgItemActionGroup, pckgItemAction);
        QName priorityName = WorkflowModel.PROP_PRIORITY;
        MockClassAttributeDefinition priorityDef = MockClassAttributeDefinition.mockPropertyDefinition(priorityName, DataTypeDefinition.INT, Integer.class, "0");
        properties.put(priorityName, priorityDef);
        return properties;
    }

    private NamespaceService makeNamespaceService() {
        NamespaceServiceMemoryImpl nsService = new NamespaceServiceMemoryImpl();
        nsService.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nsService.registerNamespace("rn", "http://www.alfresco.org/model/rendition/1.0");
        nsService.registerNamespace("bpm", "http://www.alfresco.org/model/bpm/1.0");
        return nsService;
    }

    private DictionaryService makeDictionaryService() {
        DictionaryService mock = (DictionaryService)Mockito.mock(DictionaryService.class);
        Mockito.when((Object)mock.getAnonymousType((QName)Mockito.any(), (Collection)Mockito.any())).thenReturn((Object)this.task.getDefinition().getMetadata());
        return mock;
    }

    private AuthenticationService makeAuthenticationService() {
        AuthenticationService mock = (AuthenticationService)Mockito.mock(AuthenticationService.class);
        Mockito.when((Object)mock.getCurrentUserName()).thenReturn((Object)"admin");
        return mock;
    }

    private PersonService makePersonService() {
        PersonService mock = (PersonService)Mockito.mock(PersonService.class);
        Mockito.when((Object)mock.getPerson("admin")).thenReturn((Object)USER_NODE);
        return mock;
    }

    private WorkflowService makeWorkflowService() {
        WorkflowService service = (WorkflowService)Mockito.mock(WorkflowService.class);
        Mockito.when((Object)service.getTaskById((String)Mockito.any())).thenAnswer((Answer)new Answer<WorkflowTask>(){

            public WorkflowTask answer(InvocationOnMock invocation) throws Throwable {
                String id = (String)invocation.getArguments()[0];
                if (TaskFormProcessorTest.TASK_ID.equals(id)) {
                    return TaskFormProcessorTest.this.task;
                }
                return null;
            }
        });
        this.newTask = new WorkflowTask(TASK_ID, null, null, null, null, null, null, null);
        Mockito.when((Object)service.updateTask((String)Mockito.any(), Mockito.anyMap(), Mockito.anyMap(), Mockito.anyMap())).thenAnswer((Answer)new Answer<WorkflowTask>(){

            public WorkflowTask answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Map props = (Map)args[1];
                TaskFormProcessorTest.this.actualProperties = new HashMap<QName, Serializable>(props);
                Map added = (Map)args[2];
                TaskFormProcessorTest.this.actualAdded = new HashMap<QName, List<NodeRef>>(added);
                Map removed = (Map)args[3];
                TaskFormProcessorTest.this.actualRemoved = new HashMap<QName, List<NodeRef>>(removed);
                return TaskFormProcessorTest.this.newTask;
            }
        });
        Mockito.when((Object)service.endTask((String)Mockito.eq((Object)TASK_ID), (String)Mockito.any())).thenReturn((Object)this.newTask);
        Mockito.when((Object)service.isTaskEditable((WorkflowTask)Mockito.any(), (String)Mockito.any())).thenReturn((Object)true);
        return service;
    }

    private NodeService makeNodeService() {
        NodeService service = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)service.hasAspect(FormProcessorTest.PCKG_NODE, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)).thenReturn((Object)true);
        HashMap<QName, String> props = new HashMap<QName, String>(2);
        props.put(ContentModel.PROP_FIRSTNAME, "System");
        props.put(ContentModel.PROP_LASTNAME, "Administrator");
        Mockito.when((Object)service.getProperties(USER_NODE)).thenReturn(props);
        return service;
    }
}

