/*
 * #%L
 * Alfresco Repository
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.filesys.repo.rules.operations;

import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.service.cmr.repository.NodeRef;

public class DeleteFileOperation implements Operation
{

    private String name;
    private NodeRef rootNodeRef;
    private String path;

    /**
     * Delete File Operation
     * 
     * @param name
     *            of file
     * @param rootNodeRef
     *            root node ref
     * @param path
     *            path + name of file to delete
     */
    public DeleteFileOperation(String name, NodeRef rootNodeRef, String path)
    {
        this.name = name;
        this.rootNodeRef = rootNodeRef;
        this.path = path;
    }

    public String getName()
    {
        return name;
    }

    public String getPath()
    {
        return path;
    }

    public NodeRef getRootNodeRef()
    {
        return rootNodeRef;
    }

    public String toString()
    {
        return "DeleteFileOperation: " + name;
    }

    public int hashCode()
    {
        return name.hashCode();
    }

    public boolean equals(Object o)
    {
        if (o instanceof DeleteFileOperation)
        {
            DeleteFileOperation c = (DeleteFileOperation) o;
            if (name.equals(c.getName()))
            {
                return true;
            }
        }
        return false;
    }

}
