/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.io.Serializable;
import java.util.Random;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class RuleTriggerTest
extends BaseSpringTest {
    private static final String ON_CREATE_NODE_TRIGGER = "on-create-node-trigger";
    private static final String ON_UPDATE_NODE_TRIGGER = "on-update-node-trigger";
    private static final String ON_MOVE_NODE_TRIGGER = "on-move-node-trigger";
    private static final String ON_CREATE_CHILD_ASSOCIATION_TRIGGER = "on-create-child-association-trigger";
    private static final String ON_DELETE_CHILD_ASSOCIATION_TRIGGER = "on-delete-child-association-trigger";
    private static final String ON_CREATE_ASSOCIATION_TRIGGER = "on-create-association-trigger";
    private static final String ON_DELETE_ASSOCIATION_TRIGGER = "on-delete-association-trigger";
    private static final String ON_PROPERTY_UPDATE_TRIGGER = "on-property-update-trigger";
    private static final String ON_CONTENT_CREATE_TRIGGER = "on-content-create-trigger";
    private NodeService nodeService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;

    @Before
    public void before() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.nodeService = serviceRegistry.getNodeService();
        this.contentService = serviceRegistry.getContentService();
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
    }

    @After
    public void after() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testOnCreateNodeTrigger() {
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnCreateIgnoredTypesTrigger() {
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.createNode(this.rootNodeRef, ForumModel.ASSOC_DISCUSSION, ForumModel.ASSOC_DISCUSSION, ForumModel.TYPE_POST);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnUpdateNodeTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_UPDATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"nameChanged"));
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnCreateChildAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_CHILD_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.addChild(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnDeleteChildAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addChild(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN);
        TestRuleType ruleType = this.createTestRuleType(ON_DELETE_CHILD_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.removeChild(nodeRef, nodeRef2);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnCreateAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.createAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnCreateOriginalAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.createAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_ORIGINAL);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnDeleteAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.createAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN);
        TestRuleType ruleType = this.createTestRuleType(ON_DELETE_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.removeAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    @Test
    public void testOnContentCreateTrigger() {
        TestRuleType nodeCreate = this.createTestRuleType(ON_CREATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)nodeCreate.rulesTriggered);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
        RuleTriggerTest.assertTrue((boolean)nodeCreate.rulesTriggered);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        TestRuleType contentCreate = this.createTestRuleType(ON_CONTENT_CREATE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)contentCreate.rulesTriggered);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent("some content");
        RuleTriggerTest.assertTrue((boolean)contentCreate.rulesTriggered);
        contentCreate.rulesTriggered = false;
        RuleTriggerTest.assertFalse((boolean)contentCreate.rulesTriggered);
        ContentWriter contentWriter2 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.setMimetype("text/plain");
        contentWriter2.setEncoding("UTF-8");
        contentWriter2.putContent("some content");
        RuleTriggerTest.assertFalse((boolean)contentCreate.rulesTriggered);
    }

    @Test
    public void testOnContentUpdateTrigger() {
        TestRuleType nodeCreate = this.createTestRuleType(ON_CREATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)nodeCreate.rulesTriggered);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
        RuleTriggerTest.assertTrue((boolean)nodeCreate.rulesTriggered);
        TestRuleType contentCreate = this.createTestRuleType(ON_CONTENT_CREATE_TRIGGER);
        TestRuleType contentUpdate = this.createTestRuleType(ON_PROPERTY_UPDATE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)contentCreate.rulesTriggered);
        RuleTriggerTest.assertFalse((boolean)contentUpdate.rulesTriggered);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent("some content");
        RuleTriggerTest.assertTrue((boolean)contentCreate.rulesTriggered);
        RuleTriggerTest.assertFalse((boolean)contentUpdate.rulesTriggered);
        contentCreate.rulesTriggered = false;
        RuleTriggerTest.assertFalse((boolean)contentCreate.rulesTriggered);
        ContentWriter contentWriter2 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.setMimetype("text/plain");
        contentWriter2.setEncoding("UTF-8");
        contentWriter2.putContent("more content some content");
        RuleTriggerTest.assertTrue((boolean)contentCreate.rulesTriggered);
        RuleTriggerTest.assertFalse((String)"Content update must not fire if the content was created in the same txn.", (boolean)contentUpdate.rulesTriggered);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        contentCreate.rulesTriggered = false;
        ContentWriter contentWriter3 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter3.setMimetype("text/plain");
        contentWriter3.setEncoding("UTF-8");
        contentWriter3.putContent("Yet content some content");
        RuleTriggerTest.assertFalse((String)"Content create should not be fired on an update in a new txn", (boolean)contentCreate.rulesTriggered);
        RuleTriggerTest.assertTrue((String)"Content update must not fire if the content was created in the same txn.", (boolean)contentUpdate.rulesTriggered);
    }

    @Test
    public void testOnMoveNodeTrigger() {
        NodeRef nodeRef1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.createNode(nodeRef2, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.createNode(nodeRef2, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_MOVE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.moveNode(nodeRef2, nodeRef1, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
        RuleTriggerTest.assertEquals((int)3, (int)ruleType.triggerCount);
    }

    @Test
    public void testOnPropertyUpdateRuleTrigger() {
        NodeRef nodeRef1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef1, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent("some content");
        Random rand = new Random();
        this.nodeService.setProperty(nodeRef1, ContentModel.PROP_CASCADE_CRC, (Serializable)Long.valueOf(rand.nextLong()));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        TestRuleType contentUpdate = this.createTestRuleType(ON_PROPERTY_UPDATE_TRIGGER);
        this.nodeService.setProperty(nodeRef1, ContentModel.PROP_CASCADE_CRC, (Serializable)Long.valueOf(rand.nextLong()));
        RuleTriggerTest.assertFalse((boolean)contentUpdate.rulesTriggered);
        RuleTriggerTest.assertEquals((String)"trigger count not matching", (int)0, (int)contentUpdate.triggerCount);
    }

    private TestRuleType createTestRuleType(String ruleTriggerName) {
        RuleTrigger ruleTrigger = (RuleTrigger)this.applicationContext.getBean(ruleTriggerName);
        RuleTriggerTest.assertNotNull((Object)ruleTrigger);
        TestRuleType ruleType = new TestRuleType();
        ruleTrigger.registerRuleType((RuleType)ruleType);
        return ruleType;
    }

    private class TestRuleType
    implements RuleType {
        public boolean rulesTriggered = false;
        public int triggerCount = 0;

        private TestRuleType() {
        }

        public String getName() {
            return "testRuleType";
        }

        public String getDisplayLabel() {
            return "displayLabel";
        }

        public void triggerRuleType(NodeRef nodeRef, NodeRef actionedUponNodeRef, boolean executeRuleImmediately) {
            this.rulesTriggered = true;
            ++this.triggerCount;
        }
    }
}

