/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.store.VirtualStoreImpl;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@Category(value={LuceneTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class VirtualFileFolderServiceExtensionTest
extends VirtualizationIntegrationTest {
    private static final String NEW_FILE_NAME_2 = "RenameTest2";
    private static final String NEW_FILE_NAME_1 = "RenamedTest";
    private VirtualStoreImpl smartStore;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.smartStore = (VirtualStoreImpl)this.ctx.getBean("smartStore", VirtualStoreImpl.class);
    }

    @Test
    public void testListOne() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CHILDREN, "Node2");
        this.createContent(node2, "testfile.txt");
        List node2Contents = this.fileAndFolderService.list(node2);
        Assert.assertEquals((long)2L, (long)node2Contents.size());
        FileInfo testFolderFileInfo = (FileInfo)node2Contents.get(0);
        Assert.assertEquals((Object)"Node2_1", (Object)testFolderFileInfo.getName());
        FileInfo testFileFileInfo = (FileInfo)node2Contents.get(1);
        Assert.assertEquals((Object)"testfile.txt", (Object)testFileFileInfo.getName());
    }

    @Test
    public void testListActualFolders() throws Exception {
        this.createFolder(this.virtualFolder1NodeRef, "Actual1");
        List contents = this.fileAndFolderService.list(this.virtualFolder1NodeRef);
        Assert.assertEquals((long)3L, (long)contents.size());
        this.assertContainsNames(contents, "Node1", "Node2", "Actual1");
    }

    private void assertContainsNames(List<FileInfo> contents, String ... names) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileInfo fileInfo : contents) {
            fileNames.add(fileInfo.getName());
        }
        Assert.assertTrue((boolean)fileNames.containsAll(Arrays.asList(names)));
    }

    private void assertMissesNames(List<FileInfo> contents, String ... names) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileInfo fileInfo : contents) {
            fileNames.add(fileInfo.getName());
        }
        ArrayList<String> missedNames = new ArrayList<String>(Arrays.asList(names));
        Assert.assertFalse((boolean)missedNames.removeAll(fileNames));
    }

    @Test
    public void testListNonVirtualizable() throws Exception {
        NodeRef nv = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testListNonVirtualizable", null);
        List emptyList = this.fileAndFolderService.list(nv);
        Assert.assertTrue((boolean)emptyList.isEmpty());
    }

    @Test
    public void testSearch() throws Exception {
        NodeRef node1 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node1");
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        String fileName = "testfile.txt";
        this.fileAndFolderService.create(node1, fileName, ContentModel.TYPE_CONTENT);
        this.fileAndFolderService.create(node2, fileName, ContentModel.TYPE_CONTENT);
        List search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, "testfile.txt", true, false, true);
        Assert.assertEquals((long)2L, (long)search.size());
        search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, "testfile-1.txt", true, false, true);
        Assert.assertEquals((long)2L, (long)search.size());
        search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, "testfile.txt", true, false, false);
        Assert.assertEquals((long)1L, (long)search.size());
        search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, null, true, false, true);
        Assert.assertEquals((long)4L, (long)search.size());
        search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, null, true, false, false);
        Assert.assertEquals((long)2L, (long)search.size());
        search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, null, false, true, false);
        Assert.assertEquals((long)2L, (long)search.size());
        search = this.fileAndFolderService.search(this.virtualFolder1NodeRef, null, false, true, true);
        Assert.assertEquals((long)3L, (long)search.size());
    }

    @Test
    public void testListVirtualizedVirtualChild() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node1 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CHILDREN, "Node1");
        NodeRef virtulizedFolder = this.createVirtualizedFolder(vf, "TestVirtualFileFolderService_testVirtualFolderVirtualChild_CVF", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        this.nodeService.setProperty(virtulizedFolder, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Node1_content_FR"));
        NodeRef vfchildvf = this.nodeService.getChildByName(node1, ContentModel.ASSOC_CHILDREN, "TestVirtualFileFolderService_testVirtualFolderVirtualChild_CVF");
        Assert.assertNotNull((String)"Virtual child expected.", (Object)vfchildvf);
        List vfchildvfList = this.fileAndFolderService.list(vfchildvf);
        this.assertContainsNames(vfchildvfList, "Node1", "Node2");
        PagingResults vfchildvfResults = this.fileAndFolderService.list(vfchildvf, null, null, null, new PagingRequest(100));
        List page = vfchildvfResults.getPage();
        this.assertContainsNames(page, "Node1", "Node2");
        vfchildvfResults = this.fileAndFolderService.list(vfchildvf, true, true, null, null, null, new PagingRequest(100));
        page = vfchildvfResults.getPage();
        this.assertContainsNames(page, "Node1", "Node2");
    }

    @Test
    public void testListFileFolderDisjunction() throws Exception {
        List page;
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node2 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CHILDREN, "Node2");
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Node2_folder_FR"));
        ChildAssociationRef createFolder = this.createFolder(vf, "FolderVirtualChild", properties);
        ChildAssociationRef createContent = this.createContent(node2, "ContentVirtualChild");
        this.prepareMocks("Node2", createFolder.getChildRef());
        try {
            PagingResults folderChildren = this.fileAndFolderService.list(node2, false, true, "*", Collections.emptySet(), Collections.emptyList(), new PagingRequest(100));
            page = folderChildren.getPage();
            this.assertContainsNames(page, "FolderVirtualChild");
            this.assertMissesNames(page, "ContentVirtualChild");
        }
        finally {
            this.resetMocks();
        }
        this.prepareMocks("Node2", this.smartStore.materializeIfPossible(createContent.getChildRef()));
        try {
            PagingResults contentChildren = this.fileAndFolderService.list(node2, true, false, "*", Collections.emptySet(), Collections.emptyList(), new PagingRequest(100));
            page = contentChildren.getPage();
            this.assertMissesNames(page, "FolderVirtualChild");
            this.assertContainsNames(page, "ContentVirtualChild");
        }
        finally {
            this.resetMocks();
        }
    }

    @Test
    public void testListWithIgnores() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node2 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CHILDREN, "Node2");
        NodeRef contentNodeRef = this.createContent(node2, "ContentVirtualChild").getChildRef();
        CheckOutCheckInService checkOutCheckInService = (CheckOutCheckInService)this.ctx.getBean("checkOutCheckInService", CheckOutCheckInService.class);
        checkOutCheckInService.checkout(contentNodeRef);
        Set searchTypeQNames = Collections.emptySet();
        Set<QName> ignoreAspectQNames = Collections.singleton(ContentModel.ASPECT_CHECKED_OUT);
        List sortProps = Collections.emptyList();
        PagingRequest pagingRequest = new PagingRequest(100);
        PagingResults node2List = this.fileAndFolderService.list(node2, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
        Assert.assertEquals((long)1L, (long)node2List.getPage().size());
    }

    @Test
    public void testCreateTempFile() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node2 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CHILDREN, "Node2");
        String contentName = "ContentVirtualChild";
        this.createContent(node2, contentName);
        this.nodeService.getChildByName(node2, ContentModel.ASSOC_CHILDREN, contentName);
        File file = File.createTempFile("dedededede", ".tmp", TempFileProvider.getTempDir());
        Assert.assertNotNull((Object)file);
    }

    @Test
    public void testRename() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node2 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, "Node2");
        String contentName = "ContentVirtualChild";
        this.createContent(node2, contentName);
        NodeRef childByName = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, contentName);
        FileInfo renamedFileInfo = this.fileAndFolderService.rename(childByName, NEW_FILE_NAME_1);
        Assert.assertNotNull((Object)renamedFileInfo);
        Assert.assertEquals((Object)NEW_FILE_NAME_1, (Object)this.nodeService.getProperty(childByName, ContentModel.PROP_NAME));
        Assert.assertNull((Object)this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, contentName));
        Assert.assertNull((Object)this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, contentName));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_1));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_1));
        childByName = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_1);
        renamedFileInfo = this.fileAndFolderService.rename(childByName, NEW_FILE_NAME_2);
        Assert.assertNotNull((Object)renamedFileInfo);
        Assert.assertEquals((Object)NEW_FILE_NAME_2, (Object)this.nodeService.getProperty(childByName, ContentModel.PROP_NAME));
        Assert.assertNull((Object)this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_1));
        Assert.assertNull((Object)this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_1));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_2));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, NEW_FILE_NAME_2));
    }

    @Test
    public void testListNamePattern() throws Exception {
        ArrayList<Pair> sortProps = new ArrayList<Pair>(1);
        sortProps.add(new Pair((Object)ContentModel.PROP_NAME, (Object)false));
        String name = "A N.&ame.txt";
        String name1 = "A N.&ame-1.txt";
        String nameAfter = "XXName.txt";
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node1 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, "Node1");
        ChildAssociationRef createContent = this.createContent(node1, name, "0", "text/plain", "UTF-8");
        ChildAssociationRef createContent1 = this.createContent(node1, name1, "01", "text/plain", "UTF-8");
        this.createContent(node1, nameAfter, "1", "text/plain", "UTF-8");
        String namePattern = "A N.&ame*.txt";
        ArrayList<NodeRef> querySolution = new ArrayList<NodeRef>();
        querySolution.add(this.smartStore.materializeIfPossible(createContent1.getChildRef()));
        querySolution.add(this.smartStore.materializeIfPossible(createContent.getChildRef()));
        this.prepareMocks("A", querySolution);
        try {
            PagingResults results = this.fileAndFolderService.list(node1, true, false, namePattern, null, sortProps, new PagingRequest(Integer.MAX_VALUE));
            List page = results.getPage();
            Assert.assertEquals((long)2L, (long)page.size());
            Assert.assertEquals((Object)((FileInfo)page.get(0)).getName(), (Object)name1);
            Assert.assertEquals((Object)((FileInfo)page.get(1)).getName(), (Object)name);
        }
        finally {
            this.resetMocks();
        }
    }

    @Test
    public void testLastDuplicate() throws Exception {
        ArrayList<Pair> sortProps = new ArrayList<Pair>(1);
        sortProps.add(new Pair((Object)ContentModel.PROP_NAME, (Object)false));
        String name = "AName.txt";
        String nameAfter = "XXName.txt";
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node1 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, "Node1");
        this.createContent(node1, name, "0", "text/plain", "UTF-8");
        NodeRef aNameNodeRef = this.nodeService.getChildByName(node1, ContentModel.ASSOC_CHILDREN, name);
        this.createContent(node1, nameAfter, "1", "text/plain", "UTF-8");
        NodeRef nameAfterNodeRef = this.nodeService.getChildByName(node1, ContentModel.ASSOC_CHILDREN, nameAfter);
        String namePattern = this.addWildCardInName(name, this.fileAndFolderService.getFileInfo(aNameNodeRef).getContentData().getMimetype());
        this.prepareMocks("=cm:name:AName", this.smartStore.materializeIfPossible(aNameNodeRef));
        try {
            PagingResults results = this.fileAndFolderService.list(this.nodeService.getPrimaryParent(aNameNodeRef).getParentRef(), true, false, namePattern, null, sortProps, new PagingRequest(Integer.MAX_VALUE));
            List page = results.getPage();
            Assert.assertTrue((page.size() > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)((FileInfo)page.get(0)).getNodeRef().equals((Object)nameAfterNodeRef));
        }
        finally {
            this.resetMocks();
        }
    }

    private String addWildCardInName(String name, String mimetype) {
        MimetypeService mimetypeService = (MimetypeService)this.ctx.getBean("mimetypeService", MimetypeService.class);
        String extension = mimetypeService.getExtension(mimetype);
        return name.substring(0, name.length() - (extension.length() + 1)).concat("*." + extension);
    }

    @Test
    public void testListUsedWithCMIS() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "TestVirtualFileFolderService_testVirtualFolderVirtualChild", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node2 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CONTAINS, "Node2");
        String contentName = "ContentVirtualChild";
        this.createContent(node2, contentName);
        NodeRef childByName = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, contentName);
        FileInfo renamedFileInfo = this.fileAndFolderService.rename(childByName, NEW_FILE_NAME_1);
        Assert.assertNotNull((Object)renamedFileInfo);
        Assert.assertEquals((Object)NEW_FILE_NAME_1, (Object)this.nodeService.getProperty(childByName, ContentModel.PROP_NAME));
        List sortProps = Collections.emptyList();
        PagingRequest pagingRequest = new PagingRequest(100);
        PagingResults results = this.fileAndFolderService.list(vf, true, true, null, sortProps, pagingRequest);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        String contentName1 = "ContentVirtualChild";
        this.createContent(node2, contentName1);
        results = this.fileAndFolderService.list(vf, true, true, null, sortProps, pagingRequest);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)4L, (long)results.getPage().size());
    }
}

