/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.VersionType;

public class CheckInActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "check-in";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_MINOR_CHANGE = "minorChange";
    private NodeService nodeService;
    private CheckOutCheckInService cociService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCociService(CheckOutCheckInService cociService) {
        this.cociService = cociService;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef) && this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            String description = (String)((Object)ruleAction.getParameterValue(PARAM_DESCRIPTION));
            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
            versionProperties.put(PARAM_DESCRIPTION, (Serializable)((Object)description));
            Boolean minorChange = (Boolean)ruleAction.getParameterValue(PARAM_MINOR_CHANGE);
            if (minorChange != null && !minorChange.booleanValue()) {
                versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
            } else {
                versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
            }
            this.cociService.checkin(actionedUponNodeRef, versionProperties);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESCRIPTION, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_DESCRIPTION)));
        paramList.add(new ParameterDefinitionImpl(PARAM_MINOR_CHANGE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_MINOR_CHANGE)));
    }
}

