/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.util.ReflectionUtils;

public class TemporaryMockOverride
extends ExternalResource {
    private static final Log log = LogFactory.getLog(TemporaryMockOverride.class);
    private List<FieldValueOverride> pristineFieldValues = new ArrayList<FieldValueOverride>();

    protected void before() throws Throwable {
    }

    protected void after() {
        int i = this.pristineFieldValues.size() - 1;
        while (i >= 0) {
            FieldValueOverride override = this.pristineFieldValues.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reverting mocked field '" + override.fieldName + "' on object " + String.valueOf(override.objectContainingField) + " to original value '" + String.valueOf(override.fieldPristineValue) + "'"));
            }
            Field f = ReflectionUtils.findField(override.objectContainingField.getClass(), (String)override.fieldName);
            ReflectionUtils.makeAccessible((Field)f);
            ReflectionUtils.setField((Field)f, (Object)override.objectContainingField, (Object)override.fieldPristineValue);
            --i;
        }
    }

    public void setTemporaryField(Object objectContainingField, String fieldName, Object fieldValue) {
        Field f;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Overriding field '" + fieldName + "' on object " + String.valueOf(objectContainingField) + " to new value '" + String.valueOf(fieldValue) + "'"));
        }
        if ((f = ReflectionUtils.findField(objectContainingField.getClass(), (String)fieldName)) == null) {
            String msg = "Object of type '" + objectContainingField.getClass().getSimpleName() + "' has no field named '" + fieldName + "'";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            throw new IllegalArgumentException(msg);
        }
        ReflectionUtils.makeAccessible((Field)f);
        Object pristineValue = ReflectionUtils.getField((Field)f, (Object)objectContainingField);
        this.pristineFieldValues.add(new FieldValueOverride(objectContainingField, fieldName, pristineValue));
        ReflectionUtils.setField((Field)f, (Object)objectContainingField, (Object)fieldValue);
    }

    private static class FieldValueOverride {
        public final Object objectContainingField;
        public final String fieldName;
        public final Object fieldPristineValue;

        public FieldValueOverride(Object objectContainingField, String fieldName, Object pristineValue) {
            this.objectContainingField = objectContainingField;
            this.fieldName = fieldName;
            this.fieldPristineValue = pristineValue;
        }
    }
}

