/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.List;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.util.PropertyCheck;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class HBBaseDataCollector {
    private final String collectorId;
    private final String collectorVersion;
    private final String cronExpression;
    private HBDataCollectorService hbDataCollectorService;
    private HeartBeatJobScheduler hbJobScheduler;

    public HBBaseDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        PropertyCheck.mandatory((Object)this, (String)"collectorId", (Object)collectorId);
        PropertyCheck.mandatory((Object)this, (String)"collectorVersion", (Object)collectorVersion);
        PropertyCheck.mandatory((Object)this, (String)"cronExpression", (Object)cronExpression);
        PropertyCheck.mandatory((Object)this, (String)"hbJobScheduler", (Object)hbJobScheduler);
        this.collectorId = collectorId;
        this.collectorVersion = collectorVersion;
        this.cronExpression = cronExpression;
        this.hbJobScheduler = hbJobScheduler;
    }

    public String getCollectorId() {
        return this.collectorId;
    }

    public String getCollectorVersion() {
        return this.collectorVersion;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setHbDataCollectorService(HBDataCollectorService hbDataCollectorService) {
        this.hbDataCollectorService = hbDataCollectorService;
    }

    public void setHbJobScheduler(HeartBeatJobScheduler hbJobScheduler) {
        ParameterCheck.mandatory((String)"hbJobScheduler", (Object)hbJobScheduler);
        this.hbJobScheduler = hbJobScheduler;
    }

    public HeartBeatJobScheduler getHbJobScheduler() {
        return this.hbJobScheduler;
    }

    public void register() {
        if (this.hbDataCollectorService == null) {
            throw new IllegalStateException("HbDataCollectorService needs to be set before calling this method.");
        }
        this.hbDataCollectorService.registerCollector(this);
    }

    public void deregister() {
        if (this.hbDataCollectorService == null) {
            throw new IllegalStateException("HbDataCollectorService needs to be set before calling this method.");
        }
        this.hbDataCollectorService.deregisterCollector(this);
    }

    public abstract List<HBData> collectData();
}

