/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.UUID;
import org.alfresco.repo.site.SiteInfoImpl;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SiteMembershipTest {
    SiteInfo siteInfo;
    SiteMembership siteMember;
    String personId = UUID.randomUUID().toString();
    String firstName = UUID.randomUUID().toString();
    String lastName = UUID.randomUUID().toString();
    String role = "Consumer";
    String idErrorMessage = "Id required building site membership";
    String firstNameErrorMessage = "FirstName required building site membership of ";
    String lastNameErrorMessage = "LastName required building site membership of ";
    String roleErrorMessage = "Role required building site membership";

    @Before
    public void createSite() {
        String sitePreset = "testSiteMembershipPreset";
        String shortName = "testSiteMembershipShortName";
        String title = "testSiteMembershipTile";
        String description = "testSiteMembershipDescription";
        this.siteInfo = new SiteInfoImpl(sitePreset, shortName, title, description, SiteVisibility.PUBLIC, null);
    }

    @Test
    public void testNullpersonInfo() throws Exception {
        try {
            this.siteMember = new SiteMembership(this.siteInfo, null, this.firstName, this.lastName, this.role);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)this.idErrorMessage, (Object)e.getMessage());
        }
        try {
            this.siteMember = new SiteMembership(this.siteInfo, null, this.role);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)this.idErrorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testNullRole() throws Exception {
        try {
            this.siteMember = new SiteMembership(this.siteInfo, this.personId, this.firstName, this.lastName, null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)this.roleErrorMessage, (Object)e.getMessage());
        }
        try {
            this.siteMember = new SiteMembership(this.siteInfo, this.personId, null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)this.roleErrorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testNullFirstName() throws Exception {
        try {
            this.siteMember = new SiteMembership(this.siteInfo, this.personId, null, this.lastName, this.role);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)(this.firstNameErrorMessage + this.siteInfo.getShortName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testNullLastName() throws Exception {
        try {
            this.siteMember = new SiteMembership(this.siteInfo, this.personId, this.firstName, null, this.role);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)(this.lastNameErrorMessage + this.siteInfo.getShortName()), (Object)e.getMessage());
        }
    }
}

