/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.repo.index.shard.ShardInstance;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.util.Pair;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.springframework.beans.factory.BeanFactory;

public class DynamicSolrStoreMappingWrapperFactory {
    static ConcurrentHashMap<Pair<String, Integer>, HttpClient> clients = new ConcurrentHashMap();

    public static SolrStoreMappingWrapper wrap(List<ShardInstance> slice, BeanFactory beanFactory) {
        HttpClientFactory httpClientFactory = (HttpClientFactory)beanFactory.getBean("solrHttpClientFactory");
        for (ShardInstance instance : slice) {
            Pair key = new Pair((Object)instance.getHostName(), (Object)instance.getPort());
            if (clients.contains(key)) continue;
            clients.put((Pair<String, Integer>)key, (HttpClient)httpClientFactory.getHttpClient((String)key.getFirst(), ((Integer)key.getSecond()).intValue()));
        }
        return new DynamicSolrStoreMappingWrapper(slice);
    }

    static class DynamicSolrStoreMappingWrapper
    implements SolrStoreMappingWrapper {
        private List<ShardInstance> slice;

        DynamicSolrStoreMappingWrapper(List<ShardInstance> slice) {
            this.slice = slice;
        }

        @Override
        public Pair<HttpClient, String> getHttpClientAndBaseUrl() {
            int base = ThreadLocalRandom.current().nextInt(this.slice.size());
            ShardInstance instance = this.slice.get(base);
            Pair key = new Pair((Object)instance.getHostName(), (Object)instance.getPort());
            HttpClient client = clients.get(key);
            return new Pair((Object)client, (Object)instance.getBaseUrl());
        }

        @Override
        public boolean isSharded() {
            return this.slice.size() > 1;
        }

        @Override
        public String getShards() {
            try {
                URLCodec encoder = new URLCodec();
                StringBuilder builder = new StringBuilder();
                for (ShardInstance instance : this.slice) {
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    Pair key = new Pair((Object)instance.getHostName(), (Object)instance.getPort());
                    HttpClient client = clients.get(key);
                    builder.append(encoder.encode(client.getHostConfiguration().getProtocol().getScheme() + "://", "UTF-8"));
                    builder.append(encoder.encode(instance.getHostName(), "UTF-8"));
                    builder.append(':');
                    builder.append(encoder.encode("" + instance.getPort(), "UTF-8"));
                    if (!instance.getBaseUrl().startsWith("/")) {
                        builder.append('/');
                    }
                    builder.append(encoder.encode(instance.getBaseUrl(), "UTF-8"));
                }
                return builder.toString();
            }
            catch (UnsupportedEncodingException e) {
                throw new QueryParserException("", e);
            }
        }
    }
}

