/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.Serializable;
import org.alfresco.repo.virtual.template.PropertyValueConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.SearchLanguageConversion;

public class NamePatternPropertyValueConstraint
extends PropertyValueConstraint {
    private QName property;
    private Serializable value;
    private NamespacePrefixResolver nspResolver;

    public NamePatternPropertyValueConstraint(VirtualQueryConstraint decoratedConstraint, QName property, Serializable value, NamespacePrefixResolver nspResolver) {
        super(decoratedConstraint, property, value, nspResolver);
        this.property = property;
        this.value = value;
        this.nspResolver = nspResolver;
    }

    @Override
    protected SearchParameters applyFTS(SearchParameters searchParameters) {
        StringBuffer luceneReserved = new StringBuffer();
        int i = 0;
        while (i < this.value.toString().length()) {
            if (SearchLanguageConversion.DEF_LUCENE.isReserved(this.value.toString().charAt(i))) {
                luceneReserved.append(this.value.toString().charAt(i));
            }
            ++i;
        }
        String luceneReservedStr = luceneReserved.toString();
        String pattern = ISO9075.encode((String)this.value.toString());
        int i2 = 0;
        while (i2 < luceneReservedStr.length()) {
            pattern = pattern.replace(ISO9075.encode((String)luceneReservedStr.substring(i2, i2 + 1)), luceneReservedStr.substring(i2, i2 + 1));
            ++i2;
        }
        String filePattern = SearchLanguageConversion.escapeForLucene((String)pattern);
        SearchParameters constrainedParameters = searchParameters.copy();
        String theQuery = constrainedParameters.getQuery();
        StringBuilder sb = new StringBuilder();
        sb.append("(" + theQuery + ")");
        sb.append(" and (");
        sb.append("TEXT:(").append(filePattern).append(") ");
        sb.append("or (");
        sb.append(" =").append(this.property.toPrefixString(this.nspResolver));
        sb.append(":").append(filePattern);
        sb.append(" ) ");
        sb.append(")");
        theQuery = sb.toString();
        constrainedParameters.setQuery(theQuery);
        return constrainedParameters;
    }
}

