/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.tasklistener;

import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.service.cmr.dictionary.TypeDefinition;

public class TaskCreateListener
implements TaskListener {
    private static final long serialVersionUID = 1L;
    private ActivitiPropertyConverter propertyConverter;

    public void notify(DelegateTask task) {
        this.propertyConverter.setDefaultTaskProperties(task);
        String taskFormKey = this.getFormKey(task);
        TypeDefinition typeDefinition = this.propertyConverter.getWorkflowObjectFactory().getTaskTypeDefinition(taskFormKey, false);
        taskFormKey = typeDefinition.getName().toPrefixString();
        task.setVariableLocal("taskFormKey", (Object)taskFormKey);
        ActivitiScriptNode initiatorNode = (ActivitiScriptNode)task.getExecution().getVariable("initiator");
        if (initiatorNode != null) {
            task.addUserIdentityLink((String)initiatorNode.getProperties().get(ContentModel.PROP_USERNAME.toPrefixString()), "starter");
        }
    }

    private String getFormKey(DelegateTask task) {
        TaskFormData formData = null;
        TaskEntity taskEntity = (TaskEntity)task;
        TaskFormHandler taskFormHandler = taskEntity.getTaskDefinition().getTaskFormHandler();
        if (taskFormHandler != null && (formData = taskFormHandler.createTaskForm(taskEntity)) != null) {
            return formData.getFormKey();
        }
        return null;
    }

    public void setPropertyConverter(ActivitiPropertyConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }
}

