/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.processor.FieldProcessor;
import org.alfresco.repo.forms.processor.FieldProcessorRegistry;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.QNameFieldProcessor;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultFieldBuilder {
    private static final String ASSOC_WARN = "Could not build Association Field as no valid FieldProcessor was specified";
    private static final String PROP_WARNING = "Could not build Property Field as no valid FieldProcessor was specified";
    private static final Log MY_LOGGER = LogFactory.getLog(DefaultFieldBuilder.class);
    private final FormCreationData formData;
    private final ContentModelItemData<?> ItemData;
    private final FieldProcessorRegistry registry;
    private final NamespaceService namespaceService;
    private final List<String> ignoredFields;
    private final Log logger;

    public DefaultFieldBuilder(FormCreationData data, FieldProcessorRegistry registry, NamespaceService namespaceService, List<String> ignoredFields) {
        this(data, registry, namespaceService, ignoredFields, MY_LOGGER);
    }

    public DefaultFieldBuilder(FormCreationData formData, FieldProcessorRegistry registry, NamespaceService namespaceService, List<String> ignoredFields, Log logger) {
        this.logger = logger;
        this.formData = formData;
        this.registry = registry;
        this.namespaceService = namespaceService;
        this.ignoredFields = this.getNonNullList(ignoredFields);
        this.ItemData = (ContentModelItemData)formData.getItemData();
    }

    private <T> List<T> getNonNullList(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public List<Field> buildDefaultFields() {
        List<Field> assocFields = this.buildDefaultAssociationFields();
        List<Field> propFields = this.buildDefaultPropertyFields();
        List<Field> transFields = this.buildDefaultTransientFields();
        int size = assocFields.size() + propFields.size() + transFields.size();
        ArrayList<Field> fields = new ArrayList<Field>(size);
        fields.addAll(assocFields);
        fields.addAll(propFields);
        fields.addAll(transFields);
        return fields;
    }

    public List<Field> buildDefaultPropertyFields() {
        Collection<QName> names = this.ItemData.getAllPropertyDefinitionNames();
        ArrayList<Field> fields = new ArrayList<Field>(names.size());
        for (QName name : names) {
            if (this.ignoreQName(name)) continue;
            fields.add(this.buildPropertyField(name));
        }
        return fields;
    }

    private boolean ignoreQName(QName qname) {
        String name = qname.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        return this.ignoredFields.contains(name);
    }

    public List<Field> buildDefaultAssociationFields() {
        Collection<QName> names = this.ItemData.getAllAssociationDefinitionNames();
        ArrayList<Field> fields = new ArrayList<Field>(names.size());
        for (QName name : names) {
            if (this.ignoreQName(name)) continue;
            fields.add(this.buildAssociationField(name));
        }
        return fields;
    }

    public List<Field> buildDefaultTransientFields() {
        Collection<String> names = this.ItemData.getAllTransientFieldNames();
        ArrayList<Field> fields = new ArrayList<Field>(names.size());
        for (String name : names) {
            if (this.ignoredFields.contains(name)) continue;
            fields.add(this.buildTransientField(name));
        }
        return fields;
    }

    public Field buildAssociationField(QName assocName) {
        return this.buildQNameField(assocName, "assoc", ASSOC_WARN);
    }

    public Field buildPropertyField(QName propName) {
        return this.buildQNameField(propName, "prop", PROP_WARNING);
    }

    private Field buildQNameField(QName assocName, String key, String warningMsg) {
        FieldProcessor fieldProcessor = this.registry.get(key);
        if (fieldProcessor != null && fieldProcessor instanceof QNameFieldProcessor) {
            QNameFieldProcessor qnameProcessor = (QNameFieldProcessor)fieldProcessor;
            return qnameProcessor.generateField(assocName, this.ItemData, false);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)warningMsg);
        }
        return null;
    }

    public Field buildTransientField(String name) {
        FieldProcessor fieldProcessor = this.registry.get(name);
        if (fieldProcessor != null) {
            return fieldProcessor.generateField(name, this.formData);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not build Transient Field: " + name + " as no FieldProcessor specified"));
        }
        return null;
    }
}

