/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import org.alfresco.repo.lock.LockUtils;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LockUtilsTest {
    @Mock
    private LockService lockService;
    private final NodeRef nodeRef = new NodeRef("workspace://SpacesStore/node-id");

    @Test
    public void testIsLockedAndReadOnly_ForLockOwnerWithNullLockType() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCK_OWNER);
        Mockito.lenient().when((Object)this.lockService.getLockType(this.nodeRef)).thenReturn(null);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)true);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)true, (Object)returnedVal);
    }

    @Test
    public void testIsLockedAndReadOnly_ForLockOwnerWithWriteLockType() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCK_OWNER);
        Mockito.lenient().when((Object)this.lockService.getLockType(this.nodeRef)).thenReturn((Object)LockType.WRITE_LOCK);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)false);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)false, (Object)returnedVal);
    }

    @Test
    public void testIsLockedAndReadOnly_ForLockOwnerWithNodeLockType() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCK_OWNER);
        Mockito.lenient().when((Object)this.lockService.getLockType(this.nodeRef)).thenReturn((Object)LockType.NODE_LOCK);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)true);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)true, (Object)returnedVal);
    }

    @Test
    public void testIsLockedAndReadOnly_ForLockOwnerWithReadOnlyLockType() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCK_OWNER);
        Mockito.lenient().when((Object)this.lockService.getLockType(this.nodeRef)).thenReturn((Object)LockType.READ_ONLY_LOCK);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)true);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)true, (Object)returnedVal);
    }

    @Test
    public void testIsLockedAndReadOnly_ForNoLock() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.NO_LOCK);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)false);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)false, (Object)returnedVal);
    }

    @Test
    public void testIsLockedAndReadOnly_ForExpiredLock() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCK_EXPIRED);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)false);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)false, (Object)returnedVal);
    }

    @Test
    public void testIsLockedAndReadOnly_ForLock() {
        Mockito.lenient().when((Object)this.lockService.getLockStatus(this.nodeRef)).thenReturn((Object)LockStatus.LOCKED);
        Mockito.when((Object)this.lockService.isLockedAndReadOnly(this.nodeRef)).thenReturn((Object)true);
        boolean returnedVal = LockUtils.isLockedAndReadOnly((NodeRef)this.nodeRef, (LockService)this.lockService);
        Assert.assertEquals((Object)true, (Object)returnedVal);
    }
}

