/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluatorAbstractBase;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;

public class HasVersionHistoryEvaluator
extends ActionConditionEvaluatorAbstractBase {
    public static final String NAME = "has-version-history";
    private NodeService nodeService;
    private VersionService versionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    @Override
    public boolean evaluateImpl(ActionCondition ruleCondition, NodeRef actionedUponNodeRef) {
        VersionHistory versionHistory;
        boolean result = false;
        if (this.nodeService.exists(actionedUponNodeRef) && this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE) && (versionHistory = this.versionService.getVersionHistory(actionedUponNodeRef)) != null && versionHistory.getAllVersions().size() != 0) {
            result = true;
        }
        return result;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

