/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluatorAbstractBase;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class HasChildEvaluator
extends ActionConditionEvaluatorAbstractBase {
    public static final String NAME = "has-child";
    public static final String PARAM_ASSOC_TYPE = "assoc-type";
    public static final String PARAM_ASSOC_NAME = "assoc-name";
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public boolean evaluateImpl(ActionCondition ruleCondition, NodeRef actionedUponNodeRef) {
        boolean result = false;
        if (this.nodeService.exists(actionedUponNodeRef)) {
            QNamePattern matchAll = RegexQNamePattern.MATCH_ALL;
            QName assocTypeParam = (QName)ruleCondition.getParameterValue(PARAM_ASSOC_TYPE);
            QName assocNameParam = (QName)ruleCondition.getParameterValue(PARAM_ASSOC_NAME);
            QNamePattern assocType = assocTypeParam == null ? matchAll : assocTypeParam;
            QNamePattern assocName = assocNameParam == null ? matchAll : assocNameParam;
            List children = this.nodeService.getChildAssocs(actionedUponNodeRef, assocType, assocName);
            result = !children.isEmpty();
        }
        return result;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_ASSOC_TYPE, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_ASSOC_TYPE), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_ASSOC_NAME, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_ASSOC_NAME), false));
    }
}

