/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.filter;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.repo.event2.filter.EventFilter;

public class EventUserFilter
implements EventFilter<String> {
    private Set<String> filteredUsers;
    private boolean userNamesAreCaseSensitive;

    public EventUserFilter(String filteredUsersStr, boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
        this.filteredUsers = this.parseFilterList(filteredUsersStr);
    }

    private Set<String> parseFilterList(String str) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken().trim();
            if (entry.isEmpty()) continue;
            set.add(this.userNamesAreCaseSensitive ? entry : entry.toLowerCase());
        }
        return set;
    }

    @Override
    public boolean isExcluded(String user) {
        if (user == null) {
            user = "null";
        }
        return this.filteredUsers.contains(this.userNamesAreCaseSensitive ? user : user.toLowerCase());
    }
}

