/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class EventGeneratorTest
extends AbstractContextAwareRepoEvent {
    private static final String EVENT2_TOPIC_NAME = "alfresco.repo.event2";
    private static final long DUMP_BROKER_TIMEOUT = 50000000L;
    private ActiveMQConnection connection;
    protected List<RepoEvent<?>> receivedEvents;

    @Before
    public void startupTopicListener() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Topic destination = session.createTopic(EVENT2_TOPIC_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.receivedEvents = Collections.synchronizedList(new LinkedList());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                String text = EventGeneratorTest.getText(message);
                RepoEvent<?> event = this.toRepoEvent(text);
                EventGeneratorTest.this.receivedEvents.add(event);
            }

            private RepoEvent<?> toRepoEvent(String json) {
                try {
                    return (RepoEvent)EventGeneratorTest.this.objectMapper.readValue(json, RepoEvent.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    @After
    public void shutdownTopicListener() throws Exception {
        this.connection.close();
        this.connection = null;
    }

    @Test
    public void shouldReceiveEvent2EventsOnNodeCreation() {
        this.createNode(ContentModel.TYPE_CONTENT);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> this.receivedEvents.size() == 1);
        EventGeneratorTest.assertEquals((int)1, (int)AbstractContextAwareRepoEvent.EVENT_CONTAINER.getEvents().size());
        EventGeneratorTest.assertEquals((int)1, (int)this.receivedEvents.size());
        RepoEvent sent = this.getRepoEvent(1);
        RepoEvent<?> received = this.receivedEvents.get(0);
        this.assertEventsEquals("Events are different!", sent, received);
    }

    @Test
    public void shouldReceiveEvent2EventsInOrder() {
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.updateNodeName(nodeRef, "TestFile-" + System.currentTimeMillis() + ".txt");
        this.deleteNode(nodeRef);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> this.receivedEvents.size() == 3);
        RepoEvent sentCreation = this.getRepoEvent(1);
        RepoEvent sentUpdate = this.getRepoEvent(2);
        RepoEvent sentDeletion = this.getRepoEvent(3);
        EventGeneratorTest.assertEquals((String)"Expected create event!", sentCreation, this.receivedEvents.get(0));
        EventGeneratorTest.assertEquals((String)"Expected update event!", sentUpdate, this.receivedEvents.get(1));
        EventGeneratorTest.assertEquals((String)"Expected delete event!", sentDeletion, this.receivedEvents.get(2));
    }

    private void assertEventsEquals(String message, RepoEvent<?> expected, RepoEvent<?> current) {
        EventGeneratorTest.assertEquals((String)message, expected, current);
    }

    private static String getText(Message message) {
        try {
            ActiveMQTextMessage am = (ActiveMQTextMessage)message;
            return am.getText();
        }
        catch (JMSException jMSException) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        EventGeneratorTest.dumpBroker("tcp://localhost:61616", 50000000L);
        System.exit(0);
    }

    private static void dumpBroker(String url, long timeout) throws Exception {
        System.out.println("Broker at url: '" + url + "'");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(url);
        try (ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();){
            connection.start();
            DestinationSource ds = connection.getDestinationSource();
            Set queues = ds.getQueues();
            System.out.println("\nFound " + queues.size() + " queues:");
            for (ActiveMQQueue queue : queues) {
                try {
                    System.out.println("- " + queue.getQueueName());
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            Set topics = ds.getTopics();
            System.out.println("\nFound " + topics.size() + " topics:");
            for (ActiveMQTopic topic : topics) {
                try {
                    System.out.println("- " + topic.getTopicName());
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(EVENT2_TOPIC_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            System.out.println("\nListening to topic alfresco.repo.event2...");
            consumer.setMessageListener(message -> {
                String text = EventGeneratorTest.getText(message);
                System.out.println("Received message " + String.valueOf(message) + "\n" + text + "\n");
            });
            Thread.sleep(timeout);
        }
    }
}

