/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.audit.AuditRecord;
import org.alfresco.service.cmr.repository.NodeRef;

public final class AuditRecordUtils {
    private AuditRecordUtils() {
    }

    public static AuditRecord.Builder generateAuditRecordBuilder(Map<String, Serializable> data, int keyRootLength) {
        AuditRecord.Builder auditRecordBuilder = AuditRecord.builder();
        HashMap<String, Serializable> rootNode = AuditRecordUtils.createRootNode(data, keyRootLength);
        auditRecordBuilder.setAuditRecordData(rootNode);
        return auditRecordBuilder;
    }

    private static HashMap<String, Serializable> createRootNode(Map<String, Serializable> data, int keyRootLength) {
        HashMap<String, Serializable> rootNode = new HashMap<String, Serializable>();
        data.forEach((k, v) -> {
            String[] keys = k.substring(keyRootLength).split("/");
            HashMap current = rootNode;
            int i = 0;
            while (i < keys.length - 1) {
                current = (HashMap)current.computeIfAbsent(keys[i], newMap -> new HashMap());
                ++i;
            }
            current.put(keys[keys.length - 1], AuditRecordUtils.decodeValueByInstance(v));
        });
        return rootNode;
    }

    private static Serializable decodeValueByInstance(Serializable value) {
        if (value instanceof HashMap) {
            return AuditRecordUtils.createRootNode((HashMap)value, 0);
        }
        if (value instanceof NodeRef) {
            return ((NodeRef)value).getId();
        }
        return value;
    }
}

