/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.processor.AbstractFilter;
import org.alfresco.repo.workflow.PropertyValueSizeIsMoreMaxLengthException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class WorkflowFormFilter<ItemType, PersistType>
extends AbstractFilter<ItemType, PersistType>
implements InitializingBean {
    private static final String PROP_BPM_COMMENT = "prop_bpm_comment";
    private int maxLengthBpmCommentProperty = 4000;
    private int maxLengthBpmCommentProperty_oldPropertyName = -1;
    private static final Log LOGGER = LogFactory.getLog(WorkflowFormFilter.class);

    public void setMaxLengthBpmCommentProperty(int maxLengthBpmCommentProperty) {
        this.maxLengthBpmCommentProperty = maxLengthBpmCommentProperty;
    }

    public void setMaxLengthBpmCommentProperty_oldPropertyName(int maxLengthBpmCommentProperty_oldPropertyName) {
        this.maxLengthBpmCommentProperty_oldPropertyName = maxLengthBpmCommentProperty_oldPropertyName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.maxLengthBpmCommentProperty_oldPropertyName != -1) {
            LOGGER.warn((Object)"Config property system.workflow.jbpm.comment.property.max.length is deprecated. Please use system.workflow.comment.property.max.length instead.");
            this.maxLengthBpmCommentProperty = this.maxLengthBpmCommentProperty_oldPropertyName;
        }
    }

    @Override
    public void beforeGenerate(ItemType item, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
    }

    @Override
    public void afterGenerate(ItemType item, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
    }

    @Override
    public void beforePersist(ItemType item, FormData data) {
        int value;
        FormData.FieldData bpmComment = data.getFieldData(PROP_BPM_COMMENT);
        if (bpmComment != null && this.maxLengthBpmCommentProperty < (value = ((String)bpmComment.getValue()).getBytes().length)) {
            throw new PropertyValueSizeIsMoreMaxLengthException(PROP_BPM_COMMENT);
        }
    }

    @Override
    public void afterPersist(ItemType item, FormData data, PersistType persistedObject) {
    }
}

