/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.Collection;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.service.StoreRedirectorProxyFactory;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class IndexerComponent
extends AbstractLifecycleBean
implements Indexer {
    private StoreRedirectorProxyFactory<IndexerAndSearcher> storeRedirectorProxyFactory;
    private IndexerAndSearcher indexerAndSearcherFactory;
    private static final String KEY_READ_THROUGH = IndexerComponent.class.getName() + "READ_THROUGH";

    public void setStoreRedirectorProxyFactory(StoreRedirectorProxyFactory<IndexerAndSearcher> storeRedirectorProxyFactory) {
        this.storeRedirectorProxyFactory = storeRedirectorProxyFactory;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.indexerAndSearcherFactory = this.storeRedirectorProxyFactory.getObject();
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void setIndexerAndSearcherFactory(IndexerAndSearcher indexerAndSearcherFactory) {
        this.indexerAndSearcherFactory = indexerAndSearcherFactory;
    }

    @Override
    public void setReadThrough(boolean isReadThrough) {
        if (isReadThrough) {
            AlfrescoTransactionSupport.bindResource((Object)KEY_READ_THROUGH, (Object)Boolean.TRUE);
        } else {
            AlfrescoTransactionSupport.unbindResource((Object)KEY_READ_THROUGH);
        }
    }

    private Indexer getIndexer(StoreRef storeRef) {
        Indexer indexer = this.indexerAndSearcherFactory.getIndexer(storeRef);
        indexer.setReadThrough(AlfrescoTransactionSupport.getResource((Object)KEY_READ_THROUGH) == Boolean.TRUE);
        return indexer;
    }

    @Override
    public void createNode(ChildAssociationRef relationshipRef) {
        Indexer indexer = this.getIndexer(relationshipRef.getChildRef().getStoreRef());
        indexer.createNode(relationshipRef);
    }

    @Override
    public void updateNode(NodeRef nodeRef) {
        Indexer indexer = this.getIndexer(nodeRef.getStoreRef());
        indexer.updateNode(nodeRef);
    }

    @Override
    public void deleteNode(ChildAssociationRef relationshipRef) {
        Indexer indexer = this.getIndexer(relationshipRef.getChildRef().getStoreRef());
        indexer.deleteNode(relationshipRef);
    }

    @Override
    public void createChildRelationship(ChildAssociationRef relationshipRef) {
        Indexer indexer = this.getIndexer(relationshipRef.getChildRef().getStoreRef());
        indexer.createChildRelationship(relationshipRef);
    }

    @Override
    public void updateChildRelationship(ChildAssociationRef relationshipBeforeRef, ChildAssociationRef relationshipAfterRef) {
        Indexer indexer = this.getIndexer(relationshipBeforeRef.getChildRef().getStoreRef());
        indexer.updateChildRelationship(relationshipBeforeRef, relationshipAfterRef);
    }

    @Override
    public void deleteChildRelationship(ChildAssociationRef relationshipRef) {
        Indexer indexer = this.getIndexer(relationshipRef.getChildRef().getStoreRef());
        indexer.deleteChildRelationship(relationshipRef);
    }

    @Override
    public void detectNodeChanges(NodeRef nodeRef, SearchService searcher, Collection<ChildAssociationRef> addedParents, Collection<ChildAssociationRef> deletedParents, Collection<ChildAssociationRef> createdNodes, Collection<NodeRef> updatedNodes) {
        Indexer indexer = this.getIndexer(nodeRef.getStoreRef());
        indexer.detectNodeChanges(nodeRef, searcher, addedParents, deletedParents, createdNodes, updatedNodes);
    }

    @Override
    public void deleteIndex(StoreRef storeRef) {
        Indexer indexer = this.getIndexer(storeRef);
        indexer.deleteIndex(storeRef);
    }

    @Override
    public void flushPending() {
        this.indexerAndSearcherFactory.flush();
    }
}

