/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Table;

public class Column
extends AbstractDbObject {
    private String type;
    private boolean nullable;
    private boolean autoIncrement;
    private int order;
    private boolean compareOrder = true;

    public Column(String name) {
        super(null, name);
    }

    public Column(Table table, String name, String type, boolean nullable) {
        super(table, name);
        this.type = type;
        this.nullable = nullable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isCompareOrder() {
        return this.compareOrder;
    }

    public void setCompareOrder(boolean compareOrder) {
        this.compareOrder = compareOrder;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.autoIncrement ? 1231 : 1237);
        result = 31 * result + (this.compareOrder ? 1231 : 1237);
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + this.order;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.autoIncrement != other.autoIncrement) {
            return false;
        }
        if (this.compareOrder != other.compareOrder) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    protected void doDiff(DbObject right, DiffContext ctx) {
        DbProperty thisTypeProp = new DbProperty(this, "type");
        DbProperty thisNullableProp = new DbProperty(this, "nullable");
        DbProperty thisOrderProp = new DbProperty(this, "order");
        DbProperty thisAutoIncProp = new DbProperty(this, "autoIncrement");
        Column thatColumn = (Column)right;
        DbProperty thatTypeProp = new DbProperty(thatColumn, "type");
        DbProperty thatNullableProp = new DbProperty(thatColumn, "nullable");
        DbProperty thatOrderProp = new DbProperty(thatColumn, "order");
        DbProperty thatAutoIncProp = new DbProperty(thatColumn, "autoIncrement");
        this.comparisonUtils.compareSimple(thisTypeProp, thatTypeProp, ctx);
        this.comparisonUtils.compareSimple(thisNullableProp, thatNullableProp, ctx);
        if (this.compareOrder) {
            this.comparisonUtils.compareSimple(thisOrderProp, thatOrderProp, ctx);
        }
        this.comparisonUtils.compareSimple(thisAutoIncProp, thatAutoIncProp, ctx);
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
    }
}

