/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.Collections;
import java.util.Set;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterUtils;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ACLEntryVoterUtilsTest {
    private final NodeRef testNodeRef = new NodeRef("workspace://testNodeRef/testNodeRef");
    private final NodeRef rootNodeRef = new NodeRef("workspace://rootNodeRef/rootNodeRef");
    private final NodeRef refNodeForTestObject = new NodeRef("workspace://refNodeForTestObject/refNodeForTestObject");
    private final NodeRef childRefNode = new NodeRef("workspace://childRefNode/childRefNode");
    private final StoreRef testStoreNodeRef = new StoreRef("system://testStoreRefMock/testStoreRefMock");
    private final SimplePermissionReference simplePermissionReference = SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"uri", (String)"local"), (String)"Write");
    private final QName qNameToAbstain1 = QName.createQName((String)"{test}testnode1");
    private final QName qNameToAbstain2 = QName.createQName((String)"{test}testnode2");
    private final QName qNameToAbstain3 = QName.createQName((String)"{test}testnode3");
    private final QName qNameNotFromTheAbstainSet = QName.createQName((String)"{test}testnodeAbstain");
    private final Set<QName> qNamesToAbstain = Set.of(this.qNameToAbstain1, this.qNameToAbstain2, this.qNameToAbstain3);
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private ChildAssociationRef childAssocRefMock;

    @Before
    public void setUp() {
        Mockito.when((Object)this.nodeServiceMock.exists(this.testStoreNodeRef)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.nodeServiceMock.exists(this.testNodeRef)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.nodeServiceMock.getRootNode(this.testStoreNodeRef)).thenReturn((Object)this.rootNodeRef);
        Mockito.when((Object)this.nodeServiceMock.getType(this.testNodeRef)).thenReturn((Object)this.qNameNotFromTheAbstainSet);
        Mockito.when((Object)this.nodeServiceMock.getAspects(this.testNodeRef)).thenReturn(Set.of(this.qNameNotFromTheAbstainSet));
        Mockito.when((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.eq((Object)this.testNodeRef), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)AccessStatus.DENIED);
    }

    @Test
    public void returnsAccessDeniedFromPermissionService() {
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, (NodeRef)this.testNodeRef, this.qNamesToAbstain, (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void returnsNullOnNullTestObject() {
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.getNodeRef(null, (NodeService)this.nodeServiceMock), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test(expected=ACLEntryVoterException.class)
    public void throwsExceptionWhenParameterIsNotNodeRefOrChildAssociationRef() {
        ACLEntryVoterUtils.getNodeRef((Object)"TEST", (NodeService)this.nodeServiceMock);
    }

    @Test
    public void returnsGivenTestNodeRefWhenStoreRefDoesNotExist() {
        Mockito.when((Object)this.nodeServiceMock.exists(this.testStoreNodeRef)).thenReturn((Object)Boolean.FALSE);
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.getNodeRef((Object)this.testStoreNodeRef, (NodeService)this.nodeServiceMock), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void returnsRootNode() {
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.getNodeRef((Object)this.testStoreNodeRef, (NodeService)this.nodeServiceMock), (Matcher)CoreMatchers.is((Object)this.rootNodeRef));
    }

    @Test
    public void returnsNodeRefFromTestObject() {
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.getNodeRef((Object)this.refNodeForTestObject, (NodeService)this.nodeServiceMock), (Matcher)CoreMatchers.is((Object)this.refNodeForTestObject));
    }

    @Test
    public void returnsChildRefFromChildAssocRef() {
        Mockito.when((Object)this.childAssocRefMock.getChildRef()).thenReturn((Object)this.childRefNode);
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.getNodeRef((Object)this.childAssocRefMock, (NodeService)this.nodeServiceMock), (Matcher)CoreMatchers.is((Object)this.childRefNode));
    }

    @Test
    public void returnsNullOnNullTestNodeRef() {
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, null, this.qNamesToAbstain, (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void returnsNullOnAbstainClassQnamesIsEmptyAndThereAreNoDeniedPermissions() {
        Mockito.when((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.eq((Object)this.testNodeRef), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)AccessStatus.ALLOWED);
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, (NodeRef)this.testNodeRef, Collections.emptySet(), (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void returnsNullOnTestNodeRefDoesNotExistAndThereAreNoDeniedPermissions() {
        Mockito.when((Object)this.nodeServiceMock.exists(this.testNodeRef)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.eq((Object)this.testNodeRef), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)AccessStatus.ALLOWED);
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, (NodeRef)this.testNodeRef, this.qNamesToAbstain, (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void returnsNullOnNodeTypeAndNodeAspectsAreNotInSetToAbstainAndThereAreNoDeniedPermissions() {
        Mockito.when((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.eq((Object)this.testNodeRef), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)AccessStatus.ALLOWED);
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, (NodeRef)this.testNodeRef, this.qNamesToAbstain, (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void returnsAbstainWhenNodeRefTypeIsInSetToAbstain() {
        Mockito.when((Object)this.nodeServiceMock.getType(this.testNodeRef)).thenReturn((Object)this.qNameToAbstain2);
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, (NodeRef)this.testNodeRef, this.qNamesToAbstain, (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void returnsAbstainWhenAtLeastOneAspectIsInSetToAbstain() {
        Mockito.when((Object)this.nodeServiceMock.getAspects(this.testNodeRef)).thenReturn(Set.of(this.qNameNotFromTheAbstainSet, this.qNameToAbstain3));
        MatcherAssert.assertThat((Object)ACLEntryVoterUtils.shouldAbstainOrDeny((SimplePermissionReference)this.simplePermissionReference, (NodeRef)this.testNodeRef, this.qNamesToAbstain, (NodeService)this.nodeServiceMock, (PermissionService)this.permissionServiceMock), (Matcher)CoreMatchers.is((Object)0));
    }
}

