/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rawevents;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.alfresco.repo.rawevents.AbstractEventProducer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.camel.ExchangePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionAwareEventProducer
extends AbstractEventProducer {
    private static Log logger = LogFactory.getLog(TransactionAwareEventProducer.class);
    private static final String POST_TRANSACTION_PENDING_REQUESTS = "postTransactionPendingEventRequests";

    @Override
    public void send(String endpointUri, Object event) {
        this.send(endpointUri, null, event, null);
    }

    @Override
    public void send(String endpointUri, Object event, Map<String, Object> headers) {
        this.send(endpointUri, null, event, headers);
    }

    @Override
    public void send(String endpointUri, ExchangePattern exchangePattern, Object event, Map<String, Object> headers) {
        String currentTxn = AlfrescoTransactionSupport.getTransactionId();
        TransactionListener transactionListener = new TransactionListener("TxEvPr" + currentTxn);
        AlfrescoTransactionSupport.bindListener(transactionListener);
        LinkedList<PendingRequest> pendingRequests = (LinkedList<PendingRequest>)AlfrescoTransactionSupport.getResource((Object)POST_TRANSACTION_PENDING_REQUESTS);
        if (pendingRequests == null) {
            pendingRequests = new LinkedList<PendingRequest>();
            AlfrescoTransactionSupport.bindResource((Object)POST_TRANSACTION_PENDING_REQUESTS, pendingRequests);
        }
        PendingRequest pendingRequest = new PendingRequest(endpointUri, exchangePattern, event, headers);
        pendingRequests.add(pendingRequest);
    }

    private class PendingRequest {
        private String endpointUri;
        private Object event;
        private Map<String, Object> headers;
        private ExchangePattern exchangePattern;

        private PendingRequest(String endpointUri, ExchangePattern exchangePattern, Object event, Map<String, Object> headers) {
            this.endpointUri = endpointUri;
            this.event = event;
            this.headers = headers;
            this.exchangePattern = exchangePattern;
        }

        void send() {
            TransactionAwareEventProducer.super.send(this.endpointUri, this.exchangePattern, this.event, this.headers);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PendingRequest)) {
                return false;
            }
            PendingRequest that = (PendingRequest)object;
            return Objects.equals(this.endpointUri, that.endpointUri) && Objects.equals(this.event, that.event) && Objects.equals(this.headers, that.headers);
        }

        public int hashCode() {
            return Objects.hash(this.endpointUri, this.event, this.headers);
        }
    }

    private class TransactionListener
    extends TransactionListenerAdapter
    implements org.alfresco.repo.transaction.TransactionListener {
        private final String id;

        TransactionListener(String uniqueId) {
            this.id = uniqueId;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created lister with id = " + this.id));
            }
        }

        @Override
        public void afterCommit() {
            for (PendingRequest pendingRequest : (List)AlfrescoTransactionSupport.getResource((Object)TransactionAwareEventProducer.POST_TRANSACTION_PENDING_REQUESTS)) {
                try {
                    pendingRequest.send();
                }
                catch (Exception e) {
                    logger.error((Object)("The after commit callback " + this.id + " failed to execute: " + e.getMessage()), (Throwable)e);
                }
            }
        }

        @Override
        public void flush() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionListener)) {
                return false;
            }
            TransactionListener that = (TransactionListener)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

