/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.IOException;
import org.alfresco.repo.content.filestore.FileContentStoreTest;
import org.alfresco.repo.content.filestore.FileContentUrlProvider;
import org.alfresco.repo.content.filestore.VolumeAwareContentUrlProvider;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class, NeverRunsTests.class})
public class VolumeAwareFileContentStoreTest
extends FileContentStoreTest {
    private static final String VOLUMES = "volumeA,volumeB,volumeC";

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        VolumeAwareContentUrlProvider volumeAwareContentUrlProvider = new VolumeAwareContentUrlProvider(VOLUMES);
        this.store.setFileContentUrlProvider((FileContentUrlProvider)volumeAwareContentUrlProvider);
    }

    @Test
    public void testVolumeCreation() throws IOException {
        String[] folders;
        int volumesNumber = VOLUMES.split(",").length;
        int i = 0;
        while (i < volumesNumber * 5) {
            this.store.createNewFile();
            ++i;
        }
        File root = new File(this.store.getRootLocation());
        String[] stringArray = folders = root.list();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Assert.assertTrue((String)"Unknown volume", (boolean)VOLUMES.contains(file));
            ++n2;
        }
        Assert.assertTrue((String)"Not all configured volumes were created", (folders.length == volumesNumber ? 1 : 0) != 0);
    }
}

