/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.naming.CompositeName;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.propval.AbstractPropertyValueDAOImpl;
import org.alfresco.repo.domain.propval.PropValGenerator;
import org.alfresco.repo.domain.propval.PropertyUniqueConstraintViolation;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class PropertyValueDAOTest {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private PropertyValueDAO propertyValueDAO;

    @Before
    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMaxRetries(0);
        this.propertyValueDAO = (PropertyValueDAO)this.ctx.getBean("propertyValueDAO");
        this.removeCaches();
    }

    private void removeCaches() {
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyClassCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyDateValueCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyDoubleValueCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyStringValueCache(null);
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyValueCache(null);
    }

    @Test
    public void testPropertyClass() throws Exception {
        final Class<?> clazz = this.getClass();
        RetryingTransactionHelper.RetryingTransactionCallback createClassCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Class<?>>>(){

            public Pair<Long, Class<?>> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyClass(clazz);
            }
        };
        final Pair clazzEntityPair = (Pair)this.txnHelper.doInTransaction(createClassCallback, false);
        Assert.assertNotNull((Object)clazzEntityPair);
        Assert.assertNotNull((Object)clazzEntityPair.getFirst());
        Assert.assertEquals(clazz, (Object)clazzEntityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> getClassCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Pair checkPair1 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyClassById((Long)clazzEntityPair.getFirst());
                Assert.assertEquals((Object)clazzEntityPair, (Object)checkPair1);
                Pair checkPair2 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyClass((Class)clazzEntityPair.getSecond());
                Assert.assertEquals((Object)clazzEntityPair, (Object)checkPair2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getClassCallback, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> badGetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.getPropertyClassById(Long.valueOf(Long.MIN_VALUE));
                return null;
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)badGetCallback, false);
            Assert.fail((String)"Expected exception when using invalid ID.");
        }
        catch (RuntimeException runtimeException) {}
        RetryingTransactionHelper.RetryingTransactionCallback<Void> noHitCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.getPropertyClass(this.getClass());
                PropertyValueDAOTest.this.propertyValueDAO.getPropertyClass(this.getClass());
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)noHitCallback, false);
    }

    @Test
    public void testPropertyDateValue() throws Exception {
        final Date dateValue = ISO8601DateFormat.parse((String)"1936-08-04T23:37:25.793Z");
        Date dateValueBack = ISO8601DateFormat.parse((String)"1936-08-04T00:00:00.000Z");
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>>(){

            public Pair<Long, Date> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyDateValue(dateValue);
            }
        };
        Pair entityPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createValueCallback, false);
        Assert.assertNotNull((Object)entityPair);
        Assert.assertEquals((Object)dateValueBack, (Object)entityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Date>>(){

            public Pair<Long, Date> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyDateValue(dateValue);
            }
        };
        Pair entityPairCheck = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getValueCallback, false);
        Assert.assertNotNull((Object)entityPairCheck);
        Assert.assertEquals((Object)entityPair, (Object)entityPairCheck);
    }

    @Test
    public void testPropertyStringValue() throws Exception {
        final String stringValue = "One Two Three - \u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1 - " + System.currentTimeMillis();
        final String stringValueUpper = stringValue.toUpperCase();
        final String stringValueLower = stringValue.toLowerCase();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> createStringCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue(stringValue);
            }
        };
        Pair stringEntityPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createStringCallback, false);
        Assert.assertNotNull((Object)stringEntityPair);
        Assert.assertNotNull((Object)stringEntityPair.getFirst());
        Assert.assertEquals((Object)stringValue, (Object)stringEntityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> getStringCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Pair checkPair1 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValue);
                Assert.assertNotNull((Object)checkPair1);
                Assert.assertEquals((Object)stringValue, (Object)checkPair1.getSecond());
                Pair checkPair2 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValueUpper);
                Assert.assertNull((Object)checkPair2);
                Pair checkPair3 = PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValueLower);
                Assert.assertNull((Object)checkPair3);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getStringCallback, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> createStringUpperCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue(stringValueUpper);
            }
        };
        Pair stringUpperEntityPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createStringUpperCallback, false);
        Assert.assertNotNull((Object)stringUpperEntityPair);
        Assert.assertNotNull((Object)stringUpperEntityPair.getFirst());
        Assert.assertEquals((Object)stringValueUpper, (Object)stringUpperEntityPair.getSecond());
        Assert.assertNotSame((String)"String IDs were not different", (Object)stringEntityPair.getFirst(), (Object)stringUpperEntityPair.getFirst());
    }

    @Test
    public void testPropertyStringValue_EmptyAndNull() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> emptyStringCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Pair emptyStringPair1 = PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue("");
                Assert.assertNotNull((Object)emptyStringPair1);
                Assert.assertEquals((Object)"", (Object)emptyStringPair1.getSecond());
                Pair emptyStringPair2 = PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue("");
                Assert.assertNotNull((Object)emptyStringPair2);
                Assert.assertEquals((Object)emptyStringPair1, (Object)emptyStringPair2);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)emptyStringCallback, false);
    }

    @Test
    public void testPropertyDoubleValue() throws Exception {
        final Double doubleValue = 1.7976931348623E125;
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>>(){

            public Pair<Long, Double> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyDoubleValue(doubleValue);
            }
        };
        Pair entityPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createValueCallback, false);
        Assert.assertNotNull((Object)entityPair);
        Assert.assertEquals((Object)doubleValue, (Object)entityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Double>>(){

            public Pair<Long, Double> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyDoubleValue(doubleValue);
            }
        };
        Pair entityPairCheck = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getValueCallback, false);
        Assert.assertNotNull((Object)entityPairCheck);
        Assert.assertEquals((Object)entityPair, (Object)entityPairCheck);
    }

    @Test
    public void testPropertySerializableValue() throws Exception {
        final CompositeName serializableValue = new CompositeName("123");
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.createPropertySerializableValue(serializableValue);
            }
        };
        final Pair entityPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createValueCallback, false);
        Assert.assertNotNull((Object)entityPair);
        Assert.assertEquals((Object)serializableValue, (Object)entityPair.getSecond());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertySerializableValueById((Long)entityPair.getFirst());
            }
        };
        Pair entityPairCheck = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getValueCallback, false);
        Assert.assertNotNull((Object)entityPairCheck);
        Assert.assertEquals((Object)entityPair.getFirst(), (Object)entityPairCheck.getFirst());
        Assert.assertEquals((Object)entityPair, (Object)entityPairCheck);
        final Serializable bytes = (Serializable)new byte[]{1, 2, 3};
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Void>> testBytesCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Void>>(){

            public Pair<Long, Void> execute() throws Throwable {
                Long id = (Long)PropertyValueDAOTest.this.propertyValueDAO.createPropertySerializableValue(bytes).getFirst();
                Serializable check = (Serializable)PropertyValueDAOTest.this.propertyValueDAO.getPropertySerializableValueById(id).getSecond();
                Assert.assertNotNull((Object)check);
                Assert.assertTrue((boolean)(check instanceof byte[]));
                Arrays.equals((byte[])bytes, (byte[])check);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testBytesCallback, false);
    }

    private void runPropertyValueTest(Serializable value) throws Exception {
        this.runPropertyValueTest(value, true);
    }

    private void runPropertyValueTest(final Serializable value, boolean runValueRetrieval) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyValue(value);
            }
        };
        final Pair entityPair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createValueCallback, false);
        Assert.assertNotNull((Object)entityPair);
        Assert.assertEquals((Object)value, (Object)entityPair.getSecond());
        if (runValueRetrieval) {
            RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> getValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

                public Pair<Long, Serializable> execute() throws Throwable {
                    return PropertyValueDAOTest.this.propertyValueDAO.getPropertyValue(value);
                }
            };
            Pair entityPairCheck = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getValueCallback, false);
            Assert.assertNotNull((Object)entityPairCheck);
            Assert.assertEquals((Object)entityPair, (Object)entityPairCheck);
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>> getByIdCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyValueById((Long)entityPair.getFirst());
            }
        };
        Pair entityPairCheck2 = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getByIdCallback, false);
        Assert.assertNotNull((Object)entityPairCheck2);
        Assert.assertEquals((Object)entityPair, (Object)entityPairCheck2);
    }

    @Test
    public void testPropertyValue_EmptyMaps() throws Exception {
        HashMap emptyMap = new HashMap();
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).setPropertyValueCache((SimpleCache)new DefaultSimpleCache());
        Pair cfr_ignored_0 = (Pair)this.txnHelper.doInTransaction(() -> this.propertyValueDAO.getOrCreatePropertyValue((Serializable)new MLText()), false);
        Pair emptyHashMapPair = (Pair)this.txnHelper.doInTransaction(() -> this.propertyValueDAO.getOrCreatePropertyValue((Serializable)emptyMap), false);
        Assert.assertEquals((String)"Incorrect type persisted for an empty HashMap.", HashMap.class, ((Serializable)emptyHashMapPair.getSecond()).getClass());
        Pair emptyHashMapPairRetrievedByValye = (Pair)this.txnHelper.doInTransaction(() -> this.propertyValueDAO.getPropertyValue((Serializable)emptyMap), false);
        Assert.assertEquals((String)"Incorrect type persisted for an empty HashMap.", HashMap.class, ((Serializable)emptyHashMapPairRetrievedByValye.getSecond()).getClass());
        Pair emptyHashMapPairRetrievedByID = (Pair)this.txnHelper.doInTransaction(() -> this.propertyValueDAO.getPropertyValueById((Long)emptyHashMapPair.getFirst()), false);
        Assert.assertEquals((String)"Incorrect type persisted for an empty HashMap.", HashMap.class, ((Serializable)emptyHashMapPairRetrievedByID.getSecond()).getClass());
    }

    @Test
    public void testPropertyValue_Null() throws Exception {
        this.runPropertyValueTest(null);
    }

    @Test
    public void testPropertyValue_Boolean() throws Exception {
        this.runPropertyValueTest(Boolean.TRUE);
        this.runPropertyValueTest(Boolean.FALSE);
    }

    @Test
    public void testPropertyValue_Short() throws Exception {
        short i = 0;
        while (i < 100) {
            this.runPropertyValueTest(Short.valueOf(i));
            i = (short)(i + 1);
        }
    }

    @Test
    public void testPropertyValue_Integer() throws Exception {
        int i = 0;
        while (i < 100) {
            this.runPropertyValueTest(Integer.valueOf(i));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_Long() throws Exception {
        long i = 0L;
        while (i < 100L) {
            this.runPropertyValueTest(Long.valueOf(i));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_Float() throws Exception {
        long i = 0L;
        while (i < 100L) {
            this.runPropertyValueTest(Float.valueOf((float)i + 0.01f));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_Double() throws Exception {
        long i = 0L;
        while (i < 100L) {
            this.runPropertyValueTest(Double.valueOf((double)i + 0.01));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_Date() throws Exception {
        Random rand = new Random();
        long i = 0L;
        while (i < 100L) {
            this.runPropertyValueTest(new Date(rand.nextLong()));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_String() throws Exception {
        long i = 0L;
        while (i < 100L) {
            this.runPropertyValueTest((Serializable)((Object)new String("Value-" + i + ".xyz")));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_Serializable() throws Exception {
        int i = 0;
        while (i < 100) {
            this.runPropertyValueTest(new CompositeName("Name-" + i), false);
            ++i;
        }
    }

    @Test
    public void testPropertyValue_Enum() throws Exception {
        int i = 0;
        while (i < 3) {
            TEST_NUMBERS n = TEST_NUMBERS.values()[i];
            this.runPropertyValueTest((Serializable)((Object)n));
            ++i;
        }
    }

    @Test
    public void testPropertyValue_EmptyHashMap() throws Exception {
        HashMap map = new HashMap(15);
        this.runPropertyValueTest(map, true);
    }

    @Test
    public void testPropertyValue_EmptyArrayList() throws Exception {
        ArrayList list = new ArrayList(20);
        this.runPropertyValueTest(list, true);
    }

    @Test
    public void testPropertyValue_EmptyHashSet() throws Exception {
        HashSet set = new HashSet(20);
        this.runPropertyValueTest(set, true);
    }

    @Test
    public void testPropertyValue_MapOfStrings() throws Exception {
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>(15);
        int i = 0;
        while (i < 20) {
            String key = "MAP-KEY-" + i;
            String value = "MAP-VALUE-" + i;
            map.put((CallSite)((Object)key), (CallSite)((Object)value));
            ++i;
        }
        this.runPropertyValueTest(map, false);
    }

    private Long runPropertyTest(final Serializable value) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> createValueCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.createProperty(value);
            }
        };
        final Long entityId = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createValueCallback, false);
        Assert.assertNotNull((Object)entityId);
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> getByIdCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            public Serializable execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyById(entityId);
            }
        };
        Serializable entityValueCheck = (Serializable)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getByIdCallback, false);
        Assert.assertNotNull((Object)entityValueCheck);
        Assert.assertEquals((Object)value, (Object)entityValueCheck);
        final HashMap propsById = new HashMap();
        PropertyValueDAO.PropertyFinderCallback finderCallback = new PropertyValueDAO.PropertyFinderCallback(){

            public void handleProperty(Long id, Serializable value) {
                propsById.put(id, value);
            }
        };
        List<Long> entityIds = Collections.singletonList(entityId);
        this.propertyValueDAO.getPropertiesByIds(entityIds, finderCallback);
        Assert.assertEquals((String)"Should be exactly one value in map", (long)1L, (long)propsById.size());
        Assert.assertTrue((String)"Expected ID to be in map", (boolean)propsById.containsKey(entityId));
        Assert.assertEquals((String)"Value was not retrieved correctly", (Object)value, propsById.get(entityId));
        return entityId;
    }

    @Test
    public void testProperty_MapOfStrings() throws Exception {
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>(15);
        int i = 0;
        while (i < 20) {
            String key = "MAP-KEY-" + i;
            String value = "MAP-VALUE-" + i;
            map.put((CallSite)((Object)key), (CallSite)((Object)value));
            ++i;
        }
        this.runPropertyTest(map);
    }

    @Test
    public void testProperty_MapOfMapOfSerializables() throws Exception {
        HashMap<CallSite, CompositeName> mapInner = new HashMap<CallSite, CompositeName>(15);
        int i = 0;
        while (i < 20) {
            String key = "INNERMAP-KEY-" + i;
            CompositeName value = new CompositeName("INNERMAP-VALUE-" + i);
            mapInner.put((CallSite)((Object)key), value);
            ++i;
        }
        HashMap<CallSite, HashMap<CallSite, CompositeName>> mapOuter = new HashMap<CallSite, HashMap<CallSite, CompositeName>>(37);
        int i2 = 0;
        while (i2 < 2) {
            String key = "OUTERMAP-KEY-" + i2;
            mapOuter.put((CallSite)((Object)key), mapInner);
            ++i2;
        }
        this.runPropertyTest(mapOuter);
    }

    @Test
    public void testProperty_MapOfMapOfStrings() throws Exception {
        HashMap<CallSite, CallSite> mapInner = new HashMap<CallSite, CallSite>(15);
        int i = 0;
        while (i < 20) {
            String key = "INNERMAP-KEY-" + i;
            String value = "INNERMAP-VALUE-" + i;
            mapInner.put((CallSite)((Object)key), (CallSite)((Object)value));
            ++i;
        }
        HashMap<CallSite, HashMap<CallSite, CallSite>> mapOuter = new HashMap<CallSite, HashMap<CallSite, CallSite>>(37);
        int i2 = 0;
        while (i2 < 2) {
            String key = "OUTERMAP-KEY-" + i2;
            mapOuter.put((CallSite)((Object)key), mapInner);
            ++i2;
        }
        this.runPropertyTest(mapOuter);
    }

    @Test
    public void testProperty_CollectionOfStrings() throws Exception {
        ArrayList<CallSite> list = new ArrayList<CallSite>(20);
        int i = 0;
        while (i < 20) {
            String value = "COLL-VALUE-" + i;
            list.add((CallSite)((Object)value));
            ++i;
        }
        this.runPropertyTest(list);
    }

    @Test
    public void testProperty_UpdateCollection() throws Exception {
        final ArrayList<Object> list = new ArrayList<Object>(20);
        int i = 0;
        while (i < 20) {
            String value = "COLL-VALUE-" + i;
            list.add(value);
            ++i;
        }
        final Long propId = this.runPropertyTest(list);
        list.add("Additional value");
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> updateAndGetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            public Serializable execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.updateProperty(propId, (Serializable)list);
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyById(propId);
            }
        };
        Serializable entityValueCheck = (Serializable)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateAndGetCallback, false);
        Assert.assertNotNull((Object)entityValueCheck);
        Assert.assertEquals(list, (Object)entityValueCheck);
    }

    @Test
    public void testProperty_Delete() throws Exception {
        ArrayList list = new ArrayList(20);
        final Long propId = this.runPropertyTest(list);
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            public Serializable execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.deleteProperty(propId);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteCallback, false);
        RetryingTransactionHelper.RetryingTransactionCallback<Serializable> failedGetCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            public Serializable execute() throws Throwable {
                return PropertyValueDAOTest.this.propertyValueDAO.getPropertyById(propId);
            }
        };
        try {
            Serializable entityValueCheck = (Serializable)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)failedGetCallback, false);
            Assert.fail((String)("Deleted property should not be gettable.  Got: " + String.valueOf(entityValueCheck)));
        }
        catch (Throwable throwable) {}
    }

    @Test
    public void testPropertyClass_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyClass();
    }

    @Test
    public void testPropertyDateValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyDateValue();
    }

    @Test
    public void testPropertyStringValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyStringValue();
    }

    @Test
    public void testPropertyDoubleValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertyDoubleValue();
    }

    @Test
    public void testPropertySerializableValue_NoCache() throws Exception {
        this.removeCaches();
        this.testPropertySerializableValue();
    }

    @Test
    public void testPropertyUniqueContext() throws Exception {
        final String aaa = GUID.generate();
        final String bbb = GUID.generate();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Pair nullPair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext(null, null, null);
                if (nullPair != null) {
                    PropertyValueDAOTest.this.propertyValueDAO.deletePropertyUniqueContext((Long)nullPair.getFirst());
                }
                PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext(null, null, null, (Serializable)((Object)"A VALUE"));
                try {
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext(null, null, null, (Serializable)((Object)"A VALUE"));
                    Assert.fail((String)"Failed to throw exception creating duplicate property unique context");
                }
                catch (PropertyUniqueConstraintViolation propertyUniqueConstraintViolation) {}
                return null;
            }
        }, false);
        final Long id = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return (Long)PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)aaa), null).getFirst();
            }
        }, false);
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)aaa), null);
                    return null;
                }
            }, false);
            Assert.fail((String)"Failed to throw exception creating duplicate property unique context");
        }
        catch (PropertyUniqueConstraintViolation propertyUniqueConstraintViolation) {}
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    PropertyValueDAOTest.this.propertyValueDAO.updatePropertyUniqueContextKeys(id, (Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)bbb));
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)aaa), null);
                    PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)bbb), null);
                    return null;
                }
            }, false);
            Assert.fail((String)"Failed to throw exception creating duplicate property unique context");
        }
        catch (PropertyUniqueConstraintViolation propertyUniqueConstraintViolation) {}
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.deletePropertyUniqueContext(id);
                PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)"A"), (Serializable)((Object)"AA"), (Serializable)((Object)bbb), null);
                return null;
            }
        }, false);
    }

    @Test
    public void testPropertyUniqueContextValue() throws Exception {
        final String aaa = GUID.generate();
        final String bbb = GUID.generate();
        final String ccc = GUID.generate();
        final String v1 = GUID.generate();
        final String v2 = GUID.generate();
        Long id = (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return (Long)PropertyValueDAOTest.this.propertyValueDAO.createPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc), null).getFirst();
            }
        }, false);
        Pair v0Pair = new Pair((Object)id, null);
        Pair v1Pair = new Pair((Object)id, (Object)v1);
        Pair v2Pair = new Pair((Object)id, (Object)v2);
        Pair pair = null;
        pair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                Pair pair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc));
                if (pair.getSecond() == null) {
                    return new Pair((Object)((Long)pair.getFirst()), null);
                }
                Serializable value = PropertyValueDAOTest.this.propertyValueDAO.getPropertyById((Long)pair.getSecond());
                return new Pair((Object)((Long)pair.getFirst()), (Object)value);
            }
        }, true);
        Assert.assertEquals((String)"ID-value pair incorrect", (Object)v0Pair, (Object)pair);
        pair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.updatePropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc), (Serializable)((Object)v1));
                Pair pair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc));
                Serializable value = PropertyValueDAOTest.this.propertyValueDAO.getPropertyById((Long)pair.getSecond());
                return new Pair((Object)((Long)pair.getFirst()), (Object)value);
            }
        }, false);
        Assert.assertEquals((String)"ID-value pair incorrect", (Object)v1Pair, (Object)pair);
        pair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, Serializable>>(){

            public Pair<Long, Serializable> execute() throws Throwable {
                PropertyValueDAOTest.this.propertyValueDAO.updatePropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc), (Serializable)((Object)v2));
                Pair pair = PropertyValueDAOTest.this.propertyValueDAO.getPropertyUniqueContext((Serializable)((Object)aaa), (Serializable)((Object)bbb), (Serializable)((Object)ccc));
                Serializable value = PropertyValueDAOTest.this.propertyValueDAO.getPropertyById((Long)pair.getSecond());
                return new Pair((Object)((Long)pair.getFirst()), (Object)value);
            }
        }, false);
        Assert.assertEquals((String)"ID-value pair incorrect", (Object)v2Pair, (Object)pair);
    }

    @Test
    @Ignore(value="The functionality is not ready, yet")
    public void testScriptCanDeleteUnusedProps() {
        PropValGenerator valueGen = new PropValGenerator(this.propertyValueDAO);
        final String stringValue = valueGen.createUniqueString();
        final Double doubleValue = valueGen.createUniqueDouble();
        final Date dateValue = valueGen.createUniqueDate();
        final Serializable serValue = valueGen.createUniqueSerializable();
        final HashMap persistedIDs = new HashMap();
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                persistedIDs.put(stringValue, (Long)PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyStringValue(stringValue).getFirst());
                persistedIDs.put(doubleValue, (Long)PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyDoubleValue(doubleValue).getFirst());
                persistedIDs.put(dateValue, (Long)PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyDateValue(dateValue).getFirst());
                persistedIDs.put(serValue, (Long)PropertyValueDAOTest.this.propertyValueDAO.getOrCreatePropertyValue(serValue).getFirst());
                return null;
            }
        });
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((Object)stringValue, (Object)PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValue).getSecond());
                Assert.assertEquals((Object)doubleValue, (Object)PropertyValueDAOTest.this.propertyValueDAO.getPropertyDoubleValue(doubleValue).getSecond());
                Assert.assertEquals((Object)dateValue, (Object)PropertyValueDAOTest.this.propertyValueDAO.getPropertyDateValue(dateValue).getSecond());
                Assert.assertEquals((Object)serValue, (Object)PropertyValueDAOTest.this.propertyValueDAO.getPropertyValueById((Long)persistedIDs.get(serValue)).getSecond());
                PropertyValueDAOTest.this.propertyValueDAO.cleanupUnusedValues();
                return null;
            }
        });
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyValueDAOTest.this.assertPropDeleted(PropertyValueDAOTest.this.propertyValueDAO.getPropertyStringValue(stringValue));
                PropertyValueDAOTest.this.assertPropDeleted(PropertyValueDAOTest.this.propertyValueDAO.getPropertyDoubleValue(doubleValue));
                try {
                    PropertyValueDAOTest.this.propertyValueDAO.getPropertyValueById((Long)persistedIDs.get(serValue));
                    Assert.fail((String)String.format("Persisted %s was not deleted, but should have been.", serValue.getClass().getSimpleName()));
                }
                catch (DataIntegrityViolationException dataIntegrityViolationException) {}
                return null;
            }
        });
    }

    private void assertPropDeleted(Pair<Long, ?> value) {
        if (value != null) {
            String msg = String.format("Property value [%s=%s] should have been deleted by cleanup script.", value.getSecond().getClass().getSimpleName(), value.getSecond());
            Assert.fail((String)msg);
        }
    }

    private static enum TEST_NUMBERS {
        ONE,
        TWO,
        THREE;

    }
}

