/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.action;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;

public class ActionParameterField
implements Field {
    private FieldDefinition fieldDef;
    private String name;

    public ActionParameterField(ParameterDefinition parameterDef, ActionService actionService) {
        this.name = parameterDef.getName();
        QName type = parameterDef.getType();
        List<PropertyFieldDefinition.FieldConstraint> fieldConstraints = this.processActionConstraints(parameterDef, actionService);
        if (DataTypeDefinition.NODE_REF.equals((Object)type) && fieldConstraints.isEmpty()) {
            this.fieldDef = new AssociationFieldDefinition(this.name, "cm:cmobject", AssociationFieldDefinition.Direction.TARGET);
            AssociationFieldDefinition assocFieldDef = (AssociationFieldDefinition)this.fieldDef;
            assocFieldDef.setEndpointMandatory(parameterDef.isMandatory());
            assocFieldDef.setEndpointMany(parameterDef.isMultiValued());
        } else {
            this.fieldDef = DataTypeDefinition.NODE_REF.equals((Object)type) ? new PropertyFieldDefinition(this.name, DataTypeDefinition.TEXT.getLocalName()) : new PropertyFieldDefinition(this.name, type.getLocalName());
            PropertyFieldDefinition propFieldDef = (PropertyFieldDefinition)this.fieldDef;
            propFieldDef.setMandatory(parameterDef.isMandatory());
            propFieldDef.setRepeating(parameterDef.isMultiValued());
            if (!fieldConstraints.isEmpty()) {
                propFieldDef.setConstraints(fieldConstraints);
            }
        }
        this.fieldDef.setDescription(parameterDef.getName());
        this.fieldDef.setLabel(parameterDef.getDisplayLabel());
        this.fieldDef.setDataKeyName(this.name);
    }

    private List<PropertyFieldDefinition.FieldConstraint> processActionConstraints(ParameterDefinition parameterDef, ActionService actionService) {
        List<PropertyFieldDefinition.FieldConstraint> fieldConstraints = Collections.emptyList();
        String paramConstraintName = parameterDef.getParameterConstraintName();
        if (paramConstraintName != null) {
            ParameterConstraint paramConstraint = actionService.getParameterConstraint(paramConstraintName);
            if (paramConstraint == null) {
                throw new FormException("ParameterConstraint name '" + paramConstraintName + "' not recognised.");
            }
            Map<String, String> allowableValuesMap = paramConstraint.getAllowableValues();
            ArrayList<CallSite> pipeSeparatedAllowedValues = new ArrayList<CallSite>(allowableValuesMap.size());
            for (Map.Entry<String, String> entry : allowableValuesMap.entrySet()) {
                pipeSeparatedAllowedValues.add((CallSite)((Object)(entry.getKey() + "|" + entry.getValue())));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("allowedValues", pipeSeparatedAllowedValues);
            fieldConstraints = new ArrayList<PropertyFieldDefinition.FieldConstraint>(allowableValuesMap.size());
            fieldConstraints.add(new PropertyFieldDefinition.FieldConstraint("LIST", params));
        }
        return fieldConstraints;
    }

    @Override
    public FieldDefinition getFieldDefinition() {
        return this.fieldDef;
    }

    @Override
    public String getFieldName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return null;
    }
}

