/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.Arrays;
import java.util.List;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={BaseSpringTestsCategory.class})
public class PrimaryKeyTest
extends DbObjectTestBase<PrimaryKey> {
    private PrimaryKey thisPK;
    private PrimaryKey thatPK;
    private Table parent;

    @Before
    public void setUp() {
        this.parent = new Table("parent_table");
        this.thisPK = new PrimaryKey(this.parent, "this_pk", this.columns("id", "name", "age"), this.columnOrders(2, 1, 3));
        this.thatPK = new PrimaryKey(this.parent, "that_pk", this.columns("a", "b"), this.columnOrders(1, 2));
    }

    @Override
    protected PrimaryKey getThisObject() {
        return this.thisPK;
    }

    @Override
    protected PrimaryKey getThatObject() {
        return this.thatPK;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimpleOrderedLists(new DbProperty((DbObject)this.thisPK, "columnNames"), new DbProperty((DbObject)this.thatPK, "columnNames"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimpleOrderedLists(new DbProperty((DbObject)this.thisPK, "columnOrders"), new DbProperty((DbObject)this.thatPK, "columnOrders"), this.ctx);
    }

    @Test
    public void acceptVisitor() {
        this.thisPK.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit((DbObject)this.thisPK);
    }

    @Test
    public void sameAs() {
        Assert.assertTrue((String)"Primary keys should be logically equivalent", (boolean)this.thisPK.sameAs((DbObject)new PrimaryKey(this.parent, "this_pk", this.columns("id", "name", "age"), this.columnOrders(2, 1, 3))));
        Assert.assertTrue((String)"Primary keys should be logically equivalent", (boolean)this.thisPK.sameAs((DbObject)new PrimaryKey(this.parent, "different_name", this.columns("id", "name", "age"), this.columnOrders(2, 1, 3))));
        Assert.assertTrue((String)"PKs should be the same", (boolean)this.thisPK.sameAs((DbObject)this.thisPK));
        Assert.assertTrue((String)"Primary keys should be logically equivalent", (boolean)this.thisPK.sameAs((DbObject)new PrimaryKey(this.parent, "different_name", this.columns("di", "eman", "ega"), this.columnOrders(1, 2, 3))));
        Assert.assertFalse((String)"PKs are never the same as a non-PK", (boolean)this.thisPK.sameAs((DbObject)new Index(this.parent, "wrong_type", this.columns(new String[0]))));
        Table otherParent = new Table("other_parent");
        Assert.assertFalse((String)"PKs should be considered different (different parents)", (boolean)this.thisPK.sameAs((DbObject)new PrimaryKey(otherParent, "this_pk", this.columns("id", "name", "age"), this.columnOrders(2, 1, 3))));
        Assert.assertFalse((String)"PKs should not be considered the same (other PK is null)", (boolean)this.thisPK.sameAs(null));
    }

    private List<String> columns(String ... columns) {
        return Arrays.asList(columns);
    }

    private List<Integer> columnOrders(Integer ... columnOrders) {
        return Arrays.asList(columnOrders);
    }
}

