/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEventGenerationBehaviours {
    protected static Log logger = LogFactory.getLog(AbstractEventGenerationBehaviours.class);
    protected Set<String> includeEventTypes;
    protected PolicyComponent policyComponent;
    protected List<BehaviourDefinition<ClassBehaviourBinding>> behaviours = new LinkedList<BehaviourDefinition<ClassBehaviourBinding>>();

    protected void addBehaviour(BehaviourDefinition<ClassBehaviourBinding> binding) {
        this.behaviours.add(binding);
        logger.debug((Object)("Added policy binding " + String.valueOf(binding)));
    }

    protected void removeBehaviour(BehaviourDefinition<ClassBehaviourBinding> binding) {
        this.removeBehaviourImpl(binding);
        this.behaviours.remove(binding);
    }

    protected void removeBehaviourImpl(BehaviourDefinition<ClassBehaviourBinding> binding) {
        this.policyComponent.removeClassDefinition(binding);
        logger.debug((Object)("Removed policy binding " + String.valueOf(binding)));
    }

    public void cleanUp() {
        for (BehaviourDefinition<ClassBehaviourBinding> binding : this.behaviours) {
            this.removeBehaviourImpl(binding);
        }
    }

    public void setIncludeEventTypes(String includeEventTypesStr) {
        StringTokenizer st = new StringTokenizer(includeEventTypesStr, ",");
        this.includeEventTypes = new HashSet<String>();
        while (st.hasMoreTokens()) {
            String eventType = st.nextToken().trim();
            this.includeEventTypes.add(eventType);
        }
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    protected boolean includeEventType(String eventType) {
        return this.includeEventTypes.contains(eventType);
    }

    protected void bindClassPolicy(QName policyName, String eventTypeToCheck) {
        this.bindClassPolicy(policyName, ContentModel.TYPE_BASE, eventTypeToCheck);
    }

    protected void bindClassPolicy(QName policyName, QName className, String eventTypeToCheck) {
        if (eventTypeToCheck != null && !this.includeEventType(eventTypeToCheck)) {
            return;
        }
        BehaviourDefinition<ClassBehaviourBinding> binding = this.policyComponent.bindClassBehaviour(policyName, className, (Behaviour)new JavaBehaviour(this, policyName.getLocalName()));
        this.addBehaviour(binding);
    }

    protected void bindAssociationPolicy(QName policyName, String eventTypeToCheck) {
        if (!this.includeEventType(eventTypeToCheck)) {
            return;
        }
        this.policyComponent.bindAssociationBehaviour(policyName, ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour(this, policyName.getLocalName()));
    }

    protected void bindClassPolicy(QName policyName) {
        this.bindClassPolicy(policyName, null);
    }
}

