/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.GUID;

public class TransactionBehaviourQueue
implements TransactionListener {
    private String id = GUID.generate();
    private static final String QUEUE_CONTEXT_KEY = TransactionBehaviourQueue.class.getName() + ".context";

    public <P extends Policy> void queue(Behaviour behaviour, PolicyDefinition<P> definition, P policyInterface, Method method, Object[] args) {
        ExecutionInstanceKey key;
        ExecutionContext executionContext;
        QueueContext queueContext = (QueueContext)AlfrescoTransactionSupport.getResource((Object)QUEUE_CONTEXT_KEY);
        if (queueContext == null) {
            queueContext = new QueueContext();
            AlfrescoTransactionSupport.bindResource((Object)QUEUE_CONTEXT_KEY, (Object)queueContext);
            AlfrescoTransactionSupport.bindListener(this);
        }
        if ((executionContext = queueContext.index.get(key = new ExecutionInstanceKey(behaviour, definition.getArguments(), args))) == null) {
            executionContext = new ExecutionContext();
            executionContext.method = method;
            executionContext.args = args;
            executionContext.policyInterface = policyInterface;
            if (!queueContext.committed) {
                queueContext.queue.offer(executionContext);
            } else {
                this.execute(executionContext);
            }
            queueContext.index.put(key, executionContext);
        } else {
            Policy.Arg[] argDefs = definition.getArguments();
            int i = 0;
            while (i < argDefs.length) {
                if (argDefs[i].equals((Object)Policy.Arg.END_VALUE)) {
                    executionContext.args[i] = args[i];
                }
                ++i;
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        QueueContext queueContext = (QueueContext)AlfrescoTransactionSupport.getResource((Object)QUEUE_CONTEXT_KEY);
        ExecutionContext context = queueContext.queue.poll();
        while (context != null) {
            this.execute(context);
            context = queueContext.queue.poll();
        }
        queueContext.committed = true;
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterRollback() {
    }

    private void execute(ExecutionContext context) {
        try {
            context.method.invoke(context.policyInterface, context.args);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to execute transaction-level behaviour " + String.valueOf(context.method) + " in transaction " + AlfrescoTransactionSupport.getTransactionId() + " : " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AlfrescoRuntimeException("Failed to execute transaction-level behaviour " + String.valueOf(context.method) + " in transaction " + AlfrescoTransactionSupport.getTransactionId() + " : " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = e.getMessage() + (String)(e.getTargetException() != null ? "(" + e.getTargetException().getMessage() + ")" : "");
            throw new AlfrescoRuntimeException("Failed to execute transaction-level behaviour " + String.valueOf(context.method) + " in transaction " + AlfrescoTransactionSupport.getTransactionId() + " : " + msg, e.getTargetException());
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransactionBehaviourQueue) {
            TransactionBehaviourQueue that = (TransactionBehaviourQueue)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    private class ExecutionContext<P extends Policy> {
        Method method;
        Object[] args;
        P policyInterface;

        private ExecutionContext() {
        }
    }

    private class ExecutionInstanceKey {
        Behaviour behaviour;
        ArrayList<Object> keys = new ArrayList();

        public ExecutionInstanceKey(Behaviour behaviour, Policy.Arg[] argDefs, Object[] args) {
            this.behaviour = behaviour;
            int i = 0;
            while (i < argDefs.length) {
                if (argDefs[i].equals((Object)Policy.Arg.KEY)) {
                    this.keys.add(args[i]);
                }
                ++i;
            }
        }

        public int hashCode() {
            int key = this.behaviour.hashCode();
            int i = 0;
            while (i < this.keys.size()) {
                key = 37 * key + this.keys.get(i).hashCode();
                ++i;
            }
            return key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExecutionInstanceKey) {
                ExecutionInstanceKey that = (ExecutionInstanceKey)obj;
                if (this.behaviour.equals(that.behaviour)) {
                    if (this.keys.size() != that.keys.size()) {
                        return false;
                    }
                    if (this.keys.containsAll(that.keys)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }

    private class QueueContext {
        Queue<ExecutionContext> queue = new LinkedList<ExecutionContext>();
        Map<ExecutionInstanceKey, ExecutionContext> index = new HashMap<ExecutionInstanceKey, ExecutionContext>();
        boolean committed = false;

        private QueueContext() {
        }
    }
}

