/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.handler;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.search.impl.solr.facet.FacetQueryProvider;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetConfigException;
import org.alfresco.repo.search.impl.solr.facet.handler.AbstractFacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ContentSizeBucketsDisplayHandler
extends AbstractFacetLabelDisplayHandler
implements FacetQueryProvider {
    private static final Pattern SIZE_RANGE_PATTERN = Pattern.compile("(\\[\\d+\\sTO\\s(\\d+|MAX)\\])");
    private final Map<String, FacetLabel> facetLabelMap;
    private final Map<String, List<String>> facetQueriesMap;

    public ContentSizeBucketsDisplayHandler(Set<String> facetQueryFields, LinkedHashMap<String, String> sizeBucketsMap) {
        ParameterCheck.mandatory((String)"facetQueryFields", facetQueryFields);
        ParameterCheck.mandatory((String)"sizeBucketsMap", sizeBucketsMap);
        this.supportedFieldFacets = Collections.unmodifiableSet(facetQueryFields);
        this.facetLabelMap = new HashMap<String, FacetLabel>(sizeBucketsMap.size());
        LinkedHashMap facetQueries = new LinkedHashMap(facetQueryFields.size());
        for (String facetQueryField : facetQueryFields) {
            ArrayList<CallSite> queries = new ArrayList<CallSite>();
            int index = 0;
            for (Map.Entry<String, String> bucket : sizeBucketsMap.entrySet()) {
                String sizeRange = bucket.getKey().trim();
                Matcher matcher = SIZE_RANGE_PATTERN.matcher(sizeRange);
                if (!matcher.find()) {
                    throw new SolrFacetConfigException("Invalid size range. Example of a valid size range is: [0 TO 1024]");
                }
                String facetQuery = facetQueryField + ":" + sizeRange;
                queries.add((CallSite)((Object)facetQuery));
                String sizeRangeQuery = sizeRange.substring(1, sizeRange.length() - 1);
                sizeRangeQuery = sizeRangeQuery.replaceFirst("\\sTO\\s", "\"..\"");
                this.facetLabelMap.put(facetQuery, new FacetLabel(sizeRangeQuery, bucket.getValue(), index++));
            }
            facetQueries.put(facetQueryField, queries);
        }
        this.facetQueriesMap = Collections.unmodifiableMap(facetQueries);
    }

    @Override
    public FacetLabel getDisplayLabel(String value) {
        FacetLabel facetLabel = this.facetLabelMap.get(value);
        return facetLabel == null ? new FacetLabel(value, value, -1) : facetLabel;
    }

    @Override
    public Map<String, List<String>> getFacetQueries() {
        return this.facetQueriesMap;
    }
}

