/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.List;
import java.util.Set;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssocSourceTypeIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(AssocSourceTypeIntegrityEvent.class);

    public AssocSourceTypeIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef sourceNodeRef, QName assocTypeQName) {
        super(nodeService, dictionaryService, sourceNodeRef, assocTypeQName, null);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        QName assocTypeQName = this.getTypeQName();
        NodeRef sourceNodeRef = this.getNodeRef();
        QName sourceNodeTypeQName = this.getNodeType(sourceNodeRef);
        if (sourceNodeTypeQName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring integrity check - node gone: \n   event: " + String.valueOf(this)));
            }
            return;
        }
        AssociationDefinition assocDef = this.getAssocDef(eventResults, assocTypeQName);
        if (assocDef == null) {
            IntegrityRecord result = new IntegrityRecord("Association type does not exist: \n   Source Node: " + String.valueOf(sourceNodeRef) + "\n   Source Node Type: " + String.valueOf(sourceNodeTypeQName) + "\n   Association Type: " + String.valueOf(assocTypeQName));
            eventResults.add(result);
            return;
        }
        this.checkSourceType(eventResults, assocDef, sourceNodeRef, sourceNodeTypeQName);
    }

    protected void checkSourceType(List<IntegrityRecord> eventResults, AssociationDefinition assocDef, NodeRef sourceNodeRef, QName sourceNodeTypeQName) {
        ClassDefinition sourceDef = assocDef.getSourceClass();
        if (sourceDef instanceof TypeDefinition) {
            if (!this.dictionaryService.isSubClass(sourceNodeTypeQName, sourceDef.getName())) {
                IntegrityRecord result = new IntegrityRecord("The association source type is incorrect: \n   Source Node: " + String.valueOf(sourceNodeRef) + "\n   Association: " + String.valueOf(assocDef) + "\n   Required Source Type: " + String.valueOf(sourceDef.getName()) + "\n   Actual Source Type: " + String.valueOf(sourceNodeTypeQName));
                eventResults.add(result);
            }
        } else if (sourceDef instanceof AspectDefinition) {
            Set sourceAspects = this.nodeService.getAspects(sourceNodeRef);
            boolean found = false;
            for (QName sourceAspectTypeQName : sourceAspects) {
                if (!this.dictionaryService.isSubClass(sourceAspectTypeQName, sourceDef.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                if (assocDef.isChild() ? this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)assocDef.getName(), RegexQNamePattern.MATCH_ALL).size() == 0 : this.nodeService.getTargetAssocs(sourceNodeRef, (QNamePattern)assocDef.getName()).size() == 0) {
                    return;
                }
                IntegrityRecord result = new IntegrityRecord("The association source is missing the aspect required for this association: \n   Source Node: " + String.valueOf(sourceNodeRef) + "\n   Association: " + String.valueOf(assocDef) + "\n   Required Source Aspect: " + String.valueOf(sourceDef.getName()) + "\n   Actual Source Aspects: " + String.valueOf(sourceAspects));
                eventResults.add(result);
            }
        } else {
            IntegrityRecord result = new IntegrityRecord("Unknown ClassDefinition subclass on the source definition: \n   Source Node: " + String.valueOf(sourceNodeRef) + "\n   Association: " + String.valueOf(assocDef) + "\n   Source Definition: " + String.valueOf(sourceDef.getName()));
            eventResults.add(result);
        }
    }
}

