/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.webdav.MTNodesCache2;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.webdav.WebDavService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.springframework.extensions.surf.util.URLEncoder;

public class WebDavServiceImpl
implements WebDavService {
    public static final String WEBDAV_PREFIX = "webdav";
    private boolean enabled = false;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private FileFolderService fileFolderService;
    private MTNodesCache2 rootNode;
    private boolean activitiesEnabled;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.getNodeService());
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.getDictionaryService());
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.getFileFolderService());
        PropertyCheck.mandatory((Object)this, (String)"rootNode", (Object)this.getRootNode());
    }

    @Override
    public String getWebdavUrl(NodeRef nodeRef) {
        String url = "";
        if (!this.enabled) {
            return url;
        }
        try {
            QName typeName = this.nodeService.getType(nodeRef);
            if (this.getIsContainer(typeName) || this.getIsDocument(typeName)) {
                List<String> paths = this.fileFolderService.getNameOnlyPath(this.getRootNode().getNodeForCurrentTenant(), nodeRef);
                StringBuilder path = new StringBuilder(128);
                path.append("/webdav");
                int i = 0;
                while (i < paths.size()) {
                    path.append("/").append(URLEncoder.encode((String)paths.get(i)));
                    ++i;
                }
                url = path.toString();
            }
        }
        catch (FileFolderServiceImpl.InvalidTypeException invalidTypeException) {
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return url;
    }

    private boolean getIsContainer(QName type) {
        boolean isContainer = this.dictionaryService.isSubClass(type, ContentModel.TYPE_FOLDER) && !this.dictionaryService.isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER);
        return isContainer;
    }

    private boolean getIsDocument(QName type) {
        boolean isDocument = this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT);
        return isDocument;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public void setRootNode(MTNodesCache2 rootNode) {
        this.rootNode = rootNode;
    }

    public MTNodesCache2 getRootNode() {
        return this.rootNode;
    }

    @Override
    public boolean activitiesEnabled() {
        return this.activitiesEnabled;
    }

    public void setActivitiesEnabled(boolean enabled) {
        this.activitiesEnabled = enabled;
    }
}

