/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.util.Set;
import org.alfresco.repo.virtual.ref.AbstractProtocolMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.store.VirtualFolderDefinitionResolver;
import org.alfresco.repo.virtual.store.VirtualUserPermissions;
import org.alfresco.repo.virtual.template.FilingParameters;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.service.cmr.security.AccessStatus;

public class HasPermissionMethod
extends AbstractProtocolMethod<AccessStatus> {
    private VirtualUserPermissions userPermissions;
    private String permissionToCheck;
    private VirtualFolderDefinitionResolver resolver;

    public HasPermissionMethod(VirtualFolderDefinitionResolver resolver, VirtualUserPermissions userPermissions, String permissionToCheck) {
        this.userPermissions = userPermissions;
        this.permissionToCheck = permissionToCheck;
        this.resolver = resolver;
    }

    @Override
    public AccessStatus execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
        boolean readonly;
        VirtualFolderDefinition definition = this.resolver.resolveVirtualFolderDefinition(reference);
        FilingRule filingRule = definition.getFilingRule();
        boolean bl = readonly = filingRule.isNullFilingRule() || filingRule.filingNodeRefFor(new FilingParameters(reference)) == null;
        if (readonly) {
            Set<String> deniedPermissions = this.userPermissions.getDenyReadonlySmartNodes();
            if (deniedPermissions.contains(this.permissionToCheck)) {
                return AccessStatus.DENIED;
            }
            if ("Read".equals(this.permissionToCheck)) {
                return AccessStatus.ALLOWED;
            }
        }
        return this.userPermissions.hasVirtualNodePermission(this.permissionToCheck, readonly);
    }

    @Override
    public AccessStatus execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
        return this.userPermissions.hasQueryNodePermission(this.permissionToCheck);
    }
}

