/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.BehaviourMap;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ServiceBehaviourBinding;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.LockHelper;

class ClassBehaviourIndex<B extends ClassBehaviourBinding>
implements BehaviourIndex<B> {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private BehaviourMap<B> classMap = new BehaviourMap();
    private BehaviourMap<ServiceBehaviourBinding> serviceMap = new BehaviourMap();
    private List<BehaviourChangeObserver<B>> observers = new ArrayList<BehaviourChangeObserver<B>>();
    private BehaviourFilter filter = null;
    private long tryLockTimeout;

    public void setTryLockTimeout(long tryLockTimeout) {
        this.tryLockTimeout = tryLockTimeout;
    }

    ClassBehaviourIndex(BehaviourFilter filter) {
        this.classMap.addChangeObserver(new BehaviourChangeObserver<B>(){

            @Override
            public void addition(B binding, Behaviour behaviour) {
                for (BehaviourChangeObserver listener : ClassBehaviourIndex.this.observers) {
                    listener.addition(binding, behaviour);
                }
            }

            @Override
            public void removal(B binding, Behaviour behaviour) {
                for (BehaviourChangeObserver listener : ClassBehaviourIndex.this.observers) {
                    listener.removal(binding, behaviour);
                }
            }
        });
        this.classMap.addChangeObserver(new BehaviourChangeObserver<B>(){

            @Override
            public void addition(B binding, Behaviour behaviour) {
                for (BehaviourChangeObserver listener : ClassBehaviourIndex.this.observers) {
                    listener.addition(binding, behaviour);
                }
            }

            @Override
            public void removal(B binding, Behaviour behaviour) {
                for (BehaviourChangeObserver listener : ClassBehaviourIndex.this.observers) {
                    listener.removal(binding, behaviour);
                }
            }
        });
        this.serviceMap.addChangeObserver(new BehaviourChangeObserver<ServiceBehaviourBinding>(){

            @Override
            public void addition(ServiceBehaviourBinding binding, Behaviour behaviour) {
                for (BehaviourChangeObserver<Object> behaviourChangeObserver : ClassBehaviourIndex.this.observers) {
                    behaviourChangeObserver.addition(null, behaviour);
                }
            }

            @Override
            public void removal(ServiceBehaviourBinding binding, Behaviour behaviour) {
                for (BehaviourChangeObserver<Object> behaviourChangeObserver : ClassBehaviourIndex.this.observers) {
                    behaviourChangeObserver.removal(null, behaviour);
                }
            }
        });
        this.filter = filter;
    }

    @Override
    public Collection<BehaviourDefinition> getAll() {
        LockHelper.tryLock((Lock)this.lock.readLock(), (long)this.tryLockTimeout, (String)"getting all behavior definitions in 'ClassBehaviourIndex.getAll()'");
        try {
            ArrayList<BehaviourDefinition> all = new ArrayList<BehaviourDefinition>(this.classMap.size() + this.serviceMap.size());
            all.addAll(this.classMap.getAll());
            all.addAll(this.serviceMap.getAll());
            ArrayList<BehaviourDefinition> arrayList = all;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<BehaviourDefinition> find(B binding) {
        LockHelper.tryLock((Lock)this.lock.readLock(), (long)this.tryLockTimeout, (String)"searching behavior definitions list in 'ClassBehaviourIndex.find()'");
        try {
            ArrayList<BehaviourDefinition> behaviours = new ArrayList<BehaviourDefinition>();
            List<BehaviourDefinition<B>> behaviour = null;
            if (this.isEnabled(binding)) {
                while (binding != null) {
                    behaviour = this.classMap.get(binding);
                    if (behaviour != null) {
                        behaviours.addAll(0, behaviour);
                    }
                    binding = (ClassBehaviourBinding)((ClassBehaviourBinding)binding).generaliseBinding();
                }
            }
            behaviours.addAll(this.serviceMap.getAll());
            ArrayList<BehaviourDefinition> arrayList = behaviours;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addChangeObserver(BehaviourChangeObserver<B> observer) {
        this.observers.add(observer);
    }

    @Override
    public BehaviourFilter getFilter() {
        return this.filter;
    }

    public void putClassBehaviour(BehaviourDefinition<B> behaviour) {
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"putting behavior definition in 'ClassBehaviourIndex.putClassBehavior()'");
        try {
            this.classMap.put(behaviour);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void putServiceBehaviour(BehaviourDefinition<ServiceBehaviourBinding> behaviour) {
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"putting behavior definition in 'ClassBehaviourIndex.putServiceBehavior()'");
        try {
            this.serviceMap.put(behaviour);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeClassBehaviour(BehaviourDefinition<B> behaviour) {
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)this.tryLockTimeout, (String)"removing behavior definition in 'ClassBehaviourIndex.removeClassBehavior()'");
        try {
            this.classMap.remove(behaviour);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean isEnabled(B binding) {
        boolean isEnabled = true;
        if (this.filter != null) {
            NodeRef nodeRef = ((ClassBehaviourBinding)binding).getNodeRef();
            QName className = ((ClassBehaviourBinding)binding).getClassQName();
            isEnabled = nodeRef == null ? this.filter.isEnabled(className) : this.filter.isEnabled(nodeRef, className);
        }
        return isEnabled;
    }
}

