/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.schedule;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.quartz.SchedulerAccessorBean;

public class AlfrescoSchedulerAccessorBean
extends SchedulerAccessorBean
implements DisposableBean {
    @Nullable
    private List<TriggerKey> triggerKeys;
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTriggers(Trigger ... triggers) {
        super.setTriggers(triggers);
        this.triggerKeys = Arrays.stream(triggers).map(Trigger::getKey).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws SchedulerException {
        if (this.isEnabled()) {
            super.afterPropertiesSet();
        }
    }

    public void destroy() throws Exception {
        this.getScheduler().unscheduleJobs(this.triggerKeys);
    }
}

